/*
 * Decompiled with CFR 0.152.
 */
package ix.util.context;

import ix.util.Debug;
import ix.util.context.BasicContextHolder;
import ix.util.context.Context;
import ix.util.context.ContextHolder;
import ix.util.context.ContextHoldingStrategy;

public class ThreadLocalHoldingStrategy
extends ContextHoldingStrategy {
    protected ThreadLocal<ContextHolder> threadContextHolder = new ThreadLocal<ContextHolder>(){

        @Override
        protected ContextHolder initialValue() {
            return ThreadLocalHoldingStrategy.this.initialHolder();
        }
    };

    protected ContextHolder initialHolder() {
        Debug.noteln("Creating context holder for", (Object)Thread.currentThread());
        return new BasicContextHolder();
    }

    public ContextHolder getContextHolder() {
        return this.threadContextHolder.get();
    }

    public void setContextHolder(ContextHolder contextHolder) {
        this.threadContextHolder.set(contextHolder);
    }

    public void clearContexts() {
        this.threadContextHolder.get().setContext(Context.rootContext);
    }
}

