/*
 * Decompiled with CFR 0.152.
 */
package ix.util.http;

import ix.util.Debug;
import ix.util.Parameters;
import ix.util.RethrownException;
import ix.util.http.HttpRequestException;
import ix.util.http.HttpServer;
import ix.util.http.HttpUtilities;
import ix.util.lisp.SafeLispInterpreter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class HttpObjectServlet
extends HttpServlet {
    protected HttpUtilities util = new HttpUtilities();
    protected String responseContentType = "application/xml";
    protected String responseCharsetName = "UTF-8";

    public void setResponseContentType(String string) {
        this.responseContentType = string;
    }

    public void setResponseCharsetName(String string) {
        this.responseCharsetName = string;
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        Object object2;
        String string;
        this.describeRequest(httpServletRequest);
        try {
            string = this.readRequest(httpServletRequest);
        }
        catch (HttpRequestException httpRequestException) {
            Debug.displayException("Problem reading request", httpRequestException);
            httpServletResponse.sendError(httpRequestException.getStatus(), httpRequestException.getReason());
            return;
        }
        Debug.noteln("Received:\n", (Object)string);
        try {
            object2 = this.decodeReceived(string);
            object = this.handleRequest(httpServletRequest, object2);
        }
        catch (HttpRequestException httpRequestException) {
            Debug.noteln("Identified problem handling request", (Object)httpRequestException);
            httpServletResponse.sendError(httpRequestException.getStatus(), httpRequestException.getReason());
            return;
        }
        catch (Throwable throwable) {
            Debug.displayException("Problem handling request", throwable);
            httpServletResponse.sendError(500, "Internal server error: " + Debug.describeException(throwable));
            return;
        }
        object2 = this.encodeForSend(object);
        try {
            this.sendResponse((byte[])object2, httpServletResponse);
        }
        catch (Throwable throwable) {
            Debug.displayException("Problem sending reply", throwable);
            throw new RethrownException(throwable);
        }
    }

    protected void describeRequest(HttpServletRequest httpServletRequest) {
        Debug.noteln("HTTP request URI:", (Object)httpServletRequest.getRequestURI());
        Debug.noteln("Request from " + httpServletRequest.getRemoteHost() + " " + httpServletRequest.getRemoteAddr());
        String string = httpServletRequest.getQueryString();
        if (string != null) {
            Debug.noteln("Query string:", (Object)string);
        }
        Debug.noteln("Request headers:");
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Debug.noteln(string2 + ": " + httpServletRequest.getHeader(string2));
        }
    }

    protected String readRequest(HttpServletRequest httpServletRequest) throws HttpRequestException, IOException {
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        String string = httpServletRequest.getContentType();
        String string2 = httpServletRequest.getCharacterEncoding();
        int n = httpServletRequest.getContentLength();
        Debug.noteln("Request Content-Type: " + string + "; charset=" + string2 + "; length=" + n);
        try {
            String string3 = this.util.readContent((InputStream)servletInputStream, n, string2);
            return string3;
        }
        catch (EOFException eOFException) {
            throw new HttpRequestException(400, "Data ended prematurely.");
        }
        finally {
            servletInputStream.close();
        }
    }

    protected Object decodeReceived(String string) {
        return this.util.decodeReceived(string);
    }

    protected abstract Object handleRequest(HttpServletRequest var1, Object var2) throws HttpRequestException;

    protected byte[] encodeForSend(Object object) throws UnsupportedEncodingException {
        return this.util.encodeForSend(object, this.responseCharsetName);
    }

    protected void sendResponse(byte[] byArray, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setContentType(this.responseContentType);
        httpServletResponse.setCharacterEncoding(this.responseCharsetName);
        httpServletResponse.setContentLength(byArray.length);
        httpServletResponse.setStatus(200);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        servletOutputStream.write(byArray);
        servletOutputStream.flush();
        servletOutputStream.close();
    }

    public static void main(String[] stringArray) {
        Parameters.processCommandLineArguments(stringArray);
        SafeLispInterpreter safeLispInterpreter = new SafeLispInterpreter();
        int n = Parameters.getInt("http-server-port", 0);
        HttpServer httpServer = new HttpServer(n);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class TestServlet
        extends HttpObjectServlet {
            final /* synthetic */ SafeLispInterpreter val$lin;

            TestServlet(SafeLispInterpreter safeLispInterpreter) {
                this.val$lin = safeLispInterpreter;
            }

            @Override
            protected Object handleRequest(HttpServletRequest httpServletRequest, Object object) {
                return this.val$lin.topLevelEval(object);
            }
        }
        httpServer.addServlet(new TestServlet(safeLispInterpreter), "/take");
        class EchoServlet
        extends HttpObjectServlet {
            EchoServlet() {
            }

            protected Object handleRequest(HttpServletRequest httpServletRequest, Object object) {
                return object;
            }
        }
        httpServer.addServlet(new EchoServlet(), "/echo");
        httpServer.start();
    }
}

