/*
 * Decompiled with CFR 0.152.
 */
package ix.util.http;

import ix.util.Debug;
import ix.util.Parameters;
import ix.util.RethrownException;
import ix.util.Strings;
import ix.util.Util;
import ix.util.http.HelloServlet;
import ix.util.http.HttpUtilities;
import java.net.UnknownHostException;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.NCSARequestLog;
import org.mortbay.jetty.RequestLog;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.handler.RequestLogHandler;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;

public class HttpServer {
    private int listenPort = 0;
    private String docRoot = null;
    private String docPath = null;
    private String logDir = null;
    private String logPrefix = null;
    private Server server;
    private Connector socketListener;
    private ContextHandlerCollection contexts;
    private ServletHandler servlets;
    private HttpUtilities util = new HttpUtilities();

    public HttpServer(int n) {
        this.listenPort = n;
        this.initialSetup();
    }

    public static void main(String[] stringArray) {
        Parameters.processCommandLineArguments(stringArray);
        String string = Parameters.getParameter("http-root-directory");
        int n = Parameters.getInt("http-server-port", 0);
        HttpServer httpServer = new HttpServer(n);
        if (string != null) {
            httpServer.parseDocRoot(string, "files");
        }
        httpServer.addServlet(new HelloServlet("Hello!"), "/hello/*");
        httpServer.addServlet(new HelloServlet("Bye!"), "/bye/*");
        httpServer.start();
        httpServer.join();
    }

    public synchronized int getServerPort() {
        return this.socketListener.getLocalPort();
    }

    public String getBaseUrl() {
        try {
            return "http://" + Util.getHostName() + ":" + this.getServerPort() + "/";
        }
        catch (UnknownHostException unknownHostException) {
            throw new RethrownException(unknownHostException);
        }
    }

    public synchronized String getDocRoot() {
        return this.docRoot;
    }

    public synchronized String getDocPath() {
        return this.docPath;
    }

    public synchronized void setDocRoot(String string, String string2) {
        this.docRoot = string;
        this.docPath = string2;
    }

    public void parseDocRoot(String string, String string2) {
        String[] stringArray = Strings.breakAtFirst(":", string);
        if (stringArray[1].equals("")) {
            stringArray[1] = string2;
        }
        this.setDocRoot(stringArray[0], stringArray[1]);
    }

    public synchronized void setLogPath(String string, String string2) {
        this.logDir = string;
        this.logPrefix = string2;
    }

    private void initialSetup() {
        Debug.noteln("Initial setup for I-X HttpServer");
        this.server = new Server();
        this.socketListener = new SelectChannelConnector();
        this.socketListener.setPort(this.listenPort);
        this.server.setConnectors(new Connector[]{this.socketListener});
        this.contexts = new ContextHandlerCollection();
        Context context = new Context((HandlerContainer)this.contexts, "/");
        this.servlets = context.getServletHandler();
    }

    private void finalSetup() {
        RequestLogHandler requestLogHandler;
        if (this.docRoot != null) {
            requestLogHandler = new Context((HandlerContainer)this.contexts, "/" + this.docPath);
            requestLogHandler.setResourceBase(this.docRoot);
            requestLogHandler.addServlet(this.makeStaticContentServlet(), "/*");
        }
        if (this.logDir != null) {
            requestLogHandler = this.makeRequestLogHandler();
            HandlerCollection handlerCollection = new HandlerCollection();
            handlerCollection.setHandlers(new Handler[]{this.contexts, requestLogHandler});
            this.server.setHandler((Handler)handlerCollection);
        } else {
            this.server.setHandler((Handler)this.contexts);
        }
    }

    protected ServletHolder makeStaticContentServlet() {
        ServletHolder servletHolder = new ServletHolder((Servlet)new DefaultServlet());
        servletHolder.setInitParameter("aliases", "true");
        return servletHolder;
    }

    private RequestLogHandler makeRequestLogHandler() {
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        String string = System.getProperty("file.separator");
        String string2 = this.logDir + string + this.logPrefix + "_yyyy_mm_dd.log";
        NCSARequestLog nCSARequestLog = new NCSARequestLog(string2);
        nCSARequestLog.setRetainDays(90);
        nCSARequestLog.setAppend(true);
        nCSARequestLog.setExtended(false);
        nCSARequestLog.setLogTimeZone("GMT");
        requestLogHandler.setRequestLog((RequestLog)nCSARequestLog);
        return requestLogHandler;
    }

    public synchronized void addServlet(HttpServlet httpServlet, String string) {
        Debug.noteln("Adding servlet " + httpServlet + " at " + string);
        this.servlets.addServletWithMapping(new ServletHolder((Servlet)httpServlet), string);
    }

    public void addServlet(String string, HttpServlet httpServlet) {
        this.addServlet(httpServlet, string);
    }

    public synchronized void start() {
        try {
            this.finalSetup();
            this.server.start();
            Debug.noteln("Server port:", this.getServerPort());
        }
        catch (Throwable throwable) {
            throw new RethrownException("Couldn't start the HTTP server. ", throwable);
        }
    }

    public synchronized void join() {
        try {
            this.server.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        System.setProperty("java.net.preferIPv4Stack", "true");
    }
}

