/*
 * Decompiled with CFR 0.152.
 */
package ix.util.ipc;

import ix.util.Debug;
import ix.util.IPC;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.SocketException;

public class ObjectStreamConnection
implements IPC.Connection {
    Object destination;
    Socket sock;
    ObjectInputStream in;
    ObjectOutputStream out;

    public ObjectStreamConnection(Socket socket) {
        this("unknown agent", socket);
    }

    public ObjectStreamConnection(Object object, Socket socket) {
        this.destination = object;
        this.sock = socket;
    }

    public Object getDestination() {
        return this.destination;
    }

    public void setDestination(Object object) {
        this.destination = object;
    }

    public Socket getSocket() {
        return this.sock;
    }

    public void close() {
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            Debug.noteException(iOException);
            throw new IPC.IPCException("Problem closing connection", iOException);
        }
    }

    public synchronized void send(Object object) {
        try {
            if (this.out == null) {
                this.out = new ObjectOutputStream(this.sock.getOutputStream());
            }
            this.out.writeObject(object);
            this.out.flush();
            this.out.reset();
        }
        catch (IOException iOException) {
            Debug.noteException(iOException);
            throw new IPC.IPCException("Problem sending to connection to " + this.destination, iOException);
        }
    }

    public Object receive() {
        try {
            if (this.in == null) {
                this.in = new ObjectInputStream(this.sock.getInputStream());
            }
            Object object = this.in.readObject();
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.noteException(classNotFoundException);
            throw new IPC.IPCException("Problem receiving from connection to " + this.destination, classNotFoundException);
        }
        catch (EOFException eOFException) {
            Debug.noteException(eOFException);
            throw new IPC.BrokenConnectionException(this, (Throwable)eOFException);
        }
        catch (SocketException socketException) {
            Debug.noteException(socketException);
            throw new IPC.BrokenConnectionException(this, (Throwable)socketException);
        }
        catch (IOException iOException) {
            Debug.noteException(iOException);
            throw new IPC.IPCException("Problem receiving from connection to " + this.destination, iOException);
        }
    }
}

