/*
 * Decompiled with CFR 0.152.
 */
package ix.util.ipc;

import ix.icore.Sendable;
import ix.iface.util.IFUtil;
import ix.util.CatchingThread;
import ix.util.Debug;
import ix.util.IPC;
import ix.util.Name;
import ix.util.Parameters;
import ix.util.TextAreaFrame;
import ix.util.Util;
import ix.util.ipc.ObjectStreamConnection;
import ix.util.ipc.ServiceAddress;
import ix.util.ipc.SimpleNameServer;
import ix.util.lisp.Lisp;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;

public class SerializedCommunicationStrategy
implements IPC.CommunicationStrategy {
    static final String DEFAULT_NAME_SERVER_ADDRESS = "localhost:5555";
    ServiceAddress nameServerAddress = null;
    HashMap agentTable = new HashMap();
    String thisAgentsName = "not an agent name";

    public Object preEncode(Object object) {
        return object;
    }

    public Object postDecode(Object object) {
        return object;
    }

    public void sendObject(Object object, Object object2) {
        this.getAgentRecord((String)object).sendObject(object2);
    }

    public Object sendRequest(Object object, Object object2) {
        return this.getAgentRecord((String)object).sendRequest(object2);
    }

    public void setDestinationAddress(String string, ServiceAddress serviceAddress) {
        this.getAgentRecord(string).setAddress(serviceAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AgentRecord getAgentRecord(String string) {
        HashMap hashMap = this.agentTable;
        synchronized (hashMap) {
            AgentRecord agentRecord = (AgentRecord)this.agentTable.get(string);
            if (agentRecord == null) {
                agentRecord = new AgentRecord(string);
                this.agentTable.put(string, agentRecord);
            }
            return agentRecord;
        }
    }

    ServiceAddress askNameServer(Object object) {
        Object object2 = this.sendRequest("name-server", object);
        if (object2.equals("unknown")) {
            throw new IPC.IPCException("Name server doesn't know about " + object);
        }
        Debug.expect(object2 instanceof ServiceAddress, "Bogus addr for " + object, object2);
        return (ServiceAddress)object2;
    }

    public void setupServer(Object object, IPC.MessageListener messageListener) {
        Debug.noteln("Setting up a SerializedCommunicationStrategy");
        this.thisAgentsName = (String)object;
        this.setupNameServerAddress();
        this.getAgentRecord((String)"name-server").addr = this.nameServerAddress;
        if (Parameters.haveParameter("run-name-server")) {
            this.setupNameServer();
        }
        ObjectStreamServer objectStreamServer = new ObjectStreamServer(this, object, messageListener);
        objectStreamServer.setup();
        objectStreamServer.start();
    }

    protected void setupNameServerAddress() {
        if (Parameters.getParameter("name-server", "unspecified").equals("false")) {
            return;
        }
        if (this.nameServerAddress != null && !Parameters.haveParameter("name-server")) {
            return;
        }
        String string = Parameters.getParameter("name-server", DEFAULT_NAME_SERVER_ADDRESS);
        Debug.noteln("Setting name-server addr", (Object)string);
        this.nameServerAddress = new ServiceAddress(string);
    }

    protected void setupNameServer() {
        ServiceAddress serviceAddress = this.nameServerAddress;
        Debug.expect(serviceAddress != null, "Can't run name server, address unknown");
        new ObjectStreamNameServer(this, serviceAddress).start();
    }

    public static class ObjectStreamNameServer
    extends CatchingThread {
        SerializedCommunicationStrategy strategy;
        ServiceAddress addr;
        IPC.DestinationTable nameTable = new IPC.BasicDestinationTable();
        TextAreaFrame textFrame;
        ServerSocket servSock;
        boolean isStandAlone;

        public ObjectStreamNameServer(SerializedCommunicationStrategy serializedCommunicationStrategy, ServiceAddress serviceAddress) {
            this.strategy = serializedCommunicationStrategy;
            this.addr = serviceAddress;
            this.isStandAlone = SimpleNameServer.isStandAlone();
            this.textFrame = new TranscriptFrame(serviceAddress, this.isStandAlone);
            try {
                this.servSock = new ServerSocket(serviceAddress.port);
            }
            catch (IOException iOException) {
                Debug.noteException(iOException);
                throw new IPC.IPCException("Problem setting up name-server ServerSocket at " + serviceAddress, iOException);
            }
        }

        public void innerRun() {
            Debug.noteln("I-X Name-server running at", (Object)this.addr);
            try {
                while (true) {
                    Socket socket = this.servSock.accept();
                    Debug.noteln("Client connection", (Object)socket);
                    this.serveClientOn(new ObjectStreamConnection(socket));
                }
            }
            catch (IOException iOException) {
                Debug.noteException(iOException);
                throw new IPC.IPCException("Problem in name-server at " + this.addr, iOException);
            }
        }

        protected void serveClientOn(final ObjectStreamConnection objectStreamConnection) {
            new CatchingThread(){

                public void innerRun() {
                    ObjectStreamNameServer.this.clientServiceLoop(objectStreamConnection);
                }
            }.start();
        }

        protected void clientServiceLoop(ObjectStreamConnection objectStreamConnection) {
            try {
                while (true) {
                    Object object = this.strategy.postDecode(objectStreamConnection.receive());
                    this.handleMessage(objectStreamConnection, object);
                }
            }
            catch (IPC.BrokenConnectionException brokenConnectionException) {
                objectStreamConnection.close();
                Debug.noteln("Name-server lost connection to", objectStreamConnection.getDestination());
                this.transcript("Lost connection to " + objectStreamConnection.getDestination());
                return;
            }
        }

        protected synchronized void handleMessage(ObjectStreamConnection objectStreamConnection, Object object) {
            Debug.noteln("Name-server received", object);
            if (object instanceof String) {
                ServiceAddress serviceAddress = (ServiceAddress)this.nameTable.get(object);
                if (serviceAddress != null) {
                    this.sendReply(objectStreamConnection, serviceAddress);
                } else {
                    this.sendReply(objectStreamConnection, "unknown");
                }
            } else if (object instanceof List) {
                List list = (List)object;
                if (list.get(0).equals("register") && list.get(1) instanceof String && list.get(2) instanceof ServiceAddress) {
                    this.recordRegistration(objectStreamConnection, (String)list.get(1), (ServiceAddress)list.get(2));
                    this.sendReply(objectStreamConnection, "ok");
                } else {
                    Debug.noteln("Ilegal name-server request", object);
                }
            } else {
                Debug.noteln("Ilegal name-server request", object);
            }
        }

        protected void sendReply(ObjectStreamConnection objectStreamConnection, Object object) {
            objectStreamConnection.send(this.strategy.preEncode(object));
        }

        protected void recordRegistration(ObjectStreamConnection objectStreamConnection, String string, ServiceAddress serviceAddress) {
            objectStreamConnection.setDestination(string);
            InetAddress inetAddress = objectStreamConnection.getSocket().getInetAddress();
            if (Parameters.getBoolean("ns-use-ip-addrs", false)) {
                ServiceAddress serviceAddress2 = new ServiceAddress(inetAddress.getHostAddress(), serviceAddress.getPort());
                this.nameTable.put(string, serviceAddress2);
                this.transcript("Registering " + string + " at " + serviceAddress2 + " instead of " + serviceAddress);
            } else {
                this.nameTable.put(string, serviceAddress);
                this.transcript("Registering " + string + " at " + serviceAddress);
            }
            if (!inetAddress.getHostName().equals("localhost") && !Util.hostNameMatchesAddr(serviceAddress.getHost(), inetAddress)) {
                this.transcript(string + " at " + this.nameTable.get(string) + " registered from host " + inetAddress);
            }
        }

        protected void transcript(final String string) {
            Debug.noteln("Name-server:", (Object)string);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ObjectStreamNameServer.this.textFrame.appendLine(string);
                    if (!ObjectStreamNameServer.this.textFrame.getFrame().isShowing()) {
                        ObjectStreamNameServer.this.textFrame.setVisible(true);
                    }
                }
            });
        }

        class TranscriptFrame
        extends TextAreaFrame {
            TranscriptFrame(ServiceAddress serviceAddress, boolean bl) {
                super("I-X Name-Server at " + serviceAddress.host + ":" + serviceAddress.port);
                this.setEditable(false);
                if (bl) {
                    JMenu jMenu = IFUtil.ensureMenuBarMenu(this.frame, "File");
                    jMenu.removeAll();
                    jMenu.add(this.frame.makeMenuItem("Exit"));
                }
            }

            public void whenClosed() {
            }

            public void fireButtonPressed(String string) {
                String string2 = "Are you sure you want to exit the name-server?";
                if (string.equals("Exit") && Util.dialogConfirms(this, string2)) {
                    System.exit(0);
                }
            }
        }
    }

    public static class ObjectStreamServer
    extends CatchingThread {
        SerializedCommunicationStrategy strategy;
        Object destination;
        IPC.MessageListener listener;
        ServiceAddress addr;
        ServerSocket servSock;

        public ObjectStreamServer(SerializedCommunicationStrategy serializedCommunicationStrategy, Object object, IPC.MessageListener messageListener) {
            this.strategy = serializedCommunicationStrategy;
            this.destination = object;
            this.listener = messageListener;
        }

        public void setup() {
            try {
                int n = Parameters.getInt("port", 0);
                this.servSock = new ServerSocket(n);
                String string = Util.getHostName();
                this.addr = new ServiceAddress(string, this.servSock.getLocalPort());
                if (this.strategy.nameServerAddress != null && !SimpleNameServer.isStandAlone()) {
                    this.registerWithNameServer();
                }
            }
            catch (IOException iOException) {
                Debug.noteException(iOException);
                throw new IPC.IPCException("Problem setting up server for " + this.destination, iOException);
            }
        }

        public void innerRun() {
            Debug.expect(this.servSock != null, "Server started before set up");
            Debug.noteln("Server running for", this.destination);
            try {
                while (true) {
                    Socket socket = this.servSock.accept();
                    Debug.noteln("Client connection", (Object)socket);
                    this.receiveFrom(new ObjectStreamConnection(socket));
                }
            }
            catch (IOException iOException) {
                Debug.noteException(iOException);
                throw new IPC.IPCException("Problem in server for " + this.destination, iOException);
            }
        }

        protected void registerWithNameServer() {
            Debug.noteln("Registering " + this.destination + " as " + this.addr.host + ":" + this.addr.port);
            while (true) {
                try {
                    Object object = this.strategy.sendRequest("name-server", Lisp.list("register", this.destination, this.addr));
                    if (object.equals("ok")) {
                        return;
                    }
                }
                catch (IPC.IPCException iPCException) {
                    Debug.noteException(iPCException, false);
                }
                if (!this.shouldWaitForNameServer()) {
                    return;
                }
                this.strategy.getAgentRecord((String)"name-server").addr = this.strategy.nameServerAddress;
            }
        }

        protected boolean shouldWaitForNameServer() {
            ServiceAddress serviceAddress = this.strategy.nameServerAddress;
            Object[] objectArray = new Object[]{"Could not register " + this.destination + " with name-server at " + serviceAddress, "Do you want to try again?"};
            return Util.dialogConfirms(null, objectArray);
        }

        protected void receiveFrom(final ObjectStreamConnection objectStreamConnection) {
            new CatchingThread(){

                public void innerRun() {
                    Debug.noteln(ObjectStreamServer.this.destination + " receiver running ...");
                    ObjectStreamServer.this.receiveLoop(objectStreamConnection);
                }
            }.start();
        }

        protected void receiveLoop(ObjectStreamConnection objectStreamConnection) {
            try {
                while (true) {
                    Name name;
                    Debug.noteln(this.destination + " waiting to receive ...");
                    Object object = this.strategy.postDecode(objectStreamConnection.receive());
                    Debug.noteln(this.destination + " received", object);
                    if (object instanceof Sendable && (name = ((Sendable)object).getSenderId()) != null) {
                        Debug.noteln("Sender was", (Object)name);
                        objectStreamConnection.setDestination(name);
                    }
                    this.listener.messageReceived(new IPC.BasicInputMessage(object));
                }
            }
            catch (IPC.BrokenConnectionException brokenConnectionException) {
                objectStreamConnection.close();
                Debug.noteln(this.destination + " lost connection to " + objectStreamConnection.getDestination());
                return;
            }
        }
    }

    class AgentRecord {
        String name = null;
        ServiceAddress addr = null;
        IPC.Connection connection = null;

        AgentRecord(String string) {
            this.name = string;
        }

        synchronized void setAddress(ServiceAddress serviceAddress) {
            this.addr = serviceAddress;
        }

        synchronized void sendObject(Object object) {
            Debug.noteln("Sending to " + this.name + " at " + this.addr);
            boolean bl = this.connection != null;
            boolean bl2 = this.addr != null;
            IPC.Connection connection = null;
            try {
                connection = this.ensureConnection();
            }
            catch (IPC.IPCException iPCException) {
                Debug.noteln("Cannot connect because", (Object)iPCException);
                this.discardAnyConnection();
                this.addr = null;
                if (bl2) {
                    Debug.noteln("Will try again with", (Object)this.name);
                    if (Parameters.isInteractive()) {
                        Util.displayAndWait(null, new Object[]{"Cannot connect to " + this.name, "Will try resending once to its current address."});
                    }
                    this.sendObject(object);
                    return;
                }
                throw iPCException;
            }
            try {
                connection.send(SerializedCommunicationStrategy.this.preEncode(object));
            }
            catch (IPC.IPCException iPCException) {
                Debug.noteln("Can't send because", (Object)iPCException);
                this.discardAnyConnection();
                if (bl) {
                    Debug.noteln("Will attempt one resend to", (Object)this.name);
                    if (Parameters.isInteractive()) {
                        Util.displayAndWait(null, new Object[]{"Broken connection to " + this.name, "Will try resending once with a new connection."});
                    }
                    this.sendObject(object);
                    return;
                }
                throw iPCException;
            }
        }

        synchronized Object sendRequest(Object object) {
            try {
                Debug.noteln("Sending request to " + this.name, object);
                IPC.Connection connection = this.ensureConnection();
                connection.send(SerializedCommunicationStrategy.this.preEncode(object));
                Object object2 = SerializedCommunicationStrategy.this.postDecode(connection.receive());
                Debug.noteln("Received reply from " + this.name, object2);
                return object2;
            }
            catch (IPC.IPCException iPCException) {
                this.discardAnyConnection();
                throw iPCException;
            }
        }

        private IPC.Connection ensureConnection() {
            if (this.connection == null) {
                this.ensureAddress();
                this.connection = this.connect();
            }
            return this.connection;
        }

        private void ensureAddress() {
            if (this.addr == null) {
                Debug.expect(!this.name.equals("name-server"), "Asking name-server for its own address.");
                this.addr = SerializedCommunicationStrategy.this.askNameServer(this.name);
            }
        }

        private void discardAnyConnection() {
            if (this.connection != null) {
                Debug.noteln("Discarding connection to", (Object)this.name);
                this.connection.close();
                this.connection = null;
            } else {
                Debug.noteln("No connection to " + this.name + " to discard.");
            }
        }

        private IPC.Connection connect() {
            Debug.noteln("Connecting to " + this.name + " on " + this.addr.getHost() + " port " + this.addr.getPort());
            Debug.expect(this.connection == null, "connecting twice");
            try {
                Socket socket = new Socket(this.addr.getHost(), this.addr.getPort());
                ObjectStreamConnection objectStreamConnection = new ObjectStreamConnection(this.name, socket);
                return objectStreamConnection;
            }
            catch (IOException iOException) {
                Debug.noteException(iOException, false);
                ServiceAddress serviceAddress = this.addr;
                this.addr = null;
                throw new IPC.IPCException("Cannot connect to " + this.name + " at " + serviceAddress, iOException);
            }
        }
    }
}

