/*
 * Decompiled with CFR 0.152.
 */
package ix.util.lisp;

import ix.iscript.Expression;
import ix.iscript.IScript;
import ix.iscript.LinkedListOfExpression;
import ix.iscript.ListOfExpression;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Strings;
import ix.util.ThrownResult;
import ix.util.Util;
import ix.util.lisp.Symbol;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class Interpreter {
    protected Object DEFAULT = null;
    protected static Object TRUE = Boolean.TRUE;
    protected static Object FALSE = Boolean.FALSE;
    protected GlobalEnv globalEnv = new GlobalEnv();
    protected static IScript iscript = new IScript();
    protected boolean acceptOnlySafeBuiltins = false;
    private static final int UNKNOWN = -2;
    private static final int GLOBAL = -1;

    public boolean isTrue(Object object) {
        return !object.equals(Boolean.FALSE);
    }

    public Object topLevelEval(Expr expr) {
        return expr.evalIn(this.globalEnv);
    }

    public Object topLevelApply(Object object, Object[] objectArray) {
        Object object2;
        if (object instanceof Function) {
            Function function = (Function)object;
            function.checkArity(objectArray.length);
            return function.applyTo(objectArray);
        }
        if (object instanceof Symbol && (object2 = this.globalEnv.lookup((Symbol)object)) instanceof Function) {
            Function function = (Function)object2;
            function.checkArity(objectArray.length);
            return function.applyTo(objectArray);
        }
        throw new IllegalArgumentException(object + " is not defined as a function.");
    }

    public boolean isSafe() {
        return this.acceptOnlySafeBuiltins;
    }

    protected static String nameForClass(Class clazz) {
        return Strings.afterLast(".", clazz.getName());
    }

    public class LexicalEnv
    extends AbstractEnv {
        Symbol[] vars;
        Object[] vals;
        LexicalEnv enclosingEnv;

        public LexicalEnv(Symbol[] symbolArray, Object[] objectArray, LexicalEnv lexicalEnv) {
            if (symbolArray.length != objectArray.length) {
                throw new Error("Wrong number of arguments when binding.  Expected " + symbolArray.length + " but found " + objectArray.length);
            }
            this.vars = symbolArray;
            this.vals = objectArray;
            this.enclosingEnv = lexicalEnv;
        }

        public Object lookup(VarRef varRef) {
            if (varRef.up == -2) {
                this.findOffsets(varRef);
            }
            if (varRef.up == -1) {
                return Interpreter.this.globalEnv.lookup(varRef);
            }
            LexicalEnv lexicalEnv = this;
            for (int i = varRef.up; i > 0; --i) {
                lexicalEnv = lexicalEnv.enclosingEnv;
            }
            return lexicalEnv.vals[varRef.over];
        }

        public Env bind(Symbol[] symbolArray, Object[] objectArray) {
            return new LexicalEnv(symbolArray, objectArray, this);
        }

        public Object assign(VarRef varRef, Object object) {
            if (varRef.up == -2) {
                this.findOffsets(varRef);
            }
            if (varRef.up == -1) {
                return Interpreter.this.globalEnv.assign(varRef, object);
            }
            LexicalEnv lexicalEnv = this;
            for (int i = varRef.up; i > 0; --i) {
                lexicalEnv = lexicalEnv.enclosingEnv;
            }
            lexicalEnv.vals[varRef.over] = object;
            return object;
        }

        protected void findOffsets(VarRef varRef) {
            LexicalEnv lexicalEnv = this;
            int n = 0;
            while (true) {
                int n2;
                if ((n2 = lexicalEnv.findIndex(varRef.var)) >= 0) {
                    varRef.up = n;
                    varRef.over = n2;
                    return;
                }
                lexicalEnv = lexicalEnv.enclosingEnv;
                if (lexicalEnv == null) {
                    varRef.up = -1;
                    return;
                }
                ++n;
            }
        }

        protected int findIndex(Symbol symbol) {
            for (int i = 0; i < this.vars.length; ++i) {
                if (this.vars[i] != symbol) continue;
                return i;
            }
            return -1;
        }
    }

    public class GlobalEnv
    extends AbstractEnv {
        Map varToValMap;

        public GlobalEnv() {
            this.varToValMap = new HashMap();
        }

        public Object lookup(VarRef varRef) {
            Object v = this.varToValMap.get(varRef.var);
            if (v == null) {
                throw new Error("Undefined variable", varRef.var);
            }
            return v;
        }

        public Object lookup(Symbol symbol) {
            Object v = this.varToValMap.get(symbol);
            if (v == null) {
                throw new Error("Undefined variable", symbol);
            }
            return v;
        }

        public Env bind(Symbol[] symbolArray, Object[] objectArray) {
            return new LexicalEnv(symbolArray, objectArray, null);
        }

        public Object assign(VarRef varRef, Object object) {
            this.varToValMap.put(varRef.var, object);
            return object;
        }

        public Object assign(Symbol symbol, Object object) {
            this.varToValMap.put(symbol, object);
            return object;
        }
    }

    public static class Error
    extends RuntimeException {
        public Error(String string) {
            super(string);
        }

        public Error(String string, Object object) {
            super(string + ": " + object);
        }
    }

    public static class While
    extends Expr {
        Expr test;
        Expr body;

        public While(Expr expr, Expr expr2) {
            this.test = expr;
            this.body = expr2;
        }

        protected Object _evalIn(Env env) {
            Object object = env.defaultValue();
            while (env.isTrue(this.test.evalIn(env))) {
                object = this.body.evalIn(env);
            }
            return object;
        }

        public Expression externalForm() {
            return iscript.makeWhile(this.test.externalForm(), this.body.externalForm());
        }
    }

    public static class Closure
    extends AbstractFunction {
        Symbol[] vars;
        Expr body;
        Env definitionEnv;

        public Closure(Symbol[] symbolArray, Expr expr, Env env) {
            this.vars = symbolArray;
            this.body = expr;
            this.definitionEnv = env;
        }

        public Object applyTo(Object[] objectArray) {
            try {
                return this.body.evalIn(this.definitionEnv.bind(this.vars, objectArray));
            }
            catch (ThrownResult thrownResult) {
                return thrownResult.getResult();
            }
        }

        public int getArity() {
            return this.vars.length;
        }

        public String toString() {
            return "Closure[" + Arrays.asList(this.vars) + ": " + this.body + "]";
        }
    }

    public static class Lambda
    extends Expr {
        Symbol[] vars;
        Expr body;

        public Lambda(List list, Expr expr) {
            this.vars = Lambda.makeVarArray(list);
            this.body = expr;
        }

        protected Object _evalIn(Env env) {
            return new Closure(this.vars, this.body, env);
        }

        public Expression externalForm() {
            return iscript.makeLambda(this.vars, this.body.externalForm());
        }
    }

    public static class Let
    extends Expr {
        Symbol[] vars;
        Expr[] valExprs;
        Expr body;

        public Let(List list, List list2, Expr expr) {
            this.vars = Let.makeVarArray(list);
            this.valExprs = Let.makeExprArray(list2);
            this.body = expr;
        }

        protected Object _evalIn(Env env) {
            return this.body.evalIn(env.bind(this.vars, this.evalArgs(this.valExprs, env)));
        }

        public Expression externalForm() {
            return iscript.makeLet(this.vars, Let.externalForm(this.valExprs), this.body.externalForm());
        }
    }

    public static class Or
    extends Expr {
        Expr[] exprs;

        public Or(List list) {
            this.exprs = Or.makeExprArray(list);
        }

        protected Object _evalIn(Env env) {
            Object object = FALSE;
            for (int i = 0; i < this.exprs.length; ++i) {
                object = this.exprs[i].evalIn(env);
                if (!env.isTrue(object)) continue;
                return object;
            }
            Debug.expect(!env.isTrue(object));
            return object;
        }

        public Expression externalForm() {
            return iscript.makeOr(Or.externalForm(this.exprs));
        }
    }

    public static class And
    extends Expr {
        Expr[] exprs;

        public And(List list) {
            this.exprs = And.makeExprArray(list);
        }

        protected Object _evalIn(Env env) {
            Object object = TRUE;
            for (int i = 0; i < this.exprs.length; ++i) {
                object = this.exprs[i].evalIn(env);
                if (env.isTrue(object)) continue;
                return object;
            }
            Debug.expect(env.isTrue(object));
            return object;
        }

        public Expression externalForm() {
            return iscript.makeAnd(And.externalForm(this.exprs));
        }
    }

    public static class Sequence
    extends Expr {
        Expr[] exprs;

        public Sequence(List list) {
            this.exprs = Sequence.makeExprArray(list);
        }

        protected Object _evalIn(Env env) {
            Object object = env.defaultValue();
            for (int i = 0; i < this.exprs.length; ++i) {
                object = this.exprs[i].evalIn(env);
            }
            return object;
        }

        public Expression externalForm() {
            return iscript.makeSequence(Sequence.externalForm(this.exprs));
        }
    }

    public static class If
    extends Expr {
        Expr test;
        Expr ifTrue;
        Expr ifFalse;

        public If(Expr expr, Expr expr2, Expr expr3) {
            this.test = expr;
            this.ifTrue = expr2;
            this.ifFalse = expr3;
        }

        protected Object _evalIn(Env env) {
            if (env.isTrue(this.test.evalIn(env))) {
                return this.ifTrue.evalIn(env);
            }
            return this.ifFalse.evalIn(env);
        }

        public Expression externalForm() {
            return iscript.makeIf(this.test.externalForm(), this.ifTrue.externalForm(), this.ifFalse.externalForm());
        }
    }

    public static class Assignment
    extends VarRef {
        Expr valueExpr;

        public Assignment(Symbol symbol, Expr expr) {
            super(symbol);
            this.valueExpr = expr;
        }

        public Object evalIn(Env env) {
            return env.assign(this, this.valueExpr.evalIn(env));
        }

        protected Object _evalIn(Env env) {
            return env.assign(this, this.valueExpr.evalIn(env));
        }

        public Expression externalForm() {
            return iscript.makeAssignment(this.var, this.valueExpr.externalForm());
        }
    }

    public static class Call
    extends Expr {
        Expr fnExpr;
        Expr[] argExprs;

        public Call(Expr expr, List list) {
            this.fnExpr = expr;
            this.argExprs = Call.makeExprArray(list);
        }

        protected Object _evalIn(Env env) {
            Object object = this.fnExpr.evalIn(env);
            if (object instanceof Function) {
                Function function = (Function)object;
                Object[] objectArray = this.evalArgs(this.argExprs, env);
                function.checkArity(objectArray.length);
                return function.applyTo(objectArray);
            }
            throw new Error("Expected " + this.fnExpr + " to be a function, " + "but instead it was", object);
        }

        public Expression externalForm() {
            return iscript.makeCall(this.fnExpr.externalForm(), Call.externalForm(this.argExprs));
        }
    }

    public static class VarRef
    extends Expr {
        Symbol var;
        int up = -2;
        int over = -2;

        public VarRef(Symbol symbol) {
            this.var = symbol;
            this.description = symbol;
        }

        public Object evalIn(Env env) {
            return env.lookup(this);
        }

        protected Object _evalIn(Env env) {
            return env.lookup(this);
        }

        public Expression externalForm() {
            return iscript.makeVarRef(this.var);
        }
    }

    public static class Literal
    extends Expr {
        Object value;

        public Literal(Object object) {
            this.value = object;
            this.description = object;
        }

        public Object evalIn(Env env) {
            return this.value;
        }

        protected Object _evalIn(Env env) {
            return this.value;
        }

        public Expression externalForm() {
            return iscript.makeLiteral(this.value);
        }
    }

    public static abstract class Expr {
        protected Object description;

        protected abstract Object _evalIn(Env var1);

        public abstract Expression externalForm();

        public void setDescription(Object object) {
            this.description = object;
        }

        public String toString() {
            return this.description != null ? this.description.toString() : super.toString();
        }

        public Object evalIn(Env env) {
            Object object = null;
            try {
                object = this._evalIn(env);
                if (object == null) {
                    throw new ConsistencyException("Null result from " + this);
                }
                Object object2 = object;
                return object2;
            }
            catch (ThrownResult thrownResult) {
                object = thrownResult.getResult();
                throw thrownResult;
            }
            finally {
                if (object == null) {
                    try {
                        System.out.println("Backtrace: " + this);
                    }
                    catch (Throwable throwable) {
                        Debug.displayException("Exception in eval 'finally' clause", throwable);
                    }
                }
            }
        }

        protected Object[] evalArgs(Expr[] exprArray, Env env) {
            Object[] objectArray = new Object[exprArray.length];
            for (int i = 0; i < exprArray.length; ++i) {
                objectArray[i] = exprArray[i].evalIn(env);
            }
            return objectArray;
        }

        protected static Expr[] makeExprArray(List list) {
            Expr[] exprArray = new Expr[list.size()];
            int n = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                exprArray[n++] = (Expr)iterator.next();
            }
            return exprArray;
        }

        protected static Symbol[] makeVarArray(List list) {
            Symbol[] symbolArray = new Symbol[list.size()];
            int n = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                symbolArray[n++] = (Symbol)iterator.next();
            }
            return symbolArray;
        }

        protected static ListOfExpression externalForm(Expr[] exprArray) {
            LinkedListOfExpression linkedListOfExpression = new LinkedListOfExpression();
            for (int i = 0; i < exprArray.length; ++i) {
                linkedListOfExpression.add(exprArray[i].externalForm());
            }
            return linkedListOfExpression;
        }
    }

    public static abstract class JFunction
    extends AbstractFunction {
        protected Symbol name;
        protected int arity;

        public JFunction(String string, int n) {
            this(Symbol.intern(string), n);
        }

        public JFunction(Symbol symbol, int n) {
            this.name = symbol;
            this.arity = n;
        }

        public int getArity() {
            return this.arity;
        }

        public boolean isSafe() {
            return true;
        }

        public String toString() {
            return "Function[" + this.name + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractFunction
    implements Function {
        @Override
        public void checkArity(int n) {
            int n2 = this.getArity();
            if (n2 == -1 || n2 == n) {
                return;
            }
            throw new Error("Expected " + n2 + " arguments," + " but found " + n + " when calling " + this);
        }

        protected <T> T mustBe(Class<T> clazz, Object object) {
            return Util.mustBe(clazz, object);
        }
    }

    public static interface Function {
        public static final int ANY_ARITY = -1;

        public Object applyTo(Object[] var1);

        public int getArity();

        public void checkArity(int var1);
    }

    protected abstract class AbstractEnv
    implements Env {
        public Object defaultValue() {
            return Interpreter.this.DEFAULT;
        }

        public boolean isTrue(Object object) {
            return Interpreter.this.isTrue(object);
        }
    }

    public static interface Env {
        public Object lookup(VarRef var1);

        public Env bind(Symbol[] var1, Object[] var2);

        public Object assign(VarRef var1, Object var2);

        public Object defaultValue();

        public boolean isTrue(Object var1);
    }
}

