/*
 * Decompiled with CFR 0.152.
 */
package ix.util.lisp;

import ix.util.Strings;
import ix.util.UniqueObject;
import ix.util.Util;
import ix.util.lisp.Cons;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import ix.util.lisp.LispPrinter;
import ix.util.lisp.LispReadException;
import ix.util.lisp.LispReader;
import ix.util.lisp.Null;
import ix.util.lisp.ObjectHash;
import ix.util.xml.XML;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;

public class Lisp {
    public static final Null NIL = new Null();
    public static final Object EOF = new UniqueObject("EOF");
    private static final LispPrinter printer = new LispPrinter();
    private static ObjectHash defaultHash = new ObjectHash();

    private Lisp() {
    }

    public static final Cons cons(Object object, LList lList) {
        return new Cons(object, lList);
    }

    public static final Null list() {
        return NIL;
    }

    public static final Cons list(Object object) {
        return new Cons(object, NIL);
    }

    public static final Cons list(Object object, Object object2) {
        return new Cons(object, new Cons(object2, NIL));
    }

    public static final Cons list(Object object, Object object2, Object object3) {
        return new Cons(object, new Cons(object2, new Cons(object3, NIL)));
    }

    public static final Cons list(Object object, Object object2, Object object3, Object object4) {
        return new Cons(object, new Cons(object2, new Cons(object3, new Cons(object4, NIL))));
    }

    public static final Cons list(Object object, Object object2, Object object3, Object object4, Object object5) {
        return new Cons(object, new Cons(object2, new Cons(object3, new Cons(object4, new Cons(object5, NIL)))));
    }

    public static final Cons list(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        return new Cons(object, new Cons(object2, new Cons(object3, new Cons(object4, new Cons(object5, new Cons(object6, NIL))))));
    }

    public static final boolean equal(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object instanceof Cons) {
            return object2 instanceof Cons ? Lisp.equal(((Cons)object).car, ((Cons)object2).car) && Lisp.equal(((Cons)object).cdr, ((Cons)object2).cdr) : false;
        }
        if (object instanceof String) {
            return object2 instanceof String ? object.equals(object2) : false;
        }
        if (object instanceof Number) {
            return object2 instanceof Number ? object.equals(object2) : false;
        }
        return false;
    }

    public static LispReader openForInput(URL uRL) throws IOException {
        Reader reader = Util.openURLReader(uRL);
        return new LispReader(new BufferedReader(reader));
    }

    public static LispReader openForInput(String string) throws IOException {
        URL uRL = XML.toURL(string);
        if (uRL == null) {
            throw new IllegalArgumentException("Can't find " + string);
        }
        return Lisp.openForInput(uRL);
    }

    public static Object readFromString(String string) {
        LispReader lispReader = new LispReader(string);
        try {
            Object object = lispReader.readObject();
            if (lispReader.readObject() != EOF) {
                throw new LispReadException(string.trim().startsWith("(") ? "Extra close paren" : "More than one object");
            }
            return object;
        }
        catch (LispReadException lispReadException) {
            throw new LispReadException(lispReadException.getMessage() + " in string " + Strings.quote(string));
        }
    }

    public static LList elementsFromString(String string) {
        LListCollector lListCollector = new LListCollector();
        LispReader lispReader = new LispReader(string);
        try {
            while (true) {
                Object object;
                if ((object = lispReader.readObject()) == EOF) {
                    return lListCollector.contents();
                }
                lListCollector.add(object);
            }
        }
        catch (LispReadException lispReadException) {
            throw new LispReadException(lispReadException.getMessage() + " in string " + Strings.quote(string));
        }
    }

    public static String printToString(Object object) {
        return printer.printToString(object);
    }

    public static boolean isFullyPrintable(Object object) {
        return printer.isFullyPrintable(object);
    }

    public static String elementsToString(Object object) {
        return printer.elementsToString(object);
    }

    public static String quotedAndEscaped(char c, String string) {
        return printer.quotedAndEscaped(c, string);
    }

    public static int printLength(Object object) {
        return printer.printLength(object);
    }

    public static int hash(Object object) {
        return defaultHash.hash(object);
    }

    public static Object unhash(int n) {
        return defaultHash.unhash(n);
    }

    public static String hashName(Object object) {
        return defaultHash.hashName(object);
    }

    public static Object parseHashName(String string) {
        return defaultHash.parseHashName(string);
    }
}

