/*
 * Decompiled with CFR 0.152.
 */
package ix.util.lisp;

import ix.util.Debug;
import ix.util.Parameters;
import ix.util.RethrownException;
import ix.util.StableHashMap;
import ix.util.Strings;
import ix.util.ThrownResult;
import ix.util.UniqueObject;
import ix.util.Util;
import ix.util.context.ContextHashMap;
import ix.util.lisp.Cons;
import ix.util.lisp.Interpreter;
import ix.util.lisp.Keyword;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import ix.util.lisp.Lisp;
import ix.util.lisp.LispProgramReader;
import ix.util.lisp.LispReader;
import ix.util.lisp.Symbol;
import ix.util.xml.XML;
import java.beans.Expression;
import java.io.BufferedReader;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class LispInterpreter
extends Interpreter {
    public static final Symbol QUOTE = Symbol.intern("quote");
    public static final Symbol LAMBDA = Symbol.intern("lambda");
    public static final Symbol PROGN = Symbol.intern("progn");
    public static final Symbol COND = Symbol.intern("cond");
    public static final Symbol ELLIPSIS = Symbol.intern("...");
    protected Map<Symbol, Parser> parserTable = new HashMap<Symbol, Parser>();
    protected LispReader reader = new LispProgramReader(System.in);
    protected Object JAVA_NULL;

    public LispInterpreter() {
        this.DEFAULT = Lisp.NIL;
        this.JAVA_NULL = new JavaNull();
        this.installDefinitions();
    }

    public LispInterpreter(boolean bl) {
        this.DEFAULT = Lisp.NIL;
        this.JAVA_NULL = new JavaNull();
        this.acceptOnlySafeBuiltins = bl;
        this.installDefinitions();
    }

    public static void main(String[] stringArray) {
        Debug.off();
        Parameters.processCommandLineArguments(stringArray);
        LispInterpreter lispInterpreter = new LispInterpreter();
        lispInterpreter.loadLisp(Parameters.getList("load-lisp"));
        lispInterpreter.readEvalPrintLoop();
    }

    public void readEvalPrintLoop() {
        Symbol symbol = Symbol.intern("bye");
        while (true) {
            System.out.print("Lisp: ");
            try {
                Object object = this.reader.readObject();
                if (object == symbol) {
                    return;
                }
                System.out.println(Lisp.printToString(this.topLevelEval(object)));
                continue;
            }
            catch (Throwable throwable) {
                Debug.noteException(throwable, Debug.isOn());
                continue;
            }
            break;
        }
    }

    public void loadLisp(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.loadLisp((String)iterator.next());
        }
    }

    public void loadLisp(String string) {
        URL uRL = XML.toURL(string);
        if (uRL == null) {
            throw new IllegalArgumentException("Can't find a resource named " + Strings.quote(string));
        }
        try {
            Object object;
            BufferedReader bufferedReader = new BufferedReader(Util.openURLReader(uRL));
            LispProgramReader lispProgramReader = new LispProgramReader(bufferedReader);
            while ((object = lispProgramReader.readObject()) != Lisp.EOF) {
                this.topLevelEval(object);
            }
        }
        catch (Exception exception) {
            throw new RethrownException(exception, "Problem with loading " + Strings.quote(string) + ": " + Debug.describeException(exception));
        }
    }

    public boolean isTrue(Object object) {
        return object != Lisp.NIL && !object.equals(Boolean.FALSE);
    }

    public Object topLevelEval(Object object) {
        return super.topLevelEval(this.parseForm(object));
    }

    public Interpreter.Expr parseForm(Object object) {
        if (object instanceof Keyword) {
            return new Interpreter.Literal(object);
        }
        if (object instanceof Symbol) {
            return new Interpreter.VarRef((Symbol)object);
        }
        if (object instanceof LList && object != Lisp.NIL) {
            LList lList = (LList)object;
            Object object2 = lList.get(0);
            Parser parser = object2 instanceof Symbol ? this.parserTable.get((Symbol)object2) : null;
            Interpreter.Expr expr = parser != null ? parser.parse(lList) : new Interpreter.Call(this.parseForm(object2), this.parseList(lList.cdr()));
            expr.setDescription(object);
            return expr;
        }
        return new Interpreter.Literal(object);
    }

    public List parseList(List list) {
        LinkedList<Interpreter.Expr> linkedList = new LinkedList<Interpreter.Expr>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            linkedList.add(this.parseForm(iterator.next()));
        }
        return linkedList;
    }

    protected void installDefinitions() {
        this.defineSyntax();
        this.defineBuiltins();
        this.defineInitialValues();
    }

    public void define(Syntax syntax) {
        this.parserTable.put(syntax.name, syntax);
    }

    public void define(Interpreter.JFunction jFunction) {
        if (this.acceptOnlySafeBuiltins && !jFunction.isSafe()) {
            Debug.noteln("Omitting unsafe JFunction", (Object)jFunction);
            return;
        }
        this.globalEnv.assign(jFunction.name, (Object)jFunction);
    }

    public void define(String string, Object object) {
        this.globalEnv.assign(Symbol.intern(string), object);
    }

    protected void defineSyntax() {
        this.define(new Syntax("quote"){

            public Interpreter.Expr parse(LList lList) {
                this.checkLength(2, lList);
                return new Interpreter.Literal(lList.get(1));
            }
        });
        this.define(new Syntax("if"){

            public Interpreter.Expr parse(LList lList) {
                this.checkLength(4, lList);
                return new Interpreter.If(LispInterpreter.this.parseForm(lList.get(1)), LispInterpreter.this.parseForm(lList.get(2)), LispInterpreter.this.parseForm(lList.get(3)));
            }
        });
        this.define(new Syntax("cond"){

            public Interpreter.Expr parse(LList lList) {
                return this.parseClauses(lList.cdr());
            }

            Interpreter.Expr parseClauses(LList lList) {
                if (lList == Lisp.NIL) {
                    return new Interpreter.Literal(LispInterpreter.this.DEFAULT);
                }
                if (lList.car() instanceof LList) {
                    LList lList2 = (LList)lList.car();
                    Interpreter.Expr expr = LispInterpreter.this.parseForm(lList2.car());
                    Interpreter.Expr expr2 = this.parseClauses(lList.cdr());
                    Cons cons = new Cons(COND, new Cons(ELLIPSIS, lList));
                    if (lList2.cdr() == Lisp.NIL) {
                        return this.describe(new Interpreter.Or(Lisp.list(expr, expr2)), cons);
                    }
                    Interpreter.Expr expr3 = this.parseBody(lList2.cdr());
                    return this.describe(new Interpreter.If(expr, expr3, expr2), cons);
                }
                throw new SyntaxError("Invalid cond clause", lList.car());
            }
        });
        this.define(new Syntax("and"){

            public Interpreter.Expr parse(LList lList) {
                return new Interpreter.And(LispInterpreter.this.parseList(lList.cdr()));
            }
        });
        this.define(new Syntax("or"){

            public Interpreter.Expr parse(LList lList) {
                return new Interpreter.Or(LispInterpreter.this.parseList(lList.cdr()));
            }
        });
        this.define(new Syntax("setq"){

            public Interpreter.Expr parse(LList lList) {
                this.checkLength(3, lList);
                return new Interpreter.Assignment(this.mustBe(Symbol.class, lList.get(1)), LispInterpreter.this.parseForm(lList.get(2)));
            }
        });
        this.define(new Syntax("define"){

            public Interpreter.Expr parse(LList lList) {
                this.checkLength(3, lList);
                return new Interpreter.Assignment(this.mustBe(Symbol.class, lList.get(1)), LispInterpreter.this.parseForm(lList.get(2)));
            }
        });
        this.define(new Syntax("defun"){

            public Interpreter.Expr parse(LList lList) {
                Symbol symbol = this.mustBe(Symbol.class, lList.get(1));
                LList lList2 = this.mustBeLListOf(Symbol.class, lList.get(2));
                LList lList3 = lList.drop(3);
                Interpreter.Expr expr = this.describe(new Interpreter.Lambda(lList2, this.parseBody(lList3)), new Cons(LAMBDA, lList.cdr()));
                return new Interpreter.Sequence(Lisp.list(new Interpreter.Assignment(symbol, expr), new Interpreter.Literal(symbol)));
            }
        });
        this.define(new Syntax("progn"){

            public Interpreter.Expr parse(LList lList) {
                return new Interpreter.Sequence(LispInterpreter.this.parseList(lList.cdr()));
            }
        });
        this.define(new Syntax("let"){

            public Interpreter.Expr parse(LList lList) {
                LList lList2 = this.mustBe(LList.class, lList.get(1));
                LList lList3 = lList.drop(2);
                LinkedList<Symbol> linkedList = new LinkedList<Symbol>();
                LinkedList<Object> linkedList2 = new LinkedList<Object>();
                Iterator iterator = lList2.iterator();
                while (iterator.hasNext()) {
                    LList lList4 = this.mustBe(LList.class, iterator.next());
                    Symbol symbol = this.mustBe(Symbol.class, lList4.get(0));
                    Object object = lList4.get(1);
                    linkedList.add(symbol);
                    linkedList2.add(object);
                }
                return new Interpreter.Let(linkedList, LispInterpreter.this.parseList(linkedList2), this.parseBody(lList3));
            }
        });
        this.define(new Syntax("let*"){

            public Interpreter.Expr parse(LList lList) {
                LList lList2 = this.mustBe(LList.class, lList.get(1));
                LList lList3 = lList.drop(2);
                return this.parseLetStar(lList2, lList3);
            }

            Interpreter.Expr parseLetStar(LList lList, LList lList2) {
                if (lList.isEmpty()) {
                    return this.parseBody(lList2);
                }
                LList lList3 = this.mustBe(LList.class, lList.car());
                Symbol symbol = this.mustBe(Symbol.class, lList3.get(0));
                Interpreter.Expr expr = LispInterpreter.this.parseForm(lList3.get(1));
                return new Interpreter.Let(Lisp.list(symbol), Lisp.list(expr), this.parseLetStar(lList.cdr(), lList2));
            }
        });
        this.define(new Syntax("lambda"){

            public Interpreter.Expr parse(LList lList) {
                LList lList2 = this.mustBeLListOf(Symbol.class, lList.get(1));
                LList lList3 = lList.drop(2);
                return new Interpreter.Lambda(lList2, this.parseBody(lList3));
            }
        });
        this.define(new Syntax("while"){

            public Interpreter.Expr parse(LList lList) {
                return new Interpreter.While(LispInterpreter.this.parseForm(lList.get(1)), this.parseBody(lList.drop(2)));
            }
        });
    }

    protected void defineBuiltins() {
        this.define(new Interpreter.JFunction("identity", 1){

            public Object applyTo(Object[] objectArray) {
                return objectArray[0];
            }
        });
        this.define(new Interpreter.JFunction("apply", -1){

            public Object applyTo(Object[] objectArray) {
                Object object;
                int n = objectArray.length;
                if (n < 2) {
                    throw new Interpreter.Error("Apply wasn't given at least two arguments.");
                }
                if (objectArray[0] instanceof Symbol) {
                    object = LispInterpreter.this.globalEnv.lookup((Symbol)objectArray[0]);
                    if (object instanceof Interpreter.Function) {
                        objectArray[0] = object;
                    } else {
                        throw new ClassCastException(objectArray[0] + " is not defined as a function.");
                    }
                }
                object = this.mustBe(Interpreter.Function.class, objectArray[0]);
                List list = this.mustBe(List.class, objectArray[n - 1]);
                int n2 = n - 2 + list.size();
                Object[] objectArray2 = new Object[n2];
                System.arraycopy(objectArray, 1, objectArray2, 0, n - 2);
                int n3 = n - 2;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    objectArray2[n3++] = iterator.next();
                }
                Debug.expect(n3 == n2);
                object.checkArity(objectArray2.length);
                return object.applyTo(objectArray2);
            }
        });
        this.define(new Interpreter.JFunction("return", 1){

            public Object applyTo(Object[] objectArray) {
                throw new ThrownResult(objectArray[0]);
            }
        });
        this.define(new Interpreter.JFunction("error", -1){

            public Object applyTo(Object[] objectArray) {
                if (objectArray.length < 1) {
                    throw new Interpreter.Error("Error for unknown reason.");
                }
                StringBuffer stringBuffer = new StringBuffer(objectArray.length * 70);
                for (int i = 0; i < objectArray.length; ++i) {
                    stringBuffer.append(objectArray[i].toString());
                }
                throw new Interpreter.Error(stringBuffer.toString());
            }
        });
        this.define(new Interpreter.JFunction("for-each", 2){

            public Object applyTo(Object[] objectArray) {
                Interpreter.Function function = this.mustBe(Interpreter.Function.class, objectArray[0]);
                Collection collection = this.mustBe(Collection.class, objectArray[1]);
                function.checkArity(1);
                Object[] objectArray2 = new Object[1];
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    objectArray2[0] = iterator.next();
                    function.applyTo(objectArray2);
                }
                return collection;
            }
        });
        this.define(new Interpreter.JFunction("map", 2){

            public Object applyTo(Object[] objectArray) {
                Interpreter.Function function = this.mustBe(Interpreter.Function.class, objectArray[0]);
                Collection collection = this.mustBe(Collection.class, objectArray[1]);
                function.checkArity(1);
                Object[] objectArray2 = new Object[1];
                LListCollector lListCollector = new LListCollector();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    objectArray2[0] = iterator.next();
                    lListCollector.add(function.applyTo(objectArray2));
                }
                return lListCollector.contents();
            }
        });
        this.define(new Interpreter.JFunction("symbolp", 1){

            public Object applyTo(Object[] objectArray) {
                return objectArray[0] instanceof Symbol;
            }
        });
        this.define(new Interpreter.JFunction("numberp", 1){

            public Object applyTo(Object[] objectArray) {
                return objectArray[0] instanceof Number;
            }
        });
        this.define(new Interpreter.JFunction("stringp", 1){

            public Object applyTo(Object[] objectArray) {
                return objectArray[0] instanceof String;
            }
        });
        this.define(new Interpreter.JFunction("listp", 1){

            public Object applyTo(Object[] objectArray) {
                return objectArray[0] instanceof LList;
            }
        });
        this.define(new Interpreter.JFunction("consp", 1){

            public Object applyTo(Object[] objectArray) {
                return objectArray[0] instanceof Cons;
            }
        });
        this.define(new Interpreter.JFunction("not", 1){

            public Object applyTo(Object[] objectArray) {
                return !LispInterpreter.this.isTrue(objectArray[0]);
            }
        });
        this.define(new Interpreter.JFunction("eq", 2){

            public Object applyTo(Object[] objectArray) {
                return objectArray[0] == objectArray[1];
            }
        });
        this.define(new Interpreter.JFunction("equal", 2){

            public Object applyTo(Object[] objectArray) {
                return Lisp.equal(objectArray[0], objectArray[1]);
            }
        });
        this.define(new Interpreter.JFunction("null", 1){

            public Object applyTo(Object[] objectArray) {
                return objectArray[0] == Lisp.NIL;
            }
        });
        this.define(new Interpreter.JFunction("cons", 2){

            public Object applyTo(Object[] objectArray) {
                return new Cons(objectArray[0], this.mustBe(LList.class, objectArray[1]));
            }
        });
        this.define(new Interpreter.JFunction("car", 1){

            public Object applyTo(Object[] objectArray) {
                LList lList = this.mustBe(LList.class, objectArray[0]);
                return lList.car();
            }
        });
        this.define(new Interpreter.JFunction("cdr", 1){

            public Object applyTo(Object[] objectArray) {
                LList lList = this.mustBe(LList.class, objectArray[0]);
                return lList.cdr();
            }
        });
        this.define("first", this.globalEnv.lookup(Symbol.intern("car")));
        this.define("rest", this.globalEnv.lookup(Symbol.intern("cdr")));
        this.define(new Interpreter.JFunction("list", -1){

            public Object applyTo(Object[] objectArray) {
                LList lList = Lisp.NIL;
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    lList = new Cons(objectArray[i], lList);
                }
                return lList;
            }
        });
        this.define(new Interpreter.JFunction("make-list", 1){

            public Object applyTo(Object[] objectArray) {
                Collection collection = this.mustBe(Collection.class, objectArray[0]);
                return LList.newLList(collection);
            }
        });
        this.topLevelEval(Lisp.readFromString("(defun mapcar (f l)   (if (null l) nil (cons (f (car l)) (mapcar f (cdr l)))))"));
        this.define(new Interpreter.JFunction("empty", 1){

            public Object applyTo(Object[] objectArray) {
                Object object = objectArray[0];
                if (object instanceof LList) {
                    return object == Lisp.NIL;
                }
                if (object instanceof String) {
                    return ((String)object).length() == 0;
                }
                if (object instanceof Collection) {
                    return ((Collection)object).isEmpty();
                }
                if (object instanceof Object[]) {
                    return ((Object[])object).length == 0;
                }
                throw new IllegalArgumentException("Can't apply empty to " + object);
            }
        });
        this.define(new Interpreter.JFunction("length", 1){

            public Object applyTo(Object[] objectArray) {
                Object object = objectArray[0];
                if (object instanceof LList) {
                    return new Long(((LList)object).length());
                }
                if (object instanceof String) {
                    return new Long(((String)object).length());
                }
                if (object instanceof Collection) {
                    return new Long(((Collection)object).size());
                }
                if (object instanceof Object[]) {
                    return new Long(((Object[])object).length);
                }
                throw new IllegalArgumentException("Can't take the length of " + object);
            }
        });
        this.define(new Interpreter.JFunction("elt", 2){

            public Object applyTo(Object[] objectArray) {
                Object object = objectArray[0];
                int n = this.mustBe(Number.class, objectArray[1]).intValue();
                if (object instanceof LList) {
                    return ((LList)object).get(n);
                }
                if (object instanceof String) {
                    return ((String)object).substring(n, n + 1);
                }
                if (object instanceof List) {
                    return ((List)object).get(n);
                }
                if (object instanceof Object[]) {
                    return ((Object[])object)[n];
                }
                throw new IllegalArgumentException("Can't apply elt to " + object);
            }
        });
        this.define(new Interpreter.JFunction("make-collection", 2){
            private final Symbol LIST;
            private final Symbol SET;
            private final Symbol SORTED_SET;
            {
                this.LIST = Symbol.intern("list");
                this.SET = Symbol.intern("set");
                this.SORTED_SET = Symbol.intern("sorted-set");
            }

            public Object applyTo(Object[] objectArray) {
                Symbol symbol = this.mustBe(Symbol.class, objectArray[0]);
                Collection collection = this.mustBe(Collection.class, objectArray[1]);
                Collection collection2 = this.makeInstance(symbol);
                collection2.addAll(collection);
                return collection2;
            }

            Collection makeInstance(Symbol symbol) {
                if (symbol == this.LIST) {
                    return new LinkedList();
                }
                if (symbol == this.SET) {
                    return new LinkedHashSet();
                }
                if (symbol == this.SORTED_SET) {
                    return new TreeSet();
                }
                throw new IllegalArgumentException(symbol + " is not a valid type for make-collection.");
            }
        });
        this.define(new Interpreter.JFunction("contains", 2){

            public Object applyTo(Object[] objectArray) {
                Collection collection = this.mustBe(Collection.class, objectArray[0]);
                Object object = objectArray[1];
                return collection.contains(object);
            }
        });
        this.define(new Interpreter.JFunction("add", 2){

            public Object applyTo(Object[] objectArray) {
                Collection collection = this.mustBe(Collection.class, objectArray[0]);
                Object object = objectArray[1];
                return collection.add(object);
            }
        });
        this.define(new Interpreter.JFunction("remove", 2){

            public Object applyTo(Object[] objectArray) {
                Collection collection = this.mustBe(Collection.class, objectArray[0]);
                Object object = objectArray[1];
                return collection.remove(object);
            }
        });
        this.define(new Interpreter.JFunction("make-hash-map", 0){

            public Object applyTo(Object[] objectArray) {
                return new StableHashMap();
            }
        });
        this.define(new Interpreter.JFunction("make-context-hash-map", 0){

            public Object applyTo(Object[] objectArray) {
                return new ContextHashMap();
            }
        });
        this.define(new Interpreter.JFunction("get", 3){

            public Object applyTo(Object[] objectArray) {
                Map map = this.mustBe(Map.class, objectArray[0]);
                Object object = objectArray[1];
                Object object2 = objectArray[2];
                Object v = map.get(object);
                return v == null ? object2 : v;
            }
        });
        this.define(new Interpreter.JFunction("put", 3){

            public Object applyTo(Object[] objectArray) {
                Map map = this.mustBe(Map.class, objectArray[0]);
                Object object = objectArray[1];
                Object object2 = objectArray[2];
                map.put(object, object2);
                return object2;
            }
        });
        this.define(new Interpreter.JFunction("for-each-entry", 2){

            public Object applyTo(Object[] objectArray) {
                Interpreter.Function function = this.mustBe(Interpreter.Function.class, objectArray[0]);
                Map map = this.mustBe(Map.class, objectArray[1]);
                function.checkArity(2);
                Object[] objectArray2 = new Object[2];
                for (Map.Entry entry : map.entrySet()) {
                    objectArray2[0] = entry.getKey();
                    objectArray2[1] = entry.getValue();
                    function.applyTo(objectArray2);
                }
                return map;
            }
        });
        this.define(new Interpreter.JFunction("=", 2){

            public Object applyTo(Object[] objectArray) {
                Number number = this.mustBe(Number.class, objectArray[0]);
                Number number2 = this.mustBe(Number.class, objectArray[1]);
                if (number instanceof Long && number2 instanceof Long) {
                    return number.longValue() == number2.longValue();
                }
                return number.doubleValue() == number2.doubleValue();
            }
        });
        this.define(new Interpreter.JFunction("/=", 2){

            public Object applyTo(Object[] objectArray) {
                Number number = this.mustBe(Number.class, objectArray[0]);
                Number number2 = this.mustBe(Number.class, objectArray[1]);
                if (number instanceof Long && number2 instanceof Long) {
                    return number.longValue() != number2.longValue();
                }
                return number.doubleValue() != number2.doubleValue();
            }
        });
        this.define(new Interpreter.JFunction("<", 2){

            public Object applyTo(Object[] objectArray) {
                Number number = this.mustBe(Number.class, objectArray[0]);
                Number number2 = this.mustBe(Number.class, objectArray[1]);
                if (number instanceof Long && number2 instanceof Long) {
                    return number.longValue() < number2.longValue();
                }
                return number.doubleValue() < number2.doubleValue();
            }
        });
        this.define(new Interpreter.JFunction(">", 2){

            public Object applyTo(Object[] objectArray) {
                Number number = this.mustBe(Number.class, objectArray[0]);
                Number number2 = this.mustBe(Number.class, objectArray[1]);
                if (number instanceof Long && number2 instanceof Long) {
                    return number.longValue() > number2.longValue();
                }
                return number.doubleValue() > number2.doubleValue();
            }
        });
        this.define(new Interpreter.JFunction("<=", 2){

            public Object applyTo(Object[] objectArray) {
                Number number = this.mustBe(Number.class, objectArray[0]);
                Number number2 = this.mustBe(Number.class, objectArray[1]);
                if (number instanceof Long && number2 instanceof Long) {
                    return number.longValue() <= number2.longValue();
                }
                return number.doubleValue() <= number2.doubleValue();
            }
        });
        this.define(new Interpreter.JFunction(">=", 2){

            public Object applyTo(Object[] objectArray) {
                Number number = this.mustBe(Number.class, objectArray[0]);
                Number number2 = this.mustBe(Number.class, objectArray[1]);
                if (number instanceof Long && number2 instanceof Long) {
                    return number.longValue() >= number2.longValue();
                }
                return number.doubleValue() >= number2.doubleValue();
            }
        });
        this.define(new Interpreter.JFunction("+", -1){

            public Object applyTo(Object[] objectArray) {
                double d = 0.0;
                long l = 0L;
                boolean bl = false;
                for (int i = 0; i < objectArray.length; ++i) {
                    Number number = this.mustBe(Number.class, objectArray[i]);
                    if (bl) {
                        d += number.doubleValue();
                        continue;
                    }
                    if (number instanceof Long) {
                        l += number.longValue();
                        continue;
                    }
                    if (number instanceof Double) {
                        d = l;
                        d += number.doubleValue();
                        bl = true;
                        continue;
                    }
                    throw new ClassCastException("I don't know how to add " + number);
                }
                if (bl) {
                    return new Double(d);
                }
                return new Long(l);
            }
        });
        this.define(new Interpreter.JFunction("-", 2){

            public Object applyTo(Object[] objectArray) {
                Number number = this.mustBe(Number.class, objectArray[0]);
                Number number2 = this.mustBe(Number.class, objectArray[1]);
                if (number instanceof Long && number2 instanceof Long) {
                    return new Long(number.longValue() - number2.longValue());
                }
                return new Double(number.doubleValue() - number2.doubleValue());
            }
        });
        this.define(new Interpreter.JFunction("*", -1){

            public Object applyTo(Object[] objectArray) {
                double d = 1.0;
                long l = 1L;
                boolean bl = false;
                for (int i = 0; i < objectArray.length; ++i) {
                    Number number = this.mustBe(Number.class, objectArray[i]);
                    if (bl) {
                        d *= number.doubleValue();
                        continue;
                    }
                    if (number instanceof Long) {
                        l *= number.longValue();
                        continue;
                    }
                    if (number instanceof Double) {
                        d = l;
                        d *= number.doubleValue();
                        bl = true;
                        continue;
                    }
                    throw new ClassCastException("I don't know how to add " + number);
                }
                if (bl) {
                    return new Double(d);
                }
                return new Long(l);
            }
        });
        this.define(new Interpreter.JFunction("/", 2){

            public Object applyTo(Object[] objectArray) {
                Number number = this.mustBe(Number.class, objectArray[0]);
                Number number2 = this.mustBe(Number.class, objectArray[1]);
                if (number instanceof Long && number2 instanceof Long) {
                    return new Long(number.longValue() / number2.longValue());
                }
                return new Double(number.doubleValue() / number2.doubleValue());
            }
        });
        this.define(new Interpreter.JFunction("%", 2){

            public Object applyTo(Object[] objectArray) {
                Number number = this.mustBe(Number.class, objectArray[0]);
                Number number2 = this.mustBe(Number.class, objectArray[1]);
                if (number instanceof Long && number2 instanceof Long) {
                    return new Long(number.longValue() % number2.longValue());
                }
                return new Double(number.doubleValue() % number2.doubleValue());
            }
        });
        this.define(new Interpreter.JFunction("ceiling", 1){

            public Object applyTo(Object[] objectArray) {
                Number number = this.mustBe(Number.class, objectArray[0]);
                return number instanceof Long ? (Number)number : (Number)new Long((long)Math.ceil(number.doubleValue()));
            }
        });
        this.define(new Interpreter.JFunction("floor", 1){

            public Object applyTo(Object[] objectArray) {
                Number number = this.mustBe(Number.class, objectArray[0]);
                return number instanceof Long ? (Number)number : (Number)new Long((long)Math.floor(number.doubleValue()));
            }
        });
        this.define(new Interpreter.JFunction("truncate", 1){

            public Object applyTo(Object[] objectArray) {
                Number number = this.mustBe(Number.class, objectArray[0]);
                return number instanceof Long ? (Number)number : (Number)new Long((long)number.doubleValue());
            }
        });
        this.define(new Interpreter.JFunction("round", 1){

            public Object applyTo(Object[] objectArray) {
                Number number = this.mustBe(Number.class, objectArray[0]);
                return number instanceof Long ? (Number)number : (Number)new Long(Math.round(number.doubleValue()));
            }
        });
        this.define(new Interpreter.JFunction("sin", 1){

            public Object applyTo(Object[] objectArray) {
                Number number = this.mustBe(Number.class, objectArray[0]);
                double d = number.doubleValue();
                return new Double(Math.sin(d));
            }
        });
        this.define(new Interpreter.JFunction("cos", 1){

            public Object applyTo(Object[] objectArray) {
                Number number = this.mustBe(Number.class, objectArray[0]);
                double d = number.doubleValue();
                return new Double(Math.cos(d));
            }
        });
        this.define(new Interpreter.JFunction("tan", 1){

            public Object applyTo(Object[] objectArray) {
                Number number = this.mustBe(Number.class, objectArray[0]);
                double d = number.doubleValue();
                return new Double(Math.tan(d));
            }
        });
        this.define(new Interpreter.JFunction("asin", 1){

            public Object applyTo(Object[] objectArray) {
                Number number = this.mustBe(Number.class, objectArray[0]);
                double d = number.doubleValue();
                return new Double(Math.asin(d));
            }
        });
        this.define(new Interpreter.JFunction("acos", 1){

            public Object applyTo(Object[] objectArray) {
                Number number = this.mustBe(Number.class, objectArray[0]);
                double d = number.doubleValue();
                return new Double(Math.acos(d));
            }
        });
        this.define(new Interpreter.JFunction("atan", 1){

            public Object applyTo(Object[] objectArray) {
                Number number = this.mustBe(Number.class, objectArray[0]);
                double d = number.doubleValue();
                return new Double(Math.atan(d));
            }
        });
        this.define(new Interpreter.JFunction("atan2", 2){

            public Object applyTo(Object[] objectArray) {
                Number number = this.mustBe(Number.class, objectArray[0]);
                Number number2 = this.mustBe(Number.class, objectArray[1]);
                return new Double(Math.atan2(number.doubleValue(), number2.doubleValue()));
            }
        });
        this.define(new Interpreter.JFunction("to-radians", 1){

            public Object applyTo(Object[] objectArray) {
                Number number = this.mustBe(Number.class, objectArray[0]);
                double d = number.doubleValue();
                return new Double(Math.toRadians(d));
            }
        });
        this.define(new Interpreter.JFunction("to-degrees", 1){

            public Object applyTo(Object[] objectArray) {
                Number number = this.mustBe(Number.class, objectArray[0]);
                double d = number.doubleValue();
                return new Double(Math.toDegrees(d));
            }
        });
        this.define(new Interpreter.JFunction("sqrt", 1){

            public Object applyTo(Object[] objectArray) {
                Number number = this.mustBe(Number.class, objectArray[0]);
                double d = number.doubleValue();
                return new Double(Math.sqrt(d));
            }
        });
        this.define(new Interpreter.JFunction("print", -1){

            public Object applyTo(Object[] objectArray) {
                for (int i = 0; i < objectArray.length; ++i) {
                    System.out.print(objectArray[i].toString());
                }
                return Lisp.NIL;
            }

            public boolean isSafe() {
                return false;
            }
        });
        this.define(new Interpreter.JFunction("println", -1){

            public Object applyTo(Object[] objectArray) {
                for (int i = 0; i < objectArray.length; ++i) {
                    System.out.print(objectArray[i].toString());
                }
                System.out.println("");
                return Lisp.NIL;
            }

            public boolean isSafe() {
                return false;
            }
        });
        this.define(new Interpreter.JFunction("read", 0){

            public Object applyTo(Object[] objectArray) {
                return LispInterpreter.this.reader.readObject();
            }

            public boolean isSafe() {
                return false;
            }
        });
        this.define(new Interpreter.JFunction("read-line", 0){

            public Object applyTo(Object[] objectArray) {
                return Util.readLine(System.in);
            }

            public boolean isSafe() {
                return false;
            }
        });
        this.define(new Interpreter.JFunction("find-java-class", 1){

            public Object applyTo(Object[] objectArray) {
                String string = Util.mustBeStringlike(objectArray[0]);
                Class clazz = Util.classForNameElseNull(string);
                return clazz == null ? Lisp.NIL : clazz;
            }

            public boolean isSafe() {
                return false;
            }
        });
        this.define(new Interpreter.JFunction("java-call", -1){

            public Object applyTo(Object[] objectArray) {
                int n = objectArray.length;
                if (n < 2) {
                    throw new Interpreter.Error("Java-call wasn't given at least two arguments.");
                }
                Object object = objectArray[0];
                String string = Util.mustBeStringlike(objectArray[1]);
                Object[] objectArray2 = new Object[n - 2];
                System.arraycopy(objectArray, 2, objectArray2, 0, n - 2);
                try {
                    Object object2 = new Expression(object, string, objectArray2).getValue();
                    return object2 == null ? LispInterpreter.this.JAVA_NULL : object2;
                }
                catch (Exception exception) {
                    throw new RethrownException("Problem when calling Java method " + string + ":", exception);
                }
            }

            public boolean isSafe() {
                return false;
            }
        });
    }

    protected void defineInitialValues() {
        this.define("t", TRUE);
        this.define("TRUE", TRUE);
        this.define("FALSE", FALSE);
        this.define("PI", new Double(Math.PI));
        if (!this.acceptOnlySafeBuiltins) {
            this.define("JAVA-NULL", this.JAVA_NULL);
        }
    }

    public static final class JavaNull
    extends UniqueObject {
        private JavaNull() {
            super("Java null");
        }
    }

    public static class SyntaxError
    extends RuntimeException {
        public SyntaxError(String string) {
            super(string);
        }

        public SyntaxError(String string, Object object) {
            super(string + " " + object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class Syntax
    implements Parser {
        protected Symbol name;

        public Syntax(String string) {
            this.name = Symbol.intern(string);
        }

        protected void checkLength(int n, LList lList) {
            int n2 = lList.length();
            if (n2 > n) {
                throw new SyntaxError("Too many parameters in", lList);
            }
            if (n2 < n) {
                throw new SyntaxError("Too few parameters in", lList);
            }
        }

        protected <T> T mustBe(Class<T> clazz, Object object) {
            if (clazz.isInstance(object)) {
                return (T)object;
            }
            throw new SyntaxError(object + " is not " + Util.aClass(clazz));
        }

        protected LList mustBeLListOf(Class clazz, Object object) {
            LList lList = this.mustBe(LList.class, object);
            Iterator iterator = lList.iterator();
            while (iterator.hasNext()) {
                if (clazz.isInstance(iterator.next())) continue;
                throw new SyntaxError(object + " is not a list of " + Interpreter.nameForClass(clazz) + "s.");
            }
            return lList;
        }

        protected Interpreter.Expr parseBody(LList lList) {
            if (lList.cdr().isEmpty()) {
                return LispInterpreter.this.parseForm(lList.get(0));
            }
            return this.describe(new Interpreter.Sequence(LispInterpreter.this.parseList(lList)), new Cons(PROGN, lList));
        }

        protected Interpreter.Expr describe(Interpreter.Expr expr, Object object) {
            expr.setDescription(object);
            return expr;
        }
    }

    public static interface Parser {
        public Interpreter.Expr parse(LList var1);
    }
}

