/*
 * Decompiled with CFR 0.152.
 */
package ix.util.lisp;

import ix.util.Debug;
import ix.util.SemiPrimitive;
import ix.util.lisp.DelimitedSymbol;
import ix.util.lisp.ItemVar;
import ix.util.lisp.Keyword;
import ix.util.lisp.LispObject;
import ix.util.lisp.NumberlikeSymbol;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Hashtable;

public class Symbol
implements LispObject,
SemiPrimitive,
Comparable,
Serializable {
    protected static Hashtable obTable = new Hashtable();
    protected String name;

    protected Symbol(String string) {
        this.name = string;
        Debug.expect(obTable.get(string) == null, "symbol already exists", string);
        obTable.put(string, this);
    }

    public static synchronized Symbol intern(String string) {
        Symbol symbol = (Symbol)obTable.get(string);
        if (symbol != null) {
            return symbol;
        }
        if (string.length() == 0) {
            return new DelimitedSymbol(string);
        }
        char c = string.charAt(0);
        switch (c) {
            case ':': {
                return new Keyword(string);
            }
            case '?': {
                return new ItemVar(string);
            }
            case '+': {
                return Symbol.maybeNumber(string);
            }
            case '-': {
                return Symbol.maybeNumber(string);
            }
            case '.': {
                return Symbol.maybeNumber(string);
            }
        }
        return Character.isDigit(c) ? Symbol.maybeNumber(string) : Symbol.maybeSpecial(string);
    }

    static synchronized Symbol quickIntern(String string) {
        Symbol symbol = (Symbol)obTable.get(string);
        if (symbol != null) {
            return symbol;
        }
        if (string.length() == 0) {
            return new DelimitedSymbol(string);
        }
        char c = string.charAt(0);
        switch (c) {
            case ':': {
                return new Keyword(string);
            }
            case '?': {
                return new ItemVar(string);
            }
        }
        return new Symbol(string);
    }

    private static Symbol maybeNumber(String string) {
        try {
            Long.valueOf(string);
            return new NumberlikeSymbol(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Double.valueOf(string);
                return new NumberlikeSymbol(string);
            }
            catch (NumberFormatException numberFormatException2) {
                return Symbol.maybeSpecial(string);
            }
        }
    }

    private static Symbol maybeSpecial(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != ' ' && c != '\n' && c != '\r' && c != '\"' && c != '|' && c != '\\' && c != '(' && c != ')' && c != '[' && c != ']' && c != ',' && c != ';') continue;
            return new DelimitedSymbol(string);
        }
        return new Symbol(string);
    }

    public static synchronized boolean exists(String string) {
        return obTable.get(string) != null;
    }

    public int compareTo(Object object) {
        if (object instanceof Symbol) {
            return this.name.compareTo(((Symbol)object).name);
        }
        throw new ClassCastException("Cannot compare symbol " + this + " to " + object);
    }

    protected Object readResolve() throws ObjectStreamException {
        return Symbol.intern(this.name);
    }

    public String toString() {
        return this.name;
    }

    public static Symbol valueOf(String string) {
        return Symbol.intern(string);
    }
}

