/*
 * Decompiled with CFR 0.152.
 */
package ix.util.owls;

import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import ix.icore.Activity;
import ix.icore.domain.End;
import ix.icore.domain.Refinement;
import ix.icore.plan.ProcessParameter;
import ix.icore.process.PNode;
import ix.icore.process.PNodeEnd;
import ix.ip2.AgendaItem;
import ix.ip2.Ip2;
import ix.ip2.Ip2ModelManager;
import ix.iplan.ServiceSymbols;
import ix.test.PlainIp2;
import ix.util.Debug;
import ix.util.NameMapper;
import ix.util.Parameters;
import ix.util.TopologicalSorter;
import ix.util.lisp.ItemVar;
import ix.util.owls.ProcessDataFlow;
import ix.util.owls.ProcessWriter;
import ix.util.xml.XML;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mindswap.owl.OWLResource;
import org.mindswap.owls.OWLSFactory;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.CompositeProcess;
import org.mindswap.owls.process.ControlConstruct;
import org.mindswap.owls.process.DataFlow;
import org.mindswap.owls.process.DataFlowElement;
import org.mindswap.owls.process.Parameter;
import org.mindswap.owls.process.ParameterList;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.ProcessComponentList;
import org.mindswap.owls.process.ProcessModel;
import org.mindswap.owls.process.Sequence;
import org.mindswap.owls.service.Service;

public class PlanToOWLS
implements ServiceSymbols {
    Ip2 ip2;
    NameMapper nameMap;
    CompositeProcess topLevelProcess;
    Map activityToProcessMap = new HashMap();

    public PlanToOWLS(Ip2 ip2) {
        this.ip2 = ip2;
        Map map = (Map)ip2.getDomain().getAnnotation(S_NAME_MAP);
        this.nameMap = map != null ? new NameMapper(map) : null;
    }

    public Service planToService() {
        Resource resource = ResourceFactory.createResource((String)"#composed-service");
        Service service = OWLSFactory.createService((Resource)resource);
        ProcessModel processModel = OWLSFactory.createProcessModel();
        CompositeProcess compositeProcess = OWLSFactory.createCompositeProcess((Resource)ResourceFactory.createResource((String)"#main-process"));
        service.setProcessModel(processModel);
        processModel.setProcess((Process)compositeProcess);
        compositeProcess.setService(service);
        this.topLevelProcess = compositeProcess;
        Sequence sequence = OWLSFactory.createSequence();
        compositeProcess.setComposedOf((ControlConstruct)sequence);
        List list = this.listAtomicSteps();
        ProcessComponentList processComponentList = sequence.getComponents();
        for (PNode pNode : list) {
            Activity activity = (Activity)((AgendaItem)pNode).getAbout();
            String string = this.getProcessURI(pNode);
            Resource resource2 = ResourceFactory.createResource((String)string);
            AtomicProcess atomicProcess = OWLSFactory.createAtomicProcess((Resource)resource2);
            this.activityToProcessMap.put(activity, atomicProcess);
            processComponentList.add((Object)atomicProcess);
        }
        this.addDataFlow(compositeProcess, list);
        return service;
    }

    boolean isServiceNode(PNode pNode) {
        String string = this.getServiceRef(pNode);
        boolean bl = this.nameMap == null || this.nameMap.hasLongName(string);
        return bl && this.ip2.getDomain().getNamedRefinement(string) != null;
    }

    String getProcessURI(PNode pNode) {
        String string;
        String string2 = this.getServiceRef(pNode);
        Refinement refinement = this.ip2.getDomain().getNamedRefinement(string2);
        if (refinement != null && (string = (String)refinement.getAnnotation(S_OWL_S_PROCESS)) != null) {
            return string;
        }
        return string2 + "#process";
    }

    String getServiceRef(PNode pNode) {
        return pNode.getPattern().car().toString();
    }

    List listAtomicSteps() {
        List list = this.getNodeEnds();
        List list2 = new TopologicalSorter(){

            protected Collection getChildren(Object object) {
                return ((PNodeEnd)object).getSuccessors();
            }
        }.sort(list);
        LinkedList<PNode> linkedList = new LinkedList<PNode>();
        for (PNodeEnd pNodeEnd : list2) {
            PNode pNode;
            if (pNodeEnd.getEnd() == End.END || !(pNode = pNodeEnd.getNode()).getChildren().isEmpty() || !this.isServiceNode(pNode)) continue;
            linkedList.add(pNode);
        }
        return linkedList;
    }

    List getNodeEnds() {
        return ((Ip2ModelManager)this.ip2.getModelManager()).getNodeEnds();
    }

    void addDataFlow(CompositeProcess compositeProcess, List list) {
        ProcessDataFlow processDataFlow = new ProcessDataFlow(list);
        List list2 = processDataFlow.getSameValueLists();
        List list3 = processDataFlow.getInitialInputs();
        List list4 = processDataFlow.getFinalOutputs();
        Debug.noteln("Data-flow", (Object)XML.objectToXMLString(list2));
        Debug.noteln("Initial inputs", (Object)XML.objectToXMLString(list3));
        Debug.noteln("Final outputs", (Object)XML.objectToXMLString(list4));
        this.addParamters((ParameterList)compositeProcess.getInputs(), list3);
        this.addParamters((ParameterList)compositeProcess.getOutputs(), list4);
        List list5 = processDataFlow.makeFullSameList(list3, list4);
        DataFlow dataFlow = compositeProcess.getDataFlow();
        for (List list6 : list5) {
            if (list6.size() <= 1) continue;
            dataFlow.add((Object)this.makeDataFlowElement(list6));
        }
    }

    void addParamters(ParameterList parameterList, List list) {
        for (ProcessParameter processParameter : list) {
            Parameter parameter = this.makeOWLSParameter(processParameter);
            parameter.setType(this.getOWLSType(processParameter));
            parameterList.add((Object)parameter);
        }
    }

    DataFlowElement makeDataFlowElement(List list) {
        DataFlowElement dataFlowElement = OWLSFactory.createDataFlowElement();
        for (ProcessParameter processParameter : list) {
            dataFlowElement.add((Object)this.makeParameter(processParameter));
        }
        return dataFlowElement;
    }

    Parameter makeParameter(ProcessParameter processParameter) {
        Parameter parameter = this.makeOWLSParameter(processParameter);
        Activity activity = processParameter.getActivity();
        if (activity == null) {
            parameter.setProcess((Process)this.topLevelProcess);
        } else {
            Process process = (Process)this.activityToProcessMap.get(activity);
            Debug.expect(process != null, "no process for", activity);
            parameter.setProcess(process);
        }
        return parameter;
    }

    Parameter makeOWLSParameter(ProcessParameter processParameter) {
        ItemVar itemVar = (ItemVar)processParameter.getName();
        String string = itemVar.toString().substring(1);
        String string2 = this.nameMap != null && this.nameMap.hasLongName(string) ? this.nameMap.longName(string) : "#" + string;
        Resource resource = ResourceFactory.createResource((String)string2);
        return processParameter.isInput() ? OWLSFactory.createInput((Resource)resource) : OWLSFactory.createOutput((Resource)resource);
    }

    OWLResource getOWLSType(ProcessParameter processParameter) {
        String string = processParameter.getType().toString();
        String string2 = this.nameMap != null && this.nameMap.hasLongName(string) ? this.nameMap.longName(string) : string;
        return OWLSFactory.createOWLResource((Resource)ResourceFactory.createResource((String)string2));
    }

    public static void main(String[] stringArray) throws Exception {
        Debug.off();
        PlainIp2 plainIp2 = new PlainIp2();
        plainIp2.mainStartup(stringArray);
        Debug.on = Parameters.getBoolean("debug", true);
        PlanToOWLS planToOWLS = new PlanToOWLS(plainIp2);
        Service service = planToOWLS.planToService();
        ProcessWriter processWriter = new ProcessWriter();
        processWriter.write(service, System.out);
    }
}

