/*
 * Decompiled with CFR 0.152.
 */
package ix.util.rdf;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import ix.test.xml.Mapping;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.ListOf;
import ix.util.Strings;
import ix.util.TypedList;
import ix.util.Util;
import ix.util.lisp.Cons;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.rdf.Rdf;
import ix.util.rdf.RdfTranslator;
import ix.util.rdf.Vocabulary;
import ix.util.reflect.ClassDescr;
import ix.util.reflect.ClassSyntax;
import ix.util.reflect.FieldDescr;
import ix.util.reflect.Stringer;
import ix.util.xml.XMLException;
import ix.util.xml.XMLTranslator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ModelParser {
    Vocabulary ix = new Vocabulary("http://www.aiai.ed.ac.uk/~jeff/ix/3.x/owl/");
    ClassSyntax classSyntax = Rdf.classSyntax();
    Map resourceToObjectMap = new HashMap();
    Set rootObjects = new HashSet();
    boolean processedModel = false;
    RdfTranslator translator;
    Model model;

    ModelParser(RdfTranslator rdfTranslator, Model model) {
        this.translator = rdfTranslator;
        this.model = model;
    }

    Object getRootObject() {
        this.processModel();
        if (this.rootObjects.size() > 1) {
            throw new RuntimeException("More than one root object");
        }
        if (this.rootObjects.size() < 1) {
            throw new RuntimeException("No root object");
        }
        return this.rootObjects.toArray()[0];
    }

    void processModel() {
        RDFNode rDFNode;
        Object object;
        if (this.processedModel) {
            return;
        }
        this.processedModel = true;
        if (this.model.containsResource((RDFNode)RDF.nil)) {
            this.resourceToObjectMap.put(RDF.nil, Lisp.NIL);
        }
        Object object2 = this.model.listSubjects();
        while (object2.hasNext()) {
            object = object2.nextResource();
            this.processResource((Resource)object);
        }
        object2 = new HashSet(this.resourceToObjectMap.keySet());
        object = this.model.listObjects();
        while (object.hasNext()) {
            rDFNode = object.nextNode();
            object2.remove(rDFNode);
        }
        object = object2.iterator();
        while (object.hasNext()) {
            rDFNode = (Resource)object.next();
            this.rootObjects.add(this.resourceToObject((Resource)rDFNode));
        }
    }

    Object processResource(Resource resource) {
        Object object = this.resourceToObjectMap.get(resource);
        if (object == null) {
            object = this.buildObject(resource);
            this.resourceToObjectMap.put(resource, object);
        }
        return object;
    }

    Object resourceToObject(Resource resource) {
        Object object = this.processResource(resource);
        return object;
    }

    Resource rdfType(Resource resource) {
        Statement statement = resource.getProperty(RDF.type);
        if (statement == null) {
            return null;
        }
        Resource resource2 = (Resource)statement.getObject();
        return resource2;
    }

    Object buildObject(Resource resource) {
        Resource resource2 = this.rdfType(resource);
        if (resource2 == null) {
            return this.tryAsList(resource);
        }
        if (!this.ix.contains(resource2)) {
            throw new IllegalArgumentException("Unknown type " + resource2 + " for " + resource);
        }
        String string = this.ix.name(resource2);
        if (string.equals("null")) {
            return null;
        }
        Class clazz = this.classSyntax.classForExternalName(string);
        if (clazz == null) {
            throw new XMLException("Cannot find class " + string);
        }
        return this.buildObject(clazz, resource);
    }

    Object buildObject(Class clazz, Resource resource) {
        Object object = null;
        ClassDescr classDescr = this.classSyntax.getClassDescr(clazz);
        if (clazz == String.class) {
            object = this.stringFromResource(clazz, resource);
        } else if (classDescr.isPrimitive()) {
            object = this.primitiveObjectFromResource(clazz, resource);
        } else if (clazz == Mapping.class) {
            object = ((Mapping)this.structFromResource(clazz, resource)).toMap();
        } else if (classDescr.isStruct()) {
            object = this.structFromResource(clazz, resource);
        } else {
            throw new ConsistencyException("Unknown object type " + classDescr);
        }
        return object;
    }

    LList tryAsList(Resource resource) {
        Statement statement = resource.getProperty(RDF.first);
        Debug.expect(statement != null, "Invalid map - missing first -", resource);
        Statement statement2 = resource.getProperty(RDF.rest);
        Debug.expect(statement2 != null, "Invalid list - missing rest -", resource);
        Resource resource2 = (Resource)statement.getObject();
        Resource resource3 = (Resource)statement2.getObject();
        return new Cons(this.resourceToObject(resource2), (LList)this.resourceToObject(resource3));
    }

    String stringFromResource(Class clazz, Resource resource) {
        Statement statement = resource.getProperty(this.ix.property("litvalue"));
        Debug.expect(statement != null, "No value property", resource);
        Literal literal = (Literal)statement.getObject();
        String string = this.classSyntax.xmlSchemaDatatype(clazz);
        String string2 = Strings.afterFirst("#", literal.getDatatypeURI());
        Debug.expectEquals(string, string2);
        return literal.getLexicalForm();
    }

    Object primitiveObjectFromResource(Class clazz, Resource resource) {
        ClassDescr classDescr = this.classSyntax.getClassDescr(clazz);
        if (classDescr.isEnumeration()) {
            return this.primitiveObjectFromString(clazz, resource.getLocalName());
        }
        return this.primitiveObjectFromString(clazz, this.stringFromResource(clazz, resource));
    }

    Object primitiveObjectFromString(Class clazz, String string) {
        Stringer stringer = this.classSyntax.getStringer(clazz);
        if (stringer != null) {
            return stringer.fromString(string);
        }
        try {
            Method method = clazz.getMethod("valueOf", String.class);
            return method.invoke(null, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            Debug.noteException(invocationTargetException);
            throw new XMLException("Can't convert to " + clazz, invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            throw new XMLException("Can't convert to " + clazz, exception);
        }
    }

    Object mapFromRDFList(Class clazz, Resource resource) {
        Statement statement = resource.getProperty(RDF.first);
        Debug.expect(statement != null, "Invalid map - missing first -", resource);
        Statement statement2 = resource.getProperty(RDF.rest);
        Debug.expect(statement2 != null, "Invalid map - missing rest -", resource);
        Resource resource2 = (Resource)statement.getObject();
        Resource resource3 = (Resource)statement2.getObject();
        return new Cons(this.resourceToObject(resource2), (LList)this.processResource(resource3));
    }

    Object structFromResource(Class clazz, Resource resource) {
        Object t = Util.makeInstance(clazz);
        ClassDescr classDescr = this.classSyntax.getClassDescr(clazz);
        for (FieldDescr fieldDescr : classDescr.getFieldDescrs()) {
            Object object = this.fieldValue(t, fieldDescr, resource);
            try {
                if (object == null) continue;
                this.setFieldValue(t, fieldDescr, object);
            }
            catch (Exception exception) {
                Debug.noteException(exception);
                throw new XMLException("Cannot set field " + fieldDescr.getName(), exception);
            }
        }
        return t;
    }

    void setFieldValue(Object object, FieldDescr fieldDescr, Object object2) throws IllegalAccessException, InvocationTargetException {
        Class clazz;
        Class clazz2 = fieldDescr.getType();
        Class clazz3 = clazz = clazz2.isPrimitive() ? XMLTranslator.wrapperClass(clazz2) : clazz2;
        if (clazz.isInstance(object2)) {
            fieldDescr.setValue(object, object2);
            return;
        }
        ClassDescr classDescr = fieldDescr.getTypeDescr();
        if (!classDescr.isInterface()) {
            if (object2 instanceof Collection && classDescr.isCollection()) {
                Collection collection = (Collection)Util.makeInstance(clazz2);
                collection.addAll((Collection)object2);
                fieldDescr.setValue(object, collection);
                return;
            }
            if (object2 instanceof Map && classDescr.isMap()) {
                Map map = (Map)Util.makeInstance(clazz2);
                map.putAll((Map)object2);
                fieldDescr.setValue(object, map);
                return;
            }
        }
        throw new IllegalArgumentException("Field cannot accept a value of class " + object2.getClass());
    }

    Object fieldValue(Object object, FieldDescr fieldDescr, Resource resource) {
        ClassDescr classDescr = fieldDescr.getTypeDescr();
        String string = fieldDescr.getExternalName();
        if (classDescr.isTypedList()) {
            Property property = this.ix.singular(string);
            return this.getListValue(classDescr, resource, property);
        }
        return this.getResourceValue(classDescr, resource, this.ix.property(string));
    }

    Object getResourceValue(ClassDescr classDescr, Resource resource, Property property) {
        Resource resource2 = (Resource)this.onlyPropertyValue(resource, property);
        return resource2 == null ? null : this.resourceToObject(resource2);
    }

    RDFNode onlyPropertyValue(Resource resource, Property property) {
        StmtIterator stmtIterator = resource.listProperties(property);
        if (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            if (stmtIterator.hasNext()) {
                throw new IllegalArgumentException("More than one value for resource " + resource + " property " + property);
            }
            return statement.getObject();
        }
        return null;
    }

    List getListValue(ClassDescr classDescr, Resource resource, Property property) {
        StmtIterator stmtIterator = resource.listProperties(property);
        if (!stmtIterator.hasNext()) {
            return null;
        }
        Class clazz = classDescr.theClass;
        Debug.expect(TypedList.class.isAssignableFrom(clazz));
        Class clazz2 = ListOf.findImplementationClass(clazz, LinkedList.class);
        if (clazz2 == null) {
            throw new XMLException("Cannot find a linked implementation for " + clazz);
        }
        TypedList typedList = (TypedList)Util.makeInstance(clazz2);
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            typedList.add(this.resourceToObject((Resource)statement.getObject()));
        }
        return typedList;
    }
}

