/*
 * Decompiled with CFR 0.152.
 */
package ix.util.rdf;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDF;
import ix.test.xml.MapEntry;
import ix.test.xml.Mapping;
import ix.util.Debug;
import ix.util.EnumeratedValue;
import ix.util.rdf.Rdf;
import ix.util.rdf.RdfTranslator;
import ix.util.rdf.Vocabulary;
import ix.util.reflect.ClassDescr;
import ix.util.reflect.ClassSyntax;
import ix.util.reflect.FieldDescr;
import ix.util.reflect.Stringer;
import ix.util.xml.XMLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class ObjectModel {
    Vocabulary ix = new Vocabulary("http://www.aiai.ed.ac.uk/~jeff/ix/3.x/owl/");
    ClassSyntax classSyntax = Rdf.classSyntax();
    RdfTranslator translator;
    Object root;
    Model model;

    ObjectModel(RdfTranslator rdfTranslator, Object object) {
        this.translator = rdfTranslator;
        this.root = object;
    }

    Model getModel() {
        Debug.expect(this.model == null, "model already built in", this);
        this.model = this.makeModel();
        this.objectToResource(this.root);
        return this.model;
    }

    Model makeModel() {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("ix", this.ix.getHashURI());
        return model;
    }

    Resource objectToResource(Object object) {
        if (object == null) {
            return this.nullToResource();
        }
        if (object instanceof String) {
            return this.stringToResource((String)object);
        }
        ClassDescr classDescr = this.classSyntax.getClassDescr(object.getClass());
        if (classDescr.isPrimitive()) {
            return this.primitiveToResource(object);
        }
        if (classDescr.isList()) {
            return this.listToResource((List)object);
        }
        if (classDescr.isMap()) {
            return this.mapToResource((Map)object);
        }
        if (classDescr.isStruct()) {
            return this.structToResource(object);
        }
        throw new IllegalArgumentException("Unknown type " + classDescr);
    }

    Resource nullToResource() {
        Resource resource = this.model.createResource();
        resource.addProperty(RDF.type, (RDFNode)this.ix.resource("null"));
        return resource;
    }

    Resource stringToResource(String string) {
        return this.primitiveToResource(string);
    }

    Resource primitiveToResource(Object object) {
        Resource resource;
        Class<?> clazz = object.getClass();
        ClassDescr classDescr = this.classSyntax.getClassDescr(clazz);
        String string = classDescr.getExternalName();
        if (object instanceof EnumeratedValue) {
            String string2 = this.ix.getBaseURI() + classDescr.getExternalName();
            resource = this.model.createResource(string2 + "#" + object);
        } else {
            resource = this.model.createResource();
            resource.addProperty(this.ix.property("litvalue"), (RDFNode)this.primitiveToLiteral(object));
        }
        resource.addProperty(RDF.type, (RDFNode)this.ix.resource(string));
        return resource;
    }

    Literal primitiveToLiteral(Object object) {
        Class<?> clazz = object.getClass();
        Stringer<?> stringer = this.classSyntax.getStringer(clazz);
        String string = stringer != null ? stringer.toString(object) : object.toString();
        String string2 = this.classSyntax.xmlSchemaDatatype(clazz);
        XSDDatatype xSDDatatype = new XSDDatatype(string2);
        return this.model.createTypedLiteral(string, (RDFDatatype)xSDDatatype);
    }

    Resource listToResource(List list) {
        ArrayList<Resource> arrayList = new ArrayList<Resource>(list.size());
        RDFList rDFList = list.iterator();
        while (rDFList.hasNext()) {
            arrayList.add(this.objectToResource(rDFList.next()));
        }
        rDFList = this.model.createList(arrayList.iterator());
        Debug.expect(rDFList.isValid(), "Invalid list", rDFList.getValidityErrorMessage());
        return rDFList;
    }

    Resource mapToResource(Map map) {
        return this.objectToResource(new Mapping(map));
    }

    RDFList mapToRDFList(Map map) {
        return this.mapToRDFList(map.entrySet().iterator());
    }

    private RDFList mapToRDFList(Iterator iterator) {
        if (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Resource resource = this.objectToResource(new MapEntry(entry));
            RDFList rDFList = this.mapToRDFList(iterator);
            RDFList rDFList2 = rDFList.cons((RDFNode)resource);
            rDFList2.addProperty(RDF.type, (RDFNode)this.ix.resource("map"));
            return rDFList2;
        }
        return this.model.createList();
    }

    Resource structToResource(Object object) {
        Class<?> clazz = object.getClass();
        ClassDescr classDescr = this.classSyntax.getClassDescr(clazz);
        String string = classDescr.getExternalName();
        List<FieldDescr> list = classDescr.getFieldDescrs();
        Resource resource = this.model.createResource();
        resource.addProperty(RDF.type, (RDFNode)this.ix.resource(string));
        for (FieldDescr fieldDescr : list) {
            this.visitField(object, fieldDescr, resource);
        }
        return resource;
    }

    void visitField(Object object, FieldDescr fieldDescr, Resource resource) {
        Object object2 = this.getFieldValue(object, fieldDescr);
        if (object2 == null) {
            return;
        }
        ClassDescr classDescr = fieldDescr.getTypeDescr();
        String string = fieldDescr.getExternalName();
        if (classDescr.isTypedList()) {
            Property property = this.ix.singular(string);
            Iterator iterator = ((List)object2).iterator();
            while (iterator.hasNext()) {
                resource.addProperty(property, (RDFNode)this.objectToResource(iterator.next()));
            }
        } else {
            resource.addProperty(this.ix.property(string), (RDFNode)this.objectToResource(object2));
        }
    }

    Object getFieldValue(Object object, FieldDescr fieldDescr) {
        try {
            return fieldDescr.getValue(object);
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            throw new XMLException("Cannot get value of field " + fieldDescr.getName() + " of class " + object.getClass().getName(), exception);
        }
    }
}

