/*
 * Decompiled with CFR 0.152.
 */
package ix.util.reflect;

import ix.util.Debug;
import ix.util.Duration;
import ix.util.ISODateFormat;
import ix.util.ListOf;
import ix.util.Predicate1;
import ix.util.RethrownException;
import ix.util.Strings;
import ix.util.TypedList;
import ix.util.Util;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.reflect.AliasFields;
import ix.util.reflect.ClassDescr;
import ix.util.reflect.ClassFinder;
import ix.util.reflect.ElementClass;
import ix.util.reflect.FieldDescr;
import ix.util.reflect.FieldMap;
import ix.util.reflect.HiddenFields;
import ix.util.reflect.Stringer;
import ix.util.xml.XML;
import ix.util.xml.XMLSchemaSyntax;
import java.awt.Color;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassSyntax {
    protected ClassFinder classFinder;
    protected Map<Class, ClassDescr> classToDescrCache = new HashMap<Class, ClassDescr>();
    protected Map<Class, Stringer> classToStringerMap = new HashMap<Class, Stringer>();

    public ClassSyntax() {
        this(XML.config().defaultClassFinder());
    }

    public ClassSyntax(ClassFinder classFinder) {
        Debug.expect(classFinder != null, "Null ClassFinder");
        this.classFinder = classFinder;
        this.initStringConversions();
    }

    public ClassFinder getClassFinder() {
        return this.classFinder;
    }

    public String externalNameForClass(Class clazz) {
        return this.classFinder.nameForClass(clazz);
    }

    public Class classForExternalName(String string) {
        return this.classFinder.classForName(string);
    }

    public String externalNameForField(String string) {
        return this.classFinder.externalFieldName(string);
    }

    public String upperNameForClass(Class clazz) {
        String string = this.externalNameForClass(clazz);
        return string.toUpperCase();
    }

    public ClassDescr getClassDescr(Class clazz) {
        ClassDescr classDescr = this.classToDescrCache.get(clazz);
        if (classDescr == null) {
            classDescr = this.makeClassDescr(clazz);
            this.classToDescrCache.put(clazz, classDescr);
        }
        return classDescr;
    }

    protected ClassDescr makeClassDescr(Class clazz) {
        if (TypedList.class.isAssignableFrom(clazz)) {
            return new ClassDescr(this, clazz, ListOf.elementClass(clazz));
        }
        return new ClassDescr(this, clazz);
    }

    public ClassDescr makeClassDescr(Class clazz, Class clazz2) {
        return new ClassDescr(this, clazz, clazz2);
    }

    public ClassDescr makeClassDescr(Class clazz, Class clazz2, Class clazz3) {
        return new ClassDescr(this, clazz, clazz2, clazz3);
    }

    public String xmlSchemaDatatype(Class clazz) {
        String string;
        Stringer stringer = this.getStringer(clazz);
        if (stringer != null && (string = stringer.xmlSchemaDatatype()) != null) {
            return string;
        }
        return XMLSchemaSyntax.getSimpleType(clazz);
    }

    public <T> Stringer<T> getStringer(Class<T> clazz) {
        return this.classToStringerMap.get(clazz);
    }

    protected <T> void setStringer(Class<T> clazz, Stringer<T> stringer) {
        this.classToStringerMap.put(clazz, stringer);
    }

    protected void initStringConversions() {
        this.setStringer(Date.class, new Stringer<Date>(){
            ISODateFormat format = new ISODateFormat();

            @Override
            public String toString(Date date) {
                return this.format.formatDateTime(date);
            }

            @Override
            public Date fromString(String string) {
                return this.format.parseDateTime(string);
            }

            @Override
            public String xmlSchemaDatatype() {
                return "dateTime";
            }
        });
        this.setStringer(Duration.class, new Stringer<Duration>(){

            @Override
            public String toString(Duration duration) {
                return duration.toISOString();
            }

            @Override
            public Duration fromString(String string) {
                return new Duration(string);
            }

            @Override
            public String xmlSchemaDatatype() {
                return "duration";
            }
        });
        this.setStringer(URI.class, new Stringer<URI>(){

            @Override
            public String toString(URI uRI) {
                return uRI.toString();
            }

            @Override
            public URI fromString(String string) {
                try {
                    return new URI(string);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new RethrownException(uRISyntaxException);
                }
            }

            @Override
            public String xmlSchemaDatatype() {
                return "anyURI";
            }
        });
        this.setStringer(URL.class, new Stringer<URL>(){

            @Override
            public String toString(URL uRL) {
                return uRL.toString();
            }

            @Override
            public URL fromString(String string) {
                try {
                    return new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new RethrownException(malformedURLException);
                }
            }

            @Override
            public String xmlSchemaDatatype() {
                return "anyURI";
            }
        });
        this.setStringer(Color.class, new Stringer<Color>(){

            @Override
            public String toString(Color color) {
                return Integer.toString(color.getRGB());
            }

            @Override
            public Color fromString(String string) {
                try {
                    return Color.decode(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new RethrownException(numberFormatException);
                }
            }

            @Override
            public String xmlSchemaDatatype() {
                return "int";
            }
        });
    }

    public List<Class> relevantClasses(Class clazz) {
        return this.relevantClasses(Lisp.list(clazz));
    }

    public List<Class> relevantClasses(Class[] classArray) {
        return this.relevantClasses(Arrays.asList(classArray));
    }

    public List<Class> relevantClasses(List<Class> list) {
        LinkedList<Class> linkedList = new LinkedList<Class>();
        for (Class clazz : list) {
            this.collectRelevantClasses(clazz, linkedList, (List)Lisp.NIL);
        }
        linkedList.remove(Object.class);
        return linkedList;
    }

    public List<Class> expandRelevantClasses(List<Class> list) {
        LinkedList<Class> linkedList = new LinkedList<Class>();
        LList lList = LList.newLList(list);
        while (!lList.isEmpty()) {
            Class clazz = (Class)lList.car();
            Debug.expect(!linkedList.contains(clazz));
            this.collectRelevantClasses(clazz, linkedList, (List)lList.cdr());
            lList = lList.cdr();
        }
        linkedList.remove(Object.class);
        return linkedList;
    }

    protected void collectRelevantClasses(Class clazz, List list, List list2) {
        if (clazz == null || list.contains(clazz) || list2.contains(clazz)) {
            return;
        }
        list.add(clazz);
        ClassDescr classDescr = this.getClassDescr(clazz);
        if (classDescr.isStruct()) {
            for (FieldDescr fieldDescr : classDescr.getFieldDescrs()) {
                this.collectRelevantClasses(fieldDescr.getTypeDescr(), list, list2);
            }
        }
    }

    protected void collectRelevantClasses(ClassDescr classDescr, List list, List list2) {
        if (classDescr == null) {
            return;
        }
        if (classDescr.isCollection()) {
            this.collectRelevantClasses(classDescr.getEltType(), list, list2);
        } else if (classDescr.isMap()) {
            this.collectRelevantClasses(classDescr.getKeyType(), list, list2);
            this.collectRelevantClasses(classDescr.getValType(), list, list2);
        } else {
            this.collectRelevantClasses(classDescr.getDescribedClass(), list, list2);
        }
    }

    FieldMap makeFieldDescrs(Class clazz) {
        return this.collectFieldInfo(clazz);
    }

    protected FieldMap collectFieldInfo(Class clazz) {
        Object object;
        FieldMap fieldMap = this.collectFields(clazz, new FieldMap());
        HiddenFields hiddenFields = clazz.getAnnotation(HiddenFields.class);
        if (hiddenFields != null) {
            object = hiddenFields.value();
            for (int i = 0; i < ((String[])object).length; ++i) {
                fieldMap.remove(fieldMap.fieldForName((String)object[i]));
            }
        }
        if ((object = clazz.getAnnotation(AliasFields.class)) != null) {
            String[] stringArray = object.value();
            for (int i = 0; i < stringArray.length; ++i) {
                Object[] objectArray = Strings.breakAtFirst("->", stringArray[i]);
                Object object2 = objectArray[0];
                Object object3 = objectArray[1];
                fieldMap.rename((String)object2, (String)object3, this);
            }
        }
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Method[] methodArray = this.getDeclaredMethods(clazz2);
            for (Method method : methodArray) {
                String string = method.getName();
                if (ClassSyntax.isGetName(string)) {
                    this.tryGetMethod(method, fieldMap);
                    continue;
                }
                if (!ClassSyntax.isSetName(string)) continue;
                this.trySetMethod(method, fieldMap);
            }
        }
        fieldMap.removeIf(new Predicate1<FieldDescr>(){

            @Override
            public boolean trueOf(FieldDescr fieldDescr) {
                return fieldDescr.getter == null || fieldDescr.setter == null;
            }
        });
        for (FieldDescr fieldDescr : fieldMap.getFields()) {
            fieldDescr.typeDescr = this.makeFieldTypeDescr(fieldDescr, clazz);
        }
        return fieldMap;
    }

    protected ClassDescr makeFieldTypeDescr(FieldDescr fieldDescr, Class clazz) {
        Class clazz2 = fieldDescr.getType();
        if (Collection.class.isAssignableFrom(clazz2)) {
            ElementClass elementClass = fieldDescr.getAnnotation(ElementClass.class);
            if (elementClass != null) {
                return this.makeClassDescr(clazz2, elementClass.value());
            }
            Class clazz3 = fieldDescr.determineElementType();
            if (clazz3 != null) {
                return this.makeClassDescr(clazz2, clazz3);
            }
        }
        return this.getClassDescr(clazz2);
    }

    protected Method[] getDeclaredMethods(Class clazz) {
        if (clazz == Object.class) {
            return new Method[0];
        }
        try {
            return clazz.getDeclaredMethods();
        }
        catch (SecurityException securityException) {
            Debug.forceln("Problem getting methods of " + clazz);
            Debug.noteException(securityException, false);
            return new Method[0];
        }
    }

    protected void tryGetMethod(Method method, FieldMap fieldMap) {
        Class<?>[] classArray = method.getParameterTypes();
        int n = method.getModifiers();
        if (!Modifier.isPublic(n) || classArray.length != 0) {
            return;
        }
        String string = ClassSyntax.fieldNameFromGetName(method.getName());
        FieldDescr fieldDescr = fieldMap.fieldForName(string);
        if (fieldDescr != null && fieldDescr.getter == null) {
            Class clazz = fieldDescr.getType();
            if (method.getReturnType() == clazz) {
                fieldDescr.getter = method;
            }
        }
    }

    protected void trySetMethod(Method method, FieldMap fieldMap) {
        Class clazz;
        Class<?>[] classArray = method.getParameterTypes();
        int n = method.getModifiers();
        if (!Modifier.isPublic(n) || classArray.length != 1) {
            return;
        }
        String string = ClassSyntax.fieldNameFromSetName(method.getName());
        FieldDescr fieldDescr = fieldMap.fieldForName(string);
        if (fieldDescr != null && fieldDescr.setter == null && classArray[0] == (clazz = fieldDescr.getType())) {
            fieldDescr.setter = method;
        }
    }

    public static final boolean isGetName(String string) {
        return string.length() > 3 && string.startsWith("get");
    }

    public static final boolean isSetName(String string) {
        return string.length() > 3 && string.startsWith("set");
    }

    public static final String fieldNameFromGetName(String string) {
        return Strings.uncapitalize(string.substring(3));
    }

    public static final String fieldNameFromSetName(String string) {
        return Strings.uncapitalize(string.substring(3));
    }

    protected FieldMap collectFields(Class clazz, FieldMap fieldMap) {
        Field[] fieldArray;
        for (Field field : fieldArray = this.getDeclaredFields(clazz)) {
            if (!this.isWanted(field) || fieldMap.fieldForName(field.getName()) != null) continue;
            fieldMap.add(this.makeFieldDescr(field));
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            this.collectFields(clazz2, fieldMap);
        }
        return fieldMap;
    }

    protected FieldDescr makeFieldDescr(Field field) {
        return new FieldDescr(this, field);
    }

    protected Field[] getDeclaredFields(Class clazz) {
        if (clazz == Object.class) {
            return new Field[0];
        }
        try {
            return clazz.getDeclaredFields();
        }
        catch (SecurityException securityException) {
            Debug.forceln("Problem getting fields of " + clazz);
            Debug.noteException(securityException, false);
            return new Field[0];
        }
    }

    protected boolean isWanted(Field field) {
        int n = field.getModifiers();
        return !Modifier.isFinal(n) && !Modifier.isStatic(n) && !Modifier.isTransient(n);
    }

    public void describeClass(Class clazz) {
        this.describeClass(clazz, System.out);
    }

    public void describeClass(Class clazz, PrintStream printStream) {
        ClassDescr classDescr = this.getClassDescr(clazz);
        List<FieldDescr> list = classDescr.getFieldDescrs();
        printStream.println(classDescr.toString());
        printStream.println("Java name: " + classDescr.theClass.getName());
        printStream.println("External name: " + classDescr.getExternalName());
        printStream.println(list.isEmpty() ? "No fields" : "Fields:");
        for (FieldDescr fieldDescr : list) {
            printStream.println(fieldDescr.getName() + ": " + fieldDescr.getTypeDescr());
            printStream.println("   getter: " + fieldDescr.getter);
            printStream.println("   setter: " + fieldDescr.setter);
        }
    }

    public static void main(String[] stringArray) {
        ClassSyntax classSyntax = new ClassSyntax();
        String string;
        while (!(string = Util.askLine("Class name:")).equals("bye")) {
            Class clazz = classSyntax.classFinder.classForName(string);
            System.out.println(clazz);
            if (clazz == null) continue;
            classSyntax.describeClass(clazz, System.out);
            System.out.println("");
        }
        return;
    }
}

