/*
 * Decompiled with CFR 0.152.
 */
package ix.util.reflect;

import ix.util.Util;
import ix.util.reflect.ClassDescr;
import ix.util.reflect.ClassSyntax;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldDescr {
    protected String name;
    protected String externalName;
    protected Class type;
    protected Type genericType;
    protected ClassDescr typeDescr;
    protected Annotation[] annotations;
    protected Method getter;
    protected Method setter;

    FieldDescr(ClassSyntax classSyntax, Field field) {
        this.name = field.getName();
        this.externalName = classSyntax.externalNameForField(field.getName());
        this.type = field.getType();
        this.genericType = field.getGenericType();
        this.annotations = field.getAnnotations();
    }

    public String getName() {
        return this.name;
    }

    public String getExternalName() {
        return this.externalName;
    }

    public void renameTo(String string, String string2) {
        this.name = string;
        this.externalName = string2;
    }

    public Class getType() {
        return this.type;
    }

    public Class determineElementType() {
        if (!(this.genericType instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)this.genericType;
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        if (typeArray.length == 1 && typeArray[0] instanceof Class) {
            return (Class)typeArray[0];
        }
        return null;
    }

    public ClassDescr getTypeDescr() {
        return this.typeDescr;
    }

    public Object getValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.getter.invoke(object, new Object[0]);
    }

    public void setValue(Object object, Object object2) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.setter.invoke(object, object2);
    }

    public void checkValue(Object object) {
        if (!this.typeDescr.valueIsOk(object)) {
            throw new ClassCastException(Util.aClass(object.getClass()) + " cannot be used in " + this.genericType + " field " + this.name);
        }
    }

    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        if (this.annotations != null) {
            for (Annotation annotation : this.annotations) {
                if (!clazz.isInstance(annotation)) continue;
                return (A)annotation;
            }
        }
        return null;
    }

    public String toString() {
        return "FieldDescr[" + this.type.getName() + " " + this.name + "]";
    }
}

