/*
 * Decompiled with CFR 0.152.
 */
package ix.util.reflect;

import ix.util.Predicate1;
import ix.util.reflect.ClassSyntax;
import ix.util.reflect.FieldDescr;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldMap {
    protected Map<String, FieldDescr> javaNameToField = new HashMap<String, FieldDescr>();
    protected Map<String, FieldDescr> externalNameToField = new HashMap<String, FieldDescr>();
    protected List<FieldDescr> fields = new LinkedList<FieldDescr>();

    public void add(FieldDescr fieldDescr) {
        this.javaNameToField.put(fieldDescr.getName(), fieldDescr);
        this.externalNameToField.put(fieldDescr.getExternalName(), fieldDescr);
        this.fields.add(fieldDescr);
    }

    public void remove(FieldDescr fieldDescr) {
        this.javaNameToField.remove(fieldDescr.getName());
        this.externalNameToField.remove(fieldDescr.getExternalName());
        this.fields.remove(fieldDescr);
    }

    public void rename(String string, String string2, ClassSyntax classSyntax) {
        FieldDescr fieldDescr = this.fieldForName(string);
        this.remove(fieldDescr);
        fieldDescr.renameTo(string2, classSyntax.externalNameForField(string2));
        this.add(fieldDescr);
    }

    FieldDescr fieldForName(String string) {
        return this.javaNameToField.get(string);
    }

    FieldDescr fieldForExternalName(String string) {
        return this.externalNameToField.get(string);
    }

    List<FieldDescr> getFields() {
        return this.fields;
    }

    void removeIf(Predicate1<FieldDescr> predicate1) {
        ListIterator<FieldDescr> listIterator = this.fields.listIterator();
        while (listIterator.hasNext()) {
            FieldDescr fieldDescr = listIterator.next();
            if (!predicate1.trueOf(fieldDescr)) continue;
            listIterator.remove();
            this.javaNameToField.remove(fieldDescr.getName());
            this.externalNameToField.remove(fieldDescr.getExternalName());
        }
    }
}

