/*
 * Decompiled with CFR 0.152.
 */
package ix.util.reflect;

import ix.util.MultiHashMap;
import ix.util.MultiMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InheritanceTree {
    Map classToSuperclass = new HashMap();
    MultiMap classToSubclasses = new MultiHashMap();
    List relevantClasses;

    public InheritanceTree(List list) {
        this.relevantClasses = list;
        this.assignRelevantSuperclasses(list);
    }

    public Class getSuperclass(Class clazz) {
        return (Class)this.classToSuperclass.get(clazz);
    }

    public List<Class> getSubclasses(Class clazz) {
        return (List)this.classToSubclasses.get(clazz);
    }

    public void clear() {
        this.relevantClasses = null;
        this.classToSuperclass.clear();
        this.classToSubclasses.clear();
    }

    protected void assignRelevantSuperclasses(List list) {
        HashSet hashSet = new HashSet(list);
        for (Class clazz : list) {
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 == null || !hashSet.contains(clazz2)) continue;
            this.addSubclass(clazz2, clazz);
        }
    }

    protected void addSubclass(Class clazz, Class clazz2) {
        this.classToSubclasses.addValue(clazz, clazz2);
        this.classToSuperclass.put(clazz2, clazz);
    }

    public String toString() {
        return "InheritanceTree[classToSuperclass=" + this.classToSuperclass + "]";
    }
}

