/*
 * Decompiled with CFR 0.152.
 */
package ix.util.xml;

import ix.icore.domain.Constraint;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Strings;
import ix.util.Util;
import ix.util.reflect.ClassDescr;
import ix.util.reflect.ClassFinder;
import ix.util.reflect.ClassSyntax;
import ix.util.reflect.FieldDescr;
import ix.util.reflect.InheritanceTree;
import ix.util.xml.XML;
import ix.util.xml.XMLSyntax;
import ix.util.xml.XMLTranslator;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class BNFSyntax
extends XMLSyntax {
    protected XMLTranslator noNamespaceXmlt = XML.config().makeXMLTranslator();

    public BNFSyntax() {
        this.noNamespaceXmlt.homeNamespace = null;
    }

    public BNFSyntax(XMLTranslator xMLTranslator) {
        super(xMLTranslator);
        this.noNamespaceXmlt.homeNamespace = null;
    }

    public void describeClass(String string, PrintStream printStream) {
        Class clazz = this.classSyntax.classForExternalName(string);
        if (clazz == null) {
            printStream.println("Can't find class named " + string);
            return;
        }
        printStream.println("Syntax for " + string + " and related classes:");
        printStream.println("");
        List list = this.relevantClasses(clazz);
        this.inheritance = new InheritanceTree(list);
        this.printRuleSyntax(new RuleList(list), printStream);
    }

    void printRuleSyntax(RuleList ruleList, PrintStream printStream) {
        for (Rule rule : ruleList.getRules()) {
            this.printRuleSyntax(rule, printStream);
            printStream.println("");
        }
    }

    void printRuleSyntax(Rule rule, PrintStream printStream) {
        printStream.print(rule.nonterminal + " ::=");
        if (rule.rhs instanceof Alternatives) {
            this.printAlternatives((Alternatives)rule.rhs, printStream);
        } else {
            this.printInstance((Instance)rule.rhs, printStream);
        }
    }

    void printAlternatives(Alternatives alternatives, PrintStream printStream) {
        int n = 1;
        for (Instance instance : alternatives.alts) {
            String string = n == 1 ? " " : " | ";
            printStream.print(string);
            printStream.print(instance.asValue());
            ++n;
        }
        printStream.println("");
    }

    void printInstance(Instance instance, PrintStream printStream) {
        printStream.println("");
        this.printIndented(printStream, 3, instance.asElement());
    }

    void printIndented(PrintStream printStream, int n, String string) {
        List<String> list = Strings.breakIntoLines(string);
        for (String string2 : list) {
            printStream.print(Strings.repeat(n, " "));
            printStream.println(string2);
        }
    }

    Instance makeClassInstance(ClassDescr classDescr) {
        if (classDescr.isPrimitive()) {
            return new SimpleInstance(classDescr);
        }
        if (classDescr.isStruct()) {
            return new StructInstance(classDescr);
        }
        if (classDescr.isList()) {
            return new ListInstance(classDescr);
        }
        if (classDescr.isSet()) {
            return new SetInstance(classDescr);
        }
        if (classDescr.isMap()) {
            return new MapInstance(classDescr);
        }
        if (classDescr.isInterface()) {
            return new SimpleInstance(classDescr);
        }
        throw new ConsistencyException("Can't handle syntax of " + classDescr);
    }

    String tagged(String string, String string2) {
        return "<" + string + ">" + string2 + "</" + string + ">";
    }

    public static void main(String[] stringArray) {
        BNFSyntax bNFSyntax = stringArray.length > 0 && stringArray[0].equals("java") ? new BNFSyntax(new XMLTranslator(new ClassSyntax(new ClassFinder(XML.config().defaultClassFinder())))) : new BNFSyntax();
        XML.config().defaultClassFinder().preLoad(new XMLSyntax().relevantClasses(Object.class));
        String string;
        while (!(string = Util.askLine("Class name:")).equals("bye")) {
            bNFSyntax.describeClass(string, System.out);
            System.out.println("");
        }
        return;
    }

    class MapEntryInstance
    extends TemplateInstance {
        MapEntryInstance() {
            this.template = this.mapEntryTemplate();
        }

        Element mapEntryTemplate() {
            String string = BNFSyntax.this.getNTName(Object.class);
            return new Element("map-entry").addContent((Content)new Element("key").addContent((Content)new Text(string))).addContent((Content)new Element("value").addContent((Content)new Text(string)));
        }
    }

    class MapInstance
    extends CollectionInstance {
        MapInstance(ClassDescr classDescr) {
            super(classDescr);
        }

        String asElement() {
            return BNFSyntax.this.tagged(BNFSyntax.this.getElementName(Map.class), "MAP-ENTRY...");
        }
    }

    class SetInstance
    extends CollectionInstance {
        SetInstance(ClassDescr classDescr) {
            super(classDescr);
        }
    }

    class ListInstance
    extends CollectionInstance {
        ListInstance(ClassDescr classDescr) {
            super(classDescr);
        }
    }

    abstract class CollectionInstance
    extends Instance {
        ClassDescr cd;

        CollectionInstance(ClassDescr classDescr) {
            this.cd = classDescr;
        }

        String asValue() {
            return this.asElement();
        }

        String asElement() {
            Class<List> clazz;
            Class clazz2 = this.cd.isList() ? List.class : (clazz = this.cd.isSet() ? Set.class : null);
            if (clazz == null) {
                throw new ConsistencyException("Unknown collection type " + this.cd);
            }
            ClassDescr classDescr = this.cd.getEltType();
            return BNFSyntax.this.tagged(BNFSyntax.this.getElementName(clazz), classDescr == null ? "..." : BNFSyntax.this.getNTName(classDescr) + "...");
        }
    }

    class ConstraintTemplate
    extends TemplateInstance {
        ConstraintTemplate(Constraint constraint) {
            this.template = this.constraintTemplate(constraint);
        }

        Element constraintTemplate(Constraint constraint) {
            Object object;
            ClassDescr classDescr = BNFSyntax.this.getClassDescr(Constraint.class);
            FieldDescr fieldDescr = classDescr.fieldForName("parameters");
            FieldDescr fieldDescr2 = classDescr.fieldForName("annotations");
            String string = BNFSyntax.this.getElementName(fieldDescr);
            String string2 = BNFSyntax.this.getElementName(fieldDescr2);
            String string3 = BNFSyntax.this.getElementName(Constraint.class);
            String string4 = BNFSyntax.this.getElementName(List.class);
            String string5 = BNFSyntax.this.getElementName(Map.class);
            LinkedList<Text> linkedList = new LinkedList<Text>();
            Element element = constraint.getParameters().iterator();
            while (element.hasNext()) {
                object = element.next();
                Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
                ClassDescr classDescr2 = BNFSyntax.this.getClassDescr(clazz);
                linkedList.add(new Text(BNFSyntax.this.getNTName(classDescr2)));
                if (!element.hasNext()) continue;
                linkedList.add(new Text(" "));
            }
            element = new Element(string3).setAttribute("type", constraint.getType().toString()).addContent((Content)new Element(string).addContent((Content)new Element(string4).setContent(linkedList)));
            if (constraint.getRelation() != null) {
                element.setAttribute("relation", constraint.getRelation().toString());
            }
            if (constraint.getAnnotations() != null) {
                object = BNFSyntax.this.noNamespaceXmlt.objectToElement(constraint.getAnnotations());
                element.addContent((Content)new Element(string2).addContent(object));
            }
            return element;
        }
    }

    abstract class TemplateInstance
    extends Instance {
        Element template;

        TemplateInstance() {
        }

        TemplateInstance(Element element) {
            this.template = element;
        }

        String asElement() {
            XMLOutputter xMLOutputter = XML.makePrettyXMLOutputter();
            Format format = xMLOutputter.getFormat();
            format.setOmitDeclaration(true);
            format.setIndent("   ");
            xMLOutputter.setFormat(format);
            return xMLOutputter.outputString(this.template);
        }
    }

    class InstanceField {
        FieldDescr fd;
        boolean isAttribute;

        InstanceField(FieldDescr fieldDescr) {
            this.fd = fieldDescr;
            this.isAttribute = BNFSyntax.this.xmlt.isAttributeClass(fieldDescr.getType());
        }

        String description() {
            ClassDescr classDescr = this.fd.getTypeDescr();
            Instance instance = BNFSyntax.this.makeClassInstance(classDescr);
            String string = BNFSyntax.this.getElementName(this.fd);
            String string2 = instance.asValue();
            if (this.isAttribute) {
                return this.fd.getExternalName() + "=" + Strings.quote(string2);
            }
            String string3 = BNFSyntax.this.tagged(string, string2);
            if (string3.length() <= 75) {
                return string3;
            }
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add("<" + string + ">");
            linkedList.add("      " + string2);
            linkedList.add("   </" + string + ">");
            return Strings.joinLines(linkedList);
        }
    }

    class StructInstance
    extends Instance {
        ClassDescr cd;

        StructInstance(ClassDescr classDescr) {
            this.cd = classDescr;
        }

        String asValue() {
            return BNFSyntax.this.getNTName(this.cd);
        }

        String asElement() {
            String string;
            List<FieldDescr> list = this.cd.getFieldDescrs();
            List list2 = BNFSyntax.this.attributeFields(list);
            List list3 = BNFSyntax.this.elementFields(list);
            Debug.expect(list.size() == list2.size() + list3.size());
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add("<" + BNFSyntax.this.getElementName(this.cd));
            for (FieldDescr fieldDescr : list2) {
                string = "      " + new InstanceField(fieldDescr).description();
                linkedList.add(string);
            }
            linkedList.add(linkedList.remove(linkedList.size() - 1) + ">");
            for (FieldDescr fieldDescr : list3) {
                string = "   " + new InstanceField(fieldDescr).description();
                linkedList.add(string);
            }
            linkedList.add("</" + BNFSyntax.this.getElementName(this.cd) + ">");
            return Strings.joinLines(linkedList);
        }
    }

    class SimpleInstance
    extends Instance {
        ClassDescr cd;

        SimpleInstance(ClassDescr classDescr) {
            this.cd = classDescr;
        }

        String asValue() {
            return BNFSyntax.this.getNTName(this.cd);
        }

        String asElement() {
            return BNFSyntax.this.tagged(BNFSyntax.this.getElementName(this.cd), BNFSyntax.this.getNTName(this.cd));
        }
    }

    class Literal
    extends Instance {
        String value;

        Literal(String string) {
            this.value = string;
        }

        String asValue() {
            return this.value;
        }
    }

    class Nonterminal
    extends Instance {
        String name;

        Nonterminal(ClassDescr classDescr) {
            this(bNFSyntax.getNTName(classDescr));
        }

        Nonterminal(String string) {
            this.name = string;
        }

        String asValue() {
            return this.name;
        }
    }

    abstract class Instance
    extends RHS {
        Instance() {
        }

        String asValue() {
            throw new ConsistencyException("Can't express " + this + " as a value");
        }

        String asElement() {
            throw new ConsistencyException("Can't express " + this + " as an element");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Alternatives
    extends RHS {
        private List<Instance> alts;

        Alternatives(Instance instance) {
            this.alts = Collections.singletonList(instance);
        }

        Alternatives(List<Instance> list) {
            this.alts = list;
        }

        List<Instance> getAlts() {
            return this.alts;
        }
    }

    class Rule {
        String nonterminal;
        RHS rhs;

        Rule(String string, RHS rHS) {
            this.nonterminal = string;
            this.rhs = rHS;
        }

        Rule(ClassDescr classDescr) {
            this.nonterminal = BNFSyntax.this.getNTName(classDescr);
            this.rhs = this.makeRHS(classDescr);
        }

        RHS makeRHS(ClassDescr classDescr) {
            if (classDescr.isEnumeration()) {
                List list = BNFSyntax.this.getEnumerationValues(classDescr.theClass);
                LinkedList<Instance> linkedList = new LinkedList<Instance>();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    linkedList.add(new Literal(iterator.next().toString()));
                }
                return new Alternatives(linkedList);
            }
            return BNFSyntax.this.makeClassInstance(classDescr);
        }
    }

    abstract class RHS {
        RHS() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RuleList {
        List<Rule> rules = new LinkedList<Rule>();
        boolean hasMapEntryRule = false;

        RuleList(List list) {
            for (Class clazz : list) {
                ClassDescr classDescr = BNFSyntax.this.getClassDescr(clazz);
                if (classDescr.isEnumeration() || classDescr.isStruct()) {
                    this.addRule(classDescr);
                }
                if (classDescr.theClass == Constraint.class) {
                    this.addConstraintRules();
                }
                if (!this.needMapEntryRule(classDescr)) continue;
                this.addMapEntryRule();
            }
        }

        List<Rule> getRules() {
            return this.rules;
        }

        void addRule(Rule rule) {
            this.rules.add(rule);
        }

        void addRule(ClassDescr classDescr) {
            if (!classDescr.isAbstract()) {
                this.addRule(new Rule(classDescr));
            }
            this.addInheritanceRule(classDescr);
        }

        void addInheritanceRule(ClassDescr classDescr) {
            List<Class> list = BNFSyntax.this.inheritance.getSubclasses(classDescr.theClass);
            if (list == null || list.isEmpty()) {
                return;
            }
            LinkedList<Instance> linkedList = new LinkedList<Instance>();
            for (Class clazz : list) {
                ClassDescr classDescr2 = BNFSyntax.this.getClassDescr(clazz);
                linkedList.add(new Nonterminal(classDescr2));
            }
            this.addRule(new Rule(BNFSyntax.this.getNTName(classDescr), new Alternatives(linkedList)));
        }

        void addConstraintRules() {
            String string = BNFSyntax.this.getNTName(Constraint.class);
            List list = BNFSyntax.this.getConstraintSyntaxList();
            if (list.isEmpty()) {
                return;
            }
            Nonterminal nonterminal = new Nonterminal("KNOWN-CONSTRAINT");
            this.addRule(new Rule(string, new Alternatives(nonterminal)));
            for (Constraint constraint : list) {
                this.addRule(new Rule("KNOWN-CONSTRAINT", new ConstraintTemplate(constraint)));
            }
        }

        boolean needMapEntryRule(ClassDescr classDescr) {
            if (this.hasMapEntryRule) {
                return false;
            }
            if (classDescr.isMap()) {
                return true;
            }
            if (classDescr.isStruct()) {
                List<FieldDescr> list = classDescr.getFieldDescrs();
                for (FieldDescr fieldDescr : list) {
                    if (!fieldDescr.getTypeDescr().isMap()) continue;
                    return true;
                }
                return false;
            }
            return false;
        }

        void addMapEntryRule() {
            this.addRule(new Rule("MAP-ENTRY", new MapEntryInstance()));
            this.hasMapEntryRule = true;
        }
    }
}

