/*
 * Decompiled with CFR 0.152.
 */
package ix.util.xml;

import ix.util.reflect.Body;
import ix.util.reflect.ClassDescr;
import ix.util.reflect.ClassSyntax;
import ix.util.reflect.FieldDescr;
import ix.util.reflect.Stringer;
import ix.util.xml.XMLException;
import ix.util.xml.XMLTranslator;
import java.util.Collection;
import java.util.Iterator;
import org.jdom.Content;
import org.jdom.Element;

public class CompactXMLTranslator
extends XMLTranslator {
    public CompactXMLTranslator() {
    }

    public CompactXMLTranslator(ClassSyntax classSyntax) {
        super(classSyntax);
    }

    protected Element structToElement(Object object) {
        Class<?> clazz = object.getClass();
        ClassDescr classDescr = this.classSyntax.getClassDescr(clazz);
        this.checkBodyUsage(classDescr);
        String string = classDescr.getExternalName();
        Element element = this.nsElement(string);
        for (FieldDescr fieldDescr : classDescr.getFieldDescrs()) {
            this.visitField(object, fieldDescr, element);
        }
        return element;
    }

    protected FieldDescr checkBodyUsage(ClassDescr classDescr) {
        boolean bl = false;
        FieldDescr fieldDescr = null;
        for (FieldDescr fieldDescr2 : classDescr.getFieldDescrs()) {
            if (this.isAttributeClass(fieldDescr2.getType())) continue;
            if (this.isBodyField(fieldDescr2)) {
                if (bl) {
                    throw new XMLException(classDescr.getName() + " needs elements for non-body fields");
                }
                if (fieldDescr == null) {
                    fieldDescr = fieldDescr2;
                    continue;
                }
                throw new XMLException(classDescr.getName() + " has at least two body fields, " + fieldDescr.getName() + " and " + fieldDescr2.getName());
            }
            if (fieldDescr != null) {
                throw new XMLException(classDescr.getName() + " needs elements for non-body fields");
            }
            bl = true;
        }
        if (fieldDescr == null) {
            return null;
        }
        ClassDescr classDescr2 = fieldDescr.getTypeDescr();
        if (!classDescr2.isCollection()) {
            throw new XMLException("Body field " + fieldDescr.getName() + " in " + classDescr.getName() + " is not a collection.");
        }
        return fieldDescr;
    }

    protected boolean isBodyField(FieldDescr fieldDescr) {
        return fieldDescr.getAnnotation(Body.class) != null;
    }

    protected boolean fieldElementSuffices(FieldDescr fieldDescr) {
        ClassDescr classDescr = fieldDescr.getTypeDescr();
        return classDescr.isFinal() || classDescr.isCollection() && classDescr.getEltType() != null;
    }

    protected void visitField(Object object, FieldDescr fieldDescr, Element element) {
        Object object2 = this.getFieldValue(object, fieldDescr);
        if (object2 == null) {
            return;
        }
        String string = fieldDescr.getExternalName();
        Class clazz = fieldDescr.getType();
        if (this.isAttributeClass(clazz)) {
            Stringer<Object> stringer = this.classSyntax.getStringer(clazz);
            String string2 = stringer != null ? stringer.toString(object2) : object2.toString();
            element.setAttribute(string, string2);
        } else if (this.isBodyField(fieldDescr)) {
            for (Object e : (Collection)object2) {
                element.addContent((Content)this.objectToElement(e));
            }
        } else {
            Element element2 = this.objectToElement(object2);
            if (this.fieldElementSuffices(fieldDescr)) {
                element2.setName(string);
                element.addContent((Content)element2);
            } else {
                Element element3 = this.nsElement(string);
                element.addContent((Content)element3);
                element3.addContent((Content)element2);
            }
        }
    }

    protected Object structFromElement(Class clazz, Element element) {
        Object object = this.makeInstance(clazz);
        ClassDescr classDescr = this.classSyntax.getClassDescr(clazz);
        this.processStructAttributes(object, classDescr, element);
        FieldDescr fieldDescr = this.checkBodyUsage(classDescr);
        if (fieldDescr != null) {
            ClassDescr classDescr2 = fieldDescr.getTypeDescr();
            Class clazz2 = classDescr2.isList() ? this.defaultListClass : this.defaultSetClass;
            Class clazz3 = this.getImplClass(null, classDescr2.theClass, clazz2);
            Collection collection = this.collectionFromElement(clazz3, element);
            this.setFieldValue(object, fieldDescr, collection);
            return object;
        }
        this.processStructSubelements(object, classDescr, element);
        return object;
    }

    protected void processStructSubelements(Object object, ClassDescr classDescr, Element element) {
        Iterator iterator = element.getChildren().iterator();
        while (iterator.hasNext()) {
            Element element2;
            this.lastExaminedElement = element2 = (Element)iterator.next();
            String string = element2.getName();
            FieldDescr fieldDescr = classDescr.fieldForExternalName(string);
            if (fieldDescr == null) {
                this.handleUnknownFieldFromElement(object, string, element2);
                continue;
            }
            Object object2 = null;
            if (this.fieldElementSuffices(fieldDescr)) {
                object2 = this.objectFromElement(fieldDescr.getType(), element2);
            } else {
                this.requireEltSize(1, element2);
                object2 = this.getFieldValue(element2, fieldDescr);
            }
            this.setFieldValue(object, fieldDescr, object2);
        }
    }
}

