/*
 * Decompiled with CFR 0.152.
 */
package ix.util.xml;

import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.RethrownException;
import ix.util.Strings;
import ix.util.Warning;
import ix.util.xml.FileSyntax;
import ix.util.xml.XML;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

public class FileSyntaxManager {
    protected List syntaxes = new LinkedList();
    protected FileSyntax defaultSyntax = null;

    public FileSyntaxManager() {
        this.addSyntaxes();
    }

    protected void addSyntaxes() {
        FileSyntax.XMLFiles xMLFiles = new FileSyntax.XMLFiles();
        this.addSyntax(xMLFiles);
        this.addSyntax(new FileSyntax.RDFFiles());
        this.setDefault(xMLFiles);
    }

    public List getAllSyntaxes() {
        return Collections.unmodifiableList(this.syntaxes);
    }

    public void addSyntax(FileSyntax fileSyntax) {
        this.syntaxes.add(fileSyntax);
    }

    public void setDefault(FileSyntax fileSyntax) {
        this.defaultSyntax = fileSyntax;
    }

    public FileSyntax getSyntax(String string) {
        return this.getSyntaxForType(this.getType(string));
    }

    public FileSyntax getSyntax(File file) {
        return this.getSyntax(file.getName());
    }

    public FileSyntax getSyntax(URL uRL) {
        return this.getSyntax(uRL.getFile());
    }

    public String getType(String string) {
        int n = string.lastIndexOf(46);
        String string2 = n < 0 ? "" : string.substring(n + 1);
        return string2;
    }

    public String getExceptType(String string) {
        int n = string.lastIndexOf(46);
        return n < 0 ? string : string.substring(0, n);
    }

    public FileSyntax getSyntaxForType(String string) {
        string = string.toLowerCase();
        for (FileSyntax fileSyntax : this.syntaxes) {
            if (!fileSyntax.getFileTypes().contains(string)) continue;
            return fileSyntax;
        }
        return this.defaultSyntax;
    }

    public Set getInputTypesForClass(Class clazz) {
        TreeSet treeSet = new TreeSet();
        for (FileSyntax fileSyntax : this.getAllSyntaxes()) {
            if (!this.canRead(fileSyntax, clazz)) continue;
            treeSet.addAll(fileSyntax.getFileTypes());
        }
        return treeSet;
    }

    public Set getOutputTypesForClass(Class clazz) {
        TreeSet treeSet = new TreeSet();
        for (FileSyntax fileSyntax : this.getAllSyntaxes()) {
            if (!this.canWrite(fileSyntax, clazz)) continue;
            treeSet.addAll(fileSyntax.getFileTypes());
        }
        return treeSet;
    }

    public boolean canRead(FileSyntax fileSyntax, Class clazz) {
        return fileSyntax.isAvailable() && fileSyntax.canRead() && this.allowsClass(clazz, fileSyntax.readableClasses());
    }

    public boolean canWrite(FileSyntax fileSyntax, Class clazz) {
        return fileSyntax.isAvailable() && fileSyntax.canWrite() && this.allowsClass(clazz, fileSyntax.writableClasses());
    }

    private boolean allowsClass(Class clazz, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.areDisjoint(clazz, (Class)iterator.next())) continue;
            return true;
        }
        return false;
    }

    private boolean areDisjoint(Class clazz, Class clazz2) {
        return !clazz.isAssignableFrom(clazz2) && !clazz2.isAssignableFrom(clazz);
    }

    public void addAboutInfo(List list) {
        if (this.syntaxes.isEmpty()) {
            return;
        }
        list.add("");
        list.add("File syntaxes:");
        for (FileSyntax fileSyntax : this.syntaxes) {
            list.add("   " + fileSyntax.getFileTypeDescription() + " " + fileSyntax.getFileTypes());
            if (!fileSyntax.isAvailable()) {
                list.add("      Not available in this agent");
            }
            if (!fileSyntax.canRead()) {
                list.add("      Output only");
            }
            if (!fileSyntax.canWrite()) {
                list.add("      Input only");
            }
            if (fileSyntax.canRead()) {
                list.addAll(this.aboutRestriction("Input", fileSyntax.readableClasses()));
            }
            if (!fileSyntax.canWrite()) continue;
            list.addAll(this.aboutRestriction("Output", fileSyntax.writableClasses()));
        }
    }

    private List aboutRestriction(String string, List list) {
        if (list.size() == 1 && list.get(0) == Object.class) {
            return Collections.EMPTY_LIST;
        }
        String string2 = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            String string3 = XML.nameForClass(clazz);
            string2 = string2.equals("") ? string3 : (iterator.hasNext() ? string2 + ", " + string3 : string2 + " or " + string3);
        }
        return Collections.singletonList("      " + string + " must be " + Strings.indefinite(string2));
    }

    public Object readObject(Class clazz, String string) {
        URL uRL = this.toURL(string);
        if (uRL == null) {
            throw new IllegalArgumentException("Can't find " + this.aClass(clazz) + " resource named " + Strings.quote(string));
        }
        return this.readObject(clazz, uRL);
    }

    public Object readObject(Class clazz, URL uRL) {
        FileSyntax fileSyntax = this.getSyntax(uRL);
        this.checkSyntax(fileSyntax, clazz, "input");
        try {
            Object object = fileSyntax.readObject(uRL);
            if (object == null) {
                throw new NullPointerException("null " + XML.nameForClass(clazz));
            }
            if (!clazz.isInstance(object)) {
                throw new ClassCastException("Required " + this.aClass(clazz) + " but found " + this.aClass(object.getClass()));
            }
            return object;
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            throw new RethrownException(exception, "Cannot read " + this.aClass(clazz) + " from " + Strings.quote(uRL.toString()) + ": " + Debug.describeException(exception));
        }
    }

    private String aClass(Class clazz) {
        return Strings.indefinite(XML.nameForClass(clazz));
    }

    public SortedMap readAllObjects(Class clazz, String string) {
        File[] fileArray = this.getFiles(clazz, string);
        TreeMap<File, Object> treeMap = new TreeMap<File, Object>();
        for (int i = 0; i < fileArray.length; ++i) {
            Object object = this.readObject(clazz, fileArray[i].getPath());
            treeMap.put(fileArray[i], object);
        }
        return treeMap;
    }

    public File[] getFiles(Class clazz, String string) {
        File file = new File(string);
        final Set set = this.getInputTypesForClass(clazz);
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                String string = file.getName();
                String string2 = Strings.afterLast(".", string);
                return string2 != string && set.contains(string2.toLowerCase());
            }
        });
        if (fileArray == null) {
            throw new IllegalArgumentException(string + " does not name a directory");
        }
        if (fileArray.length == 0) {
            throw new Warning(string + " does not contain suitable files");
        }
        return fileArray;
    }

    public void writeObject(Object object, String string) {
        FileSyntax fileSyntax = this.getSyntax(string);
        this.checkSyntax(fileSyntax, object.getClass(), "output");
        try {
            fileSyntax.writeObject(object, new File(string));
        }
        catch (IOException iOException) {
            Debug.noteException(iOException);
            throw new RethrownException(iOException, "Cannot write to " + Strings.quote(string) + ": " + Debug.describeException(iOException));
        }
    }

    protected void checkSyntax(FileSyntax fileSyntax, Class clazz, String string) {
        Debug.noteln("Checking syntax " + fileSyntax + " for " + clazz.getName() + " " + string);
        if (!fileSyntax.isAvailable()) {
            throw new UnsupportedOperationException("The file syntax for " + fileSyntax.getFileTypeDescription() + " is not available in this agent.");
        }
        if (string.equals("input")) {
            if (this.canRead(fileSyntax, clazz)) {
                return;
            }
        } else if (string.equals("output")) {
            if (this.canWrite(fileSyntax, clazz)) {
                return;
            }
        } else {
            throw new ConsistencyException("Unknown direction", string);
        }
        throw new UnsupportedOperationException("The file syntax for " + fileSyntax.getFileTypeDescription() + " cannot " + string + " " + this.aClass(clazz) + ".");
    }

    public URL toURL(String string) {
        String string2 = string;
        try {
            return new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            block8: {
                try {
                    File file = new File(string2);
                    if (file.exists()) {
                        return file.toURL();
                    }
                }
                catch (MalformedURLException malformedURLException2) {
                    Debug.expect(false, "Can't convert file to URL", string2);
                }
                catch (AccessControlException accessControlException) {
                    if (Parameters.isApplet()) {
                        if (Debug.isOn()) {
                            Debug.noteException(accessControlException, false);
                        }
                        break block8;
                    }
                    Debug.displayException("Can't see if file " + string2 + " exists", accessControlException);
                }
            }
            return this.getClass().getClassLoader().getResource(string2);
        }
    }

    public URL requireURL(String string) {
        URL uRL = this.toURL(string);
        if (uRL == null) {
            throw new IllegalArgumentException("Can't find a resource named " + Strings.quote(string));
        }
        return uRL;
    }
}

