/*
 * Decompiled with CFR 0.152.
 */
package ix.util.xml;

import ix.util.Collect;
import ix.util.Debug;
import ix.util.Fn;
import ix.util.Function1;
import ix.util.Name;
import ix.util.Parameters;
import ix.util.Strings;
import ix.util.lisp.ItemVar;
import ix.util.lisp.Symbol;
import ix.util.reflect.ClassDescr;
import ix.util.reflect.FieldDescr;
import ix.util.reflect.InheritanceTree;
import ix.util.xml.XML;
import ix.util.xml.XMLSyntax;
import ix.util.xml.XMLTranslator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;

public class XMLSchemaSyntax
extends XMLSyntax {
    Schema theSchema = null;
    public static final Namespace schemaNamespace = Namespace.getNamespace((String)"xsd", (String)"http://www.w3.org/2001/XMLSchema");
    static Object[][] simpleTypeTable = new Object[][]{{String.class, "string"}, {Symbol.class, "string"}, {ItemVar.class, "string"}, {Name.class, "string"}, {Byte.class, null}, {Character.class, null}, {Short.class, "short"}, {Integer.class, "int"}, {Long.class, "long"}, {Float.class, "float"}, {Double.class, "double"}, {Boolean.class, null}};

    public XMLSchemaSyntax() {
    }

    public XMLSchemaSyntax(XMLTranslator xMLTranslator) {
        super(xMLTranslator);
    }

    public Schema makeSchema(Class clazz) {
        return this.makeSchema(clazz, XML.config().xmlSyntaxClasses(this.classSyntax, clazz));
    }

    Schema makeSchema(Class clazz, List list) {
        Schema schema;
        this.theSchema = schema = new Schema(clazz, new String[][]{{"targetNamespace", this.xmlt.getHomeNamespace().getURI()}, {"elementFormDefault", "qualified"}});
        this.inheritance = new InheritanceTree(list);
        this.collectListofClasses(list, schema.getListofClasses());
        this.addRootSyntax(schema);
        this.addFrameworkDeclarations(schema, List.class);
        schema.addContent((Content)this.makeListType());
        this.addFrameworkDeclarations(schema, Map.class);
        schema.addContent((Content)this.makeMapType());
        for (Class clazz2 : list) {
            this.addClassSyntax(schema, clazz2);
        }
        return schema;
    }

    void addRootSyntax(Schema schema) {
        Element element = this.makeXsdElement("element", new String[][]{{"name", "OBJECT"}, {"abstract", "true"}});
        schema.addContent((Content)new Comment("Prelude"));
        schema.addContent((Content)element);
        schema.addContent((Content)this.makeClassAsElementType(this.getClassDescr(Object.class)));
    }

    void addClassSyntax(Schema schema, Class clazz) {
        ClassDescr classDescr = this.getClassDescr(clazz);
        schema.addContent((Content)new Comment(classDescr.getExternalName()));
        if (classDescr.isStruct()) {
            this.addStructSyntax(schema, clazz);
        } else if (classDescr.isEnumeration()) {
            this.addEnumerationSyntax(schema, clazz);
        } else if (classDescr.isPrimitive()) {
            this.addPrimitiveSyntax(schema, clazz);
        } else if (classDescr.isXML()) {
            this.addLiteralDocumentSyntax(schema, clazz);
        } else {
            schema.addContent((Content)new Comment("No syntax for " + clazz));
        }
        if (schema.getListofClasses().contains(clazz)) {
            schema.addContent((Content)this.makeListofClassAsElementType(clazz));
            schema.addContent((Content)this.makeListofClassType(clazz));
        }
    }

    void addFrameworkDeclarations(Schema schema, Class clazz) {
        ClassDescr classDescr = this.getClassDescr(clazz);
        schema.addContent((Content)this.makeUpperCaseClassElement(classDescr));
        if (classDescr.isAbstract() && !classDescr.isInterface()) {
            schema.addContent((Content)new Comment("Since " + this.getElementName(classDescr) + " is abstract, " + "no " + Strings.quote(this.getElementName(classDescr)) + " element or type declaration is needed."));
        } else {
            schema.addContent((Content)this.makeLowerCaseClassElement(classDescr));
        }
        schema.addContent((Content)this.makeClassAsElementType(classDescr));
    }

    Element makeUpperCaseClassElement(ClassDescr classDescr) {
        Class clazz = this.inheritance.getSuperclass(classDescr.theClass);
        String string = clazz == null ? "OBJECT" : this.getClassDescr(clazz).getUpperName();
        return this.makeXsdElement("element", new String[][]{{"name", classDescr.getUpperName()}, {"abstract", "true"}, {"substitutionGroup", string}});
    }

    Element makeLowerCaseClassElement(ClassDescr classDescr) {
        String string = classDescr.getExternalName();
        return this.makeXsdElement("element", new String[][]{{"name", string}, {"type", string}, {"substitutionGroup", classDescr.getUpperName()}});
    }

    Element makeClassAsElementType(ClassDescr classDescr) {
        String string = this.asElementTypeName(classDescr.theClass);
        Element element = this.makeXsdElement("element").setAttribute("ref", classDescr.getUpperName());
        return this.makeXsdElement("complexType").setAttribute("name", string).addContent((Content)this.makeXsdElement("sequence").addContent((Content)element));
    }

    String asElementTypeName(Class clazz) {
        return this.getUpperName(clazz) + "-as-element";
    }

    void addStructSyntax(Schema schema, Class clazz) {
        this.addFrameworkDeclarations(schema, clazz);
        if (!this.getClassDescr(clazz).isAbstract()) {
            schema.addContent((Content)this.makeStructType(clazz));
        }
    }

    Element makeStructType(Class clazz) {
        return this.makeXsdElement("complexType").setAttribute("name", this.getElementName(clazz)).setContent((Collection)this.makeStructContents(clazz));
    }

    List makeStructContents(Class clazz) {
        ClassDescr classDescr = this.getClassDescr(clazz);
        List<FieldDescr> list = classDescr.getFieldDescrs();
        List list2 = this.attributeFields(list);
        List list3 = this.elementFields(list);
        Debug.expect(list.size() == list2.size() + list3.size());
        List list4 = this.makeStructFieldElements(list3);
        List list5 = this.makeStructAttributeElements(list2);
        Element element = this.makeXsdElement("all").setContent((Collection)list4);
        LinkedList<Element> linkedList = new LinkedList<Element>();
        linkedList.add(element);
        linkedList.addAll(list5);
        return linkedList;
    }

    List makeStructAttributeElements(List list) {
        return (List)Collect.map(list, new Function1(){

            public Object funcall(Object object) {
                return XMLSchemaSyntax.this.makeStructAttributeElement((FieldDescr)object);
            }
        });
    }

    Element makeStructAttributeElement(FieldDescr fieldDescr) {
        return this.makeXsdElement("attribute", new String[][]{{"name", fieldDescr.getExternalName()}, {"type", this.getElementName(fieldDescr.getType())}});
    }

    List makeStructFieldElements(List list) {
        return (List)Collect.map(list, new Function1(){

            public Object funcall(Object object) {
                return XMLSchemaSyntax.this.makeStructFieldElement((FieldDescr)object);
            }
        });
    }

    Element makeStructFieldElement(FieldDescr fieldDescr) {
        return this.makeXsdElement("element").setAttribute("name", fieldDescr.getExternalName()).setAttribute("type", this.getStructFieldValueType(fieldDescr)).setAttribute("minOccurs", "0");
    }

    String getStructFieldValueType(FieldDescr fieldDescr) {
        ClassDescr classDescr = fieldDescr.getTypeDescr();
        if (classDescr.isList()) {
            return this.getListValueType(classDescr);
        }
        if (classDescr.isSet()) {
            Debug.expect(false, "Can't handle Set values");
            return null;
        }
        if (classDescr.isMap()) {
            return this.getMapValueType(classDescr);
        }
        return this.getPlainValueType(classDescr);
    }

    String getPlainValueType(ClassDescr classDescr) {
        return this.asElementTypeName(classDescr.theClass);
    }

    String getListValueType(ClassDescr classDescr) {
        ClassDescr classDescr2 = classDescr.getEltType();
        if (classDescr2 == null) {
            return this.asElementTypeName(List.class);
        }
        return this.ListofClassAsElementTypeName(classDescr2.theClass);
    }

    String getMapValueType(ClassDescr classDescr) {
        return this.asElementTypeName(Map.class);
    }

    void ensureListofClassTypes(Class clazz) {
        String string = this.ListofClassTypeName(clazz);
        Element element = this.theSchema.getTypeDefinition(string);
        if (element != null) {
            return;
        }
        this.theSchema.addContent((Content)this.makeListofClassAsElementType(clazz));
        this.theSchema.addContent((Content)this.makeListofClassType(clazz));
    }

    Element makeListofClassAsElementType(Class clazz) {
        return this.makeXsdElement("complexType").setAttribute("name", this.ListofClassAsElementTypeName(clazz)).addContent((Content)this.makeXsdElement("sequence").addContent((Content)this.makeXsdElement("element").setAttribute("name", "list").setAttribute("type", this.ListofClassTypeName(clazz))));
    }

    String ListofClassAsElementTypeName(Class clazz) {
        return "list-of-" + this.getUpperName(clazz) + "-as-element";
    }

    Element makeListofClassType(Class clazz) {
        return this.makeXsdElement("complexType").setAttribute("name", this.ListofClassTypeName(clazz)).addContent((Content)this.makeSequenceOfClass(clazz));
    }

    String ListofClassTypeName(Class clazz) {
        return "list-of-" + this.getUpperName(clazz);
    }

    Element makeSequenceOfClass(Class clazz) {
        return this.makeSequenceOfElement(this.makeXsdElement("element").setAttribute("ref", this.getClassDescr(clazz).getUpperName()));
    }

    Element makeSequenceOfElement(Element element) {
        return this.makeXsdElement("sequence").addContent((Content)element.setAttribute("minOccurs", "0").setAttribute("maxOccurs", "unbounded"));
    }

    Element makeListType() {
        return this.makeXsdElement("complexType").setAttribute("name", "list").addContent((Content)this.makeSequenceOfClass(Object.class));
    }

    Element makeMapType() {
        return this.makeXsdElement("complexType").setAttribute("name", "map").addContent((Content)this.makeSequenceOfElement(this.makeMapEntryElement()));
    }

    Element makeMapEntryElement() {
        return this.makeXsdElement("element").setAttribute("name", "map-entry").addContent((Content)this.makeXsdElement("complexType").addContent((Content)this.makeXsdElement("sequence").addContent((Content)this.makeObjectTypeElement("key")).addContent((Content)this.makeObjectTypeElement("value"))));
    }

    Element makeObjectTypeElement(String string) {
        return this.makeXsdElement("element").setAttribute("name", string).setAttribute("type", this.asElementTypeName(Object.class));
    }

    void addEnumerationSyntax(Schema schema, Class clazz) {
        this.addFrameworkDeclarations(schema, clazz);
        schema.addContent((Content)this.makeEnumerationType(clazz));
    }

    Element makeEnumerationType(Class clazz) {
        return this.makeXsdElement("simpleType").setAttribute("name", this.getElementName(clazz)).addContent((Content)this.makeXsdElement("restriction").setAttribute("base", "xsd:string").setContent((Collection)this.makeEnumerationValueElements(clazz)));
    }

    List makeEnumerationValueElements(Class clazz) {
        LinkedList<Element> linkedList = new LinkedList<Element>();
        Iterator iterator = this.getEnumerationValues(clazz).iterator();
        while (iterator.hasNext()) {
            linkedList.add(this.makeXsdElement("enumeration", new String[][]{{"value", iterator.next().toString()}}));
        }
        return linkedList;
    }

    void addLiteralDocumentSyntax(Schema schema, Class clazz) {
        this.addFrameworkDeclarations(schema, clazz);
        schema.addContent((Content)this.makeLiteralDocumentType(clazz));
    }

    Element makeLiteralDocumentType(Class clazz) {
        ClassDescr classDescr = this.getClassDescr(clazz);
        return this.makeXsdElement("complexType").setAttribute("name", this.getElementName(classDescr)).addContent((Content)this.makeXsdElement("sequence").addContent((Content)this.makeXsdElement("any").setAttribute("processContents", "lax")));
    }

    void addPrimitiveSyntax(Schema schema, Class clazz) {
        this.addFrameworkDeclarations(schema, clazz);
        schema.addContent((Content)this.makePrimitiveType(clazz));
    }

    Element makePrimitiveType(Class clazz) {
        String string = "xsd:" + XMLSchemaSyntax.getSimpleType(clazz);
        return this.makeXsdElement("simpleType").setAttribute("name", this.getElementName(clazz)).addContent((Content)this.makeXsdElement("restriction").setAttribute("base", string));
    }

    public static String getSimpleType(Class clazz) {
        clazz = Fn.objectClass(clazz);
        String string = null;
        for (int i = 0; i < simpleTypeTable.length; ++i) {
            if (simpleTypeTable[i][0] != clazz) continue;
            string = (String)simpleTypeTable[i][1];
            break;
        }
        if (string != null) {
            return string;
        }
        throw new IllegalArgumentException("Can't find XML Schema datatype for " + clazz);
    }

    public Element makeElement(String string, Namespace namespace, String[][] stringArray) {
        ExtendedElement extendedElement = new ExtendedElement(string, namespace);
        XML.setAttributes(extendedElement, stringArray);
        return extendedElement;
    }

    public Element makeXsdElement(String string, String[][] stringArray) {
        return this.makeElement(string, schemaNamespace, stringArray);
    }

    public Element makeXsdElement(String string) {
        return new ExtendedElement(string, schemaNamespace);
    }

    public static void main(String[] stringArray) {
        Debug.off();
        Parameters.processCommandLineArguments(stringArray);
        XMLSchemaSyntax xMLSchemaSyntax = new XMLSchemaSyntax();
        Class clazz = xMLSchemaSyntax.classSyntax.classForExternalName(Parameters.getParameter("root", "object"));
        Schema schema = xMLSchemaSyntax.makeSchema(clazz);
        Document document = new Document((Element)schema);
        XML.printXMLWithWhitespace(document, 1);
    }

    public static class Schema
    extends ExtendedElement {
        Class rootClass;
        Set listofClasses = new HashSet();

        public Schema(Class clazz, String[][] stringArray) {
            super("schema", schemaNamespace);
            this.rootClass = clazz;
            this.addNamespaceDeclaration(XML.config().getHomeNamespace());
            XML.setAttributes(this, stringArray);
        }

        public Class getRootClass() {
            return this.rootClass;
        }

        Set getListofClasses() {
            return this.listofClasses;
        }

        public Element getTypeDefinition(String string) {
            for (Element element : this.getChildren()) {
                if (!element.getName().endsWith("Type") || !element.getAttributeValue("name").equals(string)) continue;
                return element;
            }
            return null;
        }
    }

    static class ExtendedElement
    extends Element {
        ExtendedElement(String string) {
            super(string);
        }

        ExtendedElement(String string, Namespace namespace) {
            super(string, namespace);
        }

        public String toString() {
            String string = this.getAttributeValue("name");
            if (string != null) {
                return super.toString() + ", name attribute = " + string;
            }
            return super.toString();
        }
    }
}

