/*
 * Decompiled with CFR 0.152.
 */
package ix.util.xml;

import ix.iface.domain.LTF_Parser;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.Fn;
import ix.util.Function1;
import ix.util.Predicate1;
import ix.util.Strings;
import ix.util.Util;
import ix.util.reflect.ClassDescr;
import ix.util.reflect.ClassSyntax;
import ix.util.reflect.FieldDescr;
import ix.util.reflect.FieldVisitor;
import ix.util.reflect.InheritanceTree;
import ix.util.xml.XML;
import ix.util.xml.XMLTranslator;
import java.io.PrintStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class XMLSyntax {
    protected XMLTranslator xmlt;
    protected ClassSyntax classSyntax;
    protected InheritanceTree inheritance;
    protected Predicate1 attributeFieldP = new Predicate1(){

        public boolean trueOf(Object object) {
            FieldDescr fieldDescr = (FieldDescr)object;
            return XMLSyntax.this.xmlt.isAttributeClass(fieldDescr.getType());
        }
    };

    public XMLSyntax() {
        this(XML.defaultTranslator());
    }

    public XMLSyntax(XMLTranslator xMLTranslator) {
        this.xmlt = xMLTranslator;
        this.classSyntax = xMLTranslator.getClassSyntax();
    }

    protected ClassDescr getClassDescr(Class clazz) {
        return this.classSyntax.getClassDescr(clazz);
    }

    protected String getNTName(ClassDescr classDescr) {
        return classDescr.getUpperName();
    }

    protected String getNTName(Class clazz) {
        return this.getNTName(this.getClassDescr(clazz));
    }

    protected String getUpperName(ClassDescr classDescr) {
        return classDescr.getUpperName();
    }

    protected String getUpperName(Class clazz) {
        return this.getUpperName(this.getClassDescr(clazz));
    }

    protected String getElementName(ClassDescr classDescr) {
        return classDescr.getExternalName();
    }

    protected String getElementName(Class clazz) {
        return this.getElementName(this.getClassDescr(clazz));
    }

    protected String getElementName(FieldDescr fieldDescr) {
        return fieldDescr.getExternalName();
    }

    public List relevantClasses(Class clazz) {
        return XML.config().xmlSyntaxClasses(this.classSyntax, clazz);
    }

    protected void collectListofClasses(List list, final Collection collection) {
        this.walkStructFields(list, new FieldVisitor(){

            public void visitField(ClassDescr classDescr, FieldDescr fieldDescr) {
                ClassDescr classDescr2 = fieldDescr.getTypeDescr();
                ClassDescr classDescr3 = classDescr2.getEltType();
                if (classDescr2.isList() && classDescr3 != null) {
                    collection.add(classDescr3.getDescribedClass());
                }
            }
        });
    }

    protected void walkStructFields(List list, FieldVisitor fieldVisitor) {
        for (Class clazz : list) {
            ClassDescr classDescr = this.getClassDescr(clazz);
            if (!classDescr.isStruct()) continue;
            classDescr.visitFields(fieldVisitor);
        }
    }

    protected List attributeFields(List list) {
        return (List)Collect.filter(list, this.attributeFieldP);
    }

    protected List elementFields(List list) {
        return (List)Collect.filter(list, Fn.negate(this.attributeFieldP));
    }

    protected List getConstraintSyntaxList() {
        LTF_Parser lTF_Parser = new LTF_Parser();
        Vector vector = lTF_Parser.getConstraintParsers().getCases();
        return (List)Collect.map(new LinkedList(), vector, new Function1(){

            public Object funcall(Object object) {
                LTF_Parser.ConstraintParser constraintParser = (LTF_Parser.ConstraintParser)object;
                return constraintParser.makeTemplate();
            }
        });
    }

    protected List getEnumerationValues(Class clazz) {
        if (this.getClassDescr(clazz).isEnumeration()) {
            return (List)Fn.applyStatic(clazz, "values", new Object[0]);
        }
        throw new IllegalArgumentException(clazz + " is not an enumeration.");
    }

    public static void main(String[] stringArray) {
        XMLSyntax xMLSyntax = new XMLSyntax();
        String string;
        while (!(string = Util.askLine("Class name:")).equals("bye")) {
            xMLSyntax.describeClass(string, System.out);
            System.out.println("");
        }
        return;
    }

    public void describeClass(String string, PrintStream printStream) {
        Class clazz = this.classSyntax.classForExternalName(string);
        if (clazz == null) {
            printStream.println("Can't find class named " + string);
            return;
        }
        printStream.println("Syntax for " + string + ":");
        ClassDescr classDescr = this.getClassDescr(clazz);
        if (classDescr.isStruct()) {
            printStream.println(this.structTextDescription(classDescr));
        } else {
            printStream.println("No description available.");
        }
    }

    public String structTextDescription(ClassDescr classDescr) {
        List<FieldDescr> list = classDescr.getFieldDescrs();
        List list2 = this.attributeFields(list);
        List list3 = this.elementFields(list);
        List list4 = Collect.append(list2, list3);
        Debug.expect(list.size() == list4.size());
        LinkedList<String> linkedList = new LinkedList<String>();
        for (FieldDescr fieldDescr : list4) {
            String string = this.xmlt.isAttributeClass(fieldDescr.getType()) ? "attribute" : "element";
            linkedList.add("   " + string + " " + fieldDescr.getExternalName() + ": " + fieldDescr.getTypeDescr().description());
        }
        return Strings.joinLines(linkedList);
    }
}

