/*
 * Decompiled with CFR 0.152.
 */
package ix.util.xml;

import ix.iface.util.CatchingActionListener;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Seq;
import ix.util.Strings;
import ix.util.Util;
import ix.util.lisp.LList;
import ix.util.reflect.ClassDescr;
import ix.util.reflect.ClassFinder;
import ix.util.reflect.FieldDescr;
import ix.util.xml.XML;
import ix.util.xml.XMLSyntax;
import ix.util.xml.XMLTranslator;
import ix.util.xml.XMLTreeEditFrame;
import ix.util.xml.event.NamespaceEvent;
import ix.util.xml.event.NamespaceListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;

public class XMLTreeEditPanel
extends JPanel
implements NamespaceListener,
ActionListener,
TreeSelectionListener {
    protected Document document;
    protected static final String ATTRIBUTES = "[attributes]";
    protected static EditorTree mostRecentlySelectedTree;
    protected TNodeFactory nodeFactory = new TNodeFactory();
    protected TNodeParser nodeParser = new TNodeParser();
    protected TemplateSyntax syntax = new TemplateSyntax();
    protected EditorTree docTree;
    protected DefaultTreeModel docModel;
    protected EditorTree templateTree;
    protected EditingTextArea editText;
    protected JButton submitButton;
    protected JSplitPane docSplit;
    protected JSplitPane textSplit;

    public XMLTreeEditPanel() {
        super(new BorderLayout());
        TNode tNode = new TNode("root");
        tNode.setShouldBeExpanded(true);
        this.docModel = new DefaultTreeModel(tNode);
        this.docTree = new EditorTree("document tree", this.docModel);
        this.docTree.setEditable(false);
        this.docTree.getSelectionModel().setSelectionMode(1);
        this.docTree.setShowsRootHandles(true);
        this.docTree.addTreeSelectionListener(this);
        this.docTree.addMouseListener(new TreeMouseListener());
        this.templateTree = this.makeTemplateTree();
        this.addTemplates();
        this.editText = new EditingTextArea(0, 0);
        this.editText.setEditable(false);
        this.submitButton = this.makeButton("Enter");
        this.submitButton.setEnabled(false);
        JScrollPane jScrollPane = new JScrollPane(this.docTree);
        jScrollPane.setBorder(BorderFactory.createTitledBorder("Document"));
        JScrollPane jScrollPane2 = new JScrollPane(this.templateTree);
        jScrollPane2.setBorder(BorderFactory.createTitledBorder("Templates"));
        JScrollPane jScrollPane3 = new JScrollPane(this.editText);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Text"));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jScrollPane3, "Center");
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalGlue());
        box.add(this.submitButton);
        jPanel.add((Component)box, "East");
        this.docSplit = new JSplitPane(1, jScrollPane, jScrollPane2);
        this.docSplit.setOneTouchExpandable(true);
        this.docSplit.setResizeWeight(1.0);
        this.textSplit = new JSplitPane(0, this.docSplit, jPanel);
        this.textSplit.setResizeWeight(1.0);
        this.add((Component)this.textSplit, "Center");
        this.add((Component)this.makeButtonPanel(), "South");
        XMLTreeEditFrame.namespaces.addNamespaceListener(this);
    }

    protected void reset() {
        this.setDocRoot(new TNode("root"));
        this.editText.clear();
    }

    protected XMLTreeEditFrame getEditFrame() {
        return (XMLTreeEditFrame)SwingUtilities.getRoot(this);
    }

    protected void setDocRoot(TNode tNode) {
        this.docModel.setRoot(tNode);
        tNode.setShouldBeExpanded(true);
    }

    public void editDocument(Document document) {
        this.document = document;
        this.setDocRoot(this.nodeFactory.nodeFrom(document));
        if (mostRecentlySelectedTree == this.docTree) {
            this.editText.clear();
        }
    }

    public Document getDocument() {
        this.document = this.nodeParser.documentFrom((TNode)this.docModel.getRoot());
        return this.document;
    }

    public void expandDocument(int n) {
        TNode tNode = (TNode)this.docModel.getRoot();
        tNode.expandSubtree(n);
        this.docTree.fixExpansions();
    }

    public void addRootChild(Document document) {
        TNode tNode = (TNode)this.docModel.getRoot();
        TNode tNode2 = this.nodeFactory.nodeFrom(document);
        this.docModel.insertNodeInto(tNode2, tNode, tNode.getChildCount());
        this.docTree.scrollPathToVisible(tNode2.getTreePath());
    }

    public void editObject(Object object) {
        this.editDocument(this.syntax.xmlt().objectToDocument(object));
    }

    public Object getObject() {
        Document document = this.getDocument();
        try {
            return this.syntax.xmlt().objectFromDocument(document);
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            Element element = this.syntax.xmlt().getLastExaminedElement();
            if (element != null) {
                Debug.noteln("Bad elt", (Object)element);
                TNode tNode = this.nodeParser.getNodeForElement(element);
                if (tNode != null) {
                    TreePath treePath = tNode.getTreePath();
                    Debug.noteln("Bad node's path", (Object)treePath);
                    this.docTree.scrollPathToVisible(treePath);
                    this.docTree.setSelectionPath(treePath);
                }
            }
            throw new InvalidNode(Debug.describeException(exception));
        }
    }

    public void findInTree(String string) {
        Debug.noteln("Edit panel asked to find " + Strings.quote(string));
        EditorTree editorTree = mostRecentlySelectedTree;
        if (editorTree == null) {
            this.complain("No selected tree");
            return;
        }
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)editorTree.getModel();
        TNode tNode = (TNode)defaultTreeModel.getRoot();
        TNode tNode2 = editorTree.getSelectedNode();
        boolean bl = false;
        Enumeration<TreeNode> enumeration = tNode.preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            String string2;
            TNode tNode3 = (TNode)enumeration.nextElement();
            if (tNode3 == tNode2) {
                bl = true;
                continue;
            }
            if (!bl || (string2 = (String)tNode3.getUserObject()).indexOf(string) < 0) continue;
            TreePath treePath = tNode3.getTreePath();
            Debug.noteln("Found text at path", (Object)treePath);
            editorTree.scrollPathToVisible(treePath);
            editorTree.setSelectionPath(treePath);
            return;
        }
        this.complain("Can't find " + Strings.quote(string));
    }

    protected Color getNamespaceColor(Namespace namespace) {
        return XMLTreeEditFrame.namespaces.getNamespaceColor(namespace);
    }

    protected void noteNamespace(Namespace namespace) {
        XMLTreeEditFrame.namespaces.noteNamespace(namespace);
    }

    public void namespaceEvent(NamespaceEvent namespaceEvent) {
        if (namespaceEvent.isColorChange()) {
            this.repaint();
        }
    }

    public void addTemplates() {
        this.addTemplatesFor(XML.config().treeEditorTemplateClassRoots());
        this.addTemplate(this.syntax.makeMapEntryNode());
    }

    public void addTemplatesFor(Class[] classArray) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.templateTree.getModel();
        TNode tNode = (TNode)defaultTreeModel.getRoot();
        List list = this.syntax.makeTemplateNodes(classArray);
        for (TNode tNode2 : list) {
            tNode.add(tNode2);
        }
        defaultTreeModel.nodeStructureChanged(tNode);
    }

    public void addTemplate(TNode tNode) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.templateTree.getModel();
        TNode tNode2 = (TNode)defaultTreeModel.getRoot();
        tNode2.add(tNode);
        defaultTreeModel.nodeStructureChanged(tNode2);
    }

    public void hideTemplates() {
        Debug.noteln("Hiding templates");
        this.docSplit.setDividerLocation(1.0);
    }

    protected EditorTree makeTemplateTree() {
        TNode tNode = new TNode("Templates");
        tNode.setShouldBeExpanded(true);
        TemplateTree templateTree = new TemplateTree("template tree", tNode);
        templateTree.setEditable(false);
        templateTree.getSelectionModel().setSelectionMode(1);
        templateTree.setShowsRootHandles(true);
        templateTree.addTreeSelectionListener(this);
        templateTree.addMouseListener(new TreeMouseListener());
        return templateTree;
    }

    protected JPanel makeButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.makeButton("Add Child"));
        jPanel.add(this.makeButton("Copy Subtree"));
        jPanel.add(this.makeButton("Cut Subtree"));
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    protected JButton makeButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(CatchingActionListener.listener(this));
        return jButton;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("XMLTreeEditPanel action:", (Object)string);
        if (string.equals("Add Child")) {
            this.addChild();
        } else if (string.equals("Copy Subtree")) {
            this.copySubtree();
        } else if (string.equals("Cut Subtree")) {
            this.cutSubtree();
        } else if (actionEvent.getSource() == this.submitButton) {
            this.editText.submit();
        } else {
            throw new ConsistencyException("Nothing to do for " + string);
        }
    }

    public void addChild() {
        EditorTree editorTree = mostRecentlySelectedTree;
        if (editorTree == null) {
            this.complain("No selected tree");
            return;
        }
        TNode tNode = editorTree.getSelectedNode();
        TNode tNode2 = new TNode("blank");
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)editorTree.getModel();
        defaultTreeModel.insertNodeInto(tNode2, tNode, tNode.getChildCount());
        editorTree.scrollPathToVisible(tNode2.getTreePath());
    }

    public void copySubtree() {
        EditorTree editorTree = mostRecentlySelectedTree;
        if (editorTree == null) {
            this.complain("No selected tree");
            return;
        }
        TNode tNode = editorTree.getSelectedNode();
        new CutFrame(tNode.copySubtree(), "Copy");
    }

    public void cutSubtree() {
        EditorTree editorTree = mostRecentlySelectedTree;
        if (editorTree == null) {
            this.complain("No selected tree");
            return;
        }
        TNode tNode = editorTree.getSelectedNode();
        if (editorTree.cutNodeSubtree(tNode)) {
            new CutFrame(tNode, "Cut");
        }
    }

    protected void complain(Object object) {
        JOptionPane.showMessageDialog(this, object, "Error", 0);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        EditorTree editorTree = (EditorTree)treeSelectionEvent.getSource();
        TNode tNode = (TNode)editorTree.getLastSelectedPathComponent();
        if (tNode == null) {
            return;
        }
        Debug.noteln(editorTree.getName() + " selection", (Object)tNode.getTreePath());
        this.setSelectedTree(editorTree);
        this.editText.display(tNode);
    }

    void setSelectedTree(EditorTree editorTree) {
        if (mostRecentlySelectedTree != null && mostRecentlySelectedTree != editorTree) {
            Debug.noteln("Changing selected tree");
            mostRecentlySelectedTree.clearSelectionEtc();
        }
        mostRecentlySelectedTree = editorTree;
    }

    JPopupMenu makeNodePopupMenu(EditorTree editorTree, TNode tNode) {
        return new NodePopupMenu(editorTree, tNode);
    }

    class CutFrame
    extends JFrame
    implements ActionListener {
        EditorTree subtree;
        TNode subtreeNode;
        EditorTree destinationTree;
        DefaultTreeModel destinationModel;
        Container contentPane;

        CutFrame(TNode tNode, String string) {
            super(string);
            this.contentPane = this.getContentPane();
            this.subtreeNode = tNode;
            this.subtree = new EditorTree(string + " tree", tNode);
            this.subtree.setEditable(false);
            this.subtree.setSelectionModel(null);
            this.subtree.setShowsRootHandles(true);
            this.subtree.fixExpansions();
            JScrollPane jScrollPane = new JScrollPane(this.subtree);
            jScrollPane.setBorder(BorderFactory.createTitledBorder("Subtree"));
            this.contentPane.add((Component)jScrollPane, "Center");
            JPanel jPanel = this.makeButtonPanel();
            jPanel.setBorder(BorderFactory.createTitledBorder("Insert ..."));
            this.contentPane.add((Component)jPanel, "South");
            this.setSize(400, 300);
            this.setVisible(true);
        }

        JPanel makeButtonPanel() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(Box.createHorizontalGlue());
            jPanel.add(this.makeButton("As"));
            jPanel.add(this.makeButton("Before"));
            jPanel.add(this.makeButton("After"));
            jPanel.add(this.makeButton("Child"));
            jPanel.add(this.makeButton("Discard"));
            jPanel.add(Box.createHorizontalGlue());
            return jPanel;
        }

        JButton makeButton(String string) {
            JButton jButton = new JButton(string);
            jButton.addActionListener(CatchingActionListener.listener(this));
            return jButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Debug.noteln("CutFrame action:", (Object)string);
            if (string.equals("Discard")) {
                this.subtreeNode = null;
                this.finished();
                return;
            }
            this.destinationTree = mostRecentlySelectedTree;
            if (this.destinationTree == null) {
                XMLTreeEditPanel.this.complain("No selected tree");
                return;
            }
            this.destinationModel = (DefaultTreeModel)this.destinationTree.getModel();
            TNode tNode = this.destinationTree.getSelectedNode();
            if (string.equals("As")) {
                this.insertAs(tNode);
            } else if (string.equals("Before")) {
                this.insertBefore(tNode);
            } else if (string.equals("After")) {
                this.insertAfter(tNode);
            } else if (string.equals("Child")) {
                this.insertUnder(tNode);
            } else {
                throw new ConsistencyException("Nothing to do for " + string);
            }
        }

        void insertAs(TNode tNode) {
            TNode tNode2 = (TNode)tNode.getParent();
            if (tNode2 == null) {
                this.destinationModel.setRoot(this.subtreeNode);
            } else {
                int n = this.destinationModel.getIndexOfChild(tNode2, tNode);
                this.destinationModel.removeNodeFromParent(tNode);
                this.destinationModel.insertNodeInto(this.subtreeNode, tNode2, n);
            }
            XMLTreeEditPanel.this.editText.clear();
            this.finished();
        }

        void insertBefore(TNode tNode) {
            TNode tNode2 = (TNode)tNode.getParent();
            if (tNode2 == null) {
                XMLTreeEditPanel.this.complain("Cannot insert before root");
            } else {
                this.destinationModel.insertNodeInto(this.subtreeNode, tNode2, this.destinationModel.getIndexOfChild(tNode2, tNode));
                this.finished();
            }
        }

        void insertAfter(TNode tNode) {
            TNode tNode2 = (TNode)tNode.getParent();
            if (tNode2 == null) {
                XMLTreeEditPanel.this.complain("Cannot insert at same level as root");
            } else {
                this.destinationModel.insertNodeInto(this.subtreeNode, tNode2, this.destinationModel.getIndexOfChild(tNode2, tNode) + 1);
                this.finished();
            }
        }

        void insertUnder(TNode tNode) {
            this.destinationModel.insertNodeInto(this.subtreeNode, tNode, 0);
            this.finished();
        }

        void finished() {
            if (this.subtreeNode != null) {
                this.destinationTree.fixExpansions();
                this.destinationTree.scrollPathToVisible(this.subtreeNode.getTreePath());
            }
            this.dispose();
        }
    }

    class EditingTextArea
    extends JTextArea {
        TNode editingNode;
        TNode valueNode;
        boolean autoSelect;

        EditingTextArea(int n, int n2) {
            super(n, n2);
            this.autoSelect = false;
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (EditingTextArea.this.autoSelect) {
                        EditingTextArea.this.autoSelect = false;
                        EditingTextArea.this.setSelectionStart(0);
                        EditingTextArea.this.setSelectionEnd(EditingTextArea.this.getText().length());
                    }
                }
            });
        }

        void display(TNode tNode) {
            this.editingNode = tNode;
            this.setText((String)tNode.getUserObject());
            this.setCaretPosition(0);
            this.setEditable(true);
            XMLTreeEditPanel.this.submitButton.setEnabled(true);
        }

        void clear() {
            if (this.editingNode != null) {
                this.editingNode = null;
                this.setText("");
                this.setEditable(false);
                XMLTreeEditPanel.this.submitButton.setEnabled(false);
            }
        }

        public void setText(String string) {
            super.setText(string);
            this.autoSelect = true;
        }

        void submit() {
            TNode tNode = mostRecentlySelectedTree.getSelectedNode();
            Debug.expect(tNode == this.editingNode, "Text was not from selected node");
            this.editingNode.setUserObject(this.getText());
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)mostRecentlySelectedTree.getModel();
            defaultTreeModel.nodeStructureChanged(this.editingNode);
        }
    }

    class TNodeRenderer
    extends DefaultTreeCellRenderer {
        public TNodeRenderer() {
            this.setOpenIcon(null);
            this.setClosedIcon(null);
            this.setLeafIcon(null);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            String string;
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            TNode tNode = (TNode)object;
            Namespace namespace = tNode.getNamespace();
            if (namespace != null && tNode.renderingText == null && (string = namespace.getPrefix()) != null && !string.equals("")) {
                tNode.renderingText = string + ":" + this.getText();
            }
            if (tNode.renderingText != null) {
                this.setText(tNode.renderingText);
            }
            this.setForeground(XMLTreeEditPanel.this.getNamespaceColor(namespace));
            return this;
        }
    }

    class RecordingExpansionListener
    implements TreeExpansionListener {
        JTree tree;
        boolean active = true;

        RecordingExpansionListener(JTree jTree) {
            this.tree = jTree;
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            if (this.active) {
                Debug.noteln("Tree expanding", (Object)treeExpansionEvent.getPath());
                this.theNode(treeExpansionEvent).setShouldBeExpanded(true);
            }
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            if (this.active) {
                Debug.noteln("Tree collapsing", (Object)treeExpansionEvent.getPath());
                this.theNode(treeExpansionEvent).setShouldBeExpanded(false);
            }
        }

        TNode theNode(TreeExpansionEvent treeExpansionEvent) {
            Debug.expect(treeExpansionEvent.getSource() == this.tree);
            return (TNode)treeExpansionEvent.getPath().getLastPathComponent();
        }
    }

    class TemplateTree
    extends EditorTree {
        TemplateTree(String string, TreeNode treeNode) {
            super(string, treeNode);
        }

        boolean cutNodeSubtree(TNode tNode) {
            if (Util.dialogConfirms(XMLTreeEditPanel.this, "Are you sure you want to cut a template?")) {
                return super.cutNodeSubtree(tNode);
            }
            return false;
        }
    }

    class EditorTree
    extends JTree {
        RecordingExpansionListener expansionListener;

        EditorTree(String string, TreeNode treeNode) {
            this(string, new DefaultTreeModel(treeNode));
        }

        EditorTree(String string, TreeModel treeModel) {
            super(treeModel);
            this.expansionListener = new RecordingExpansionListener(this);
            this.setName(string);
            this.addTreeExpansionListener(this.expansionListener);
            this.putClientProperty("JTree.lineStyle", "Angled");
            TNodeRenderer tNodeRenderer = new TNodeRenderer();
            this.setCellRenderer(tNodeRenderer);
        }

        void clearSelectionEtc() {
            this.clearSelection();
            XMLTreeEditPanel.this.editText.clear();
        }

        boolean cutNodeSubtree(TNode tNode) {
            TNode tNode2 = (TNode)tNode.getParent();
            if (tNode2 == null) {
                throw new InvalidCommand("A root cannot be cut");
            }
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
            defaultTreeModel.removeNodeFromParent(tNode);
            return true;
        }

        TNode getSelectedNode() {
            TNode tNode = (TNode)this.getLastSelectedPathComponent();
            if (tNode == null) {
                throw new InvalidCommand("No selected node");
            }
            return tNode;
        }

        void fixExpansions() {
            this.fixExpansions((TNode)this.getModel().getRoot());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fixExpansions(TNode tNode) {
            try {
                this.expansionListener.active = false;
                this.fixExpansionsRec(tNode);
            }
            finally {
                this.expansionListener.active = true;
            }
        }

        private void fixExpansionsRec(TNode tNode) {
            Object object = tNode.children();
            while (object.hasMoreElements()) {
                this.fixExpansionsRec((TNode)object.nextElement());
            }
            object = tNode.getTreePath();
            if (tNode.shouldBeExpanded()) {
                if (!this.isExpanded((TreePath)object)) {
                    this.expandPath((TreePath)object);
                }
            } else if (!this.isCollapsed((TreePath)object)) {
                this.collapsePath((TreePath)object);
            }
        }
    }

    class NodePopupMenu
    extends JPopupMenu
    implements ActionListener {
        EditorTree tree;
        DefaultTreeModel model;
        TNode node;

        NodePopupMenu(EditorTree editorTree, TNode tNode) {
            this.tree = editorTree;
            this.model = (DefaultTreeModel)editorTree.getModel();
            this.node = tNode;
            this.addMenuItems();
        }

        void addMenuItems() {
            if (XMLTreeEditPanel.this.nodeParser.isAttribute(this.node)) {
                this.addValueMenuItemIfKnown();
            }
            this.add(this.makeMenuItem("Fully Expand", !this.node.isLeaf()));
            this.add(this.makeMenuItem("Fully Collapse", !this.node.isLeaf()));
            if (!XMLTreeEditPanel.this.nodeParser.isAttributesList(this.node)) {
                this.add(this.makeNamespaceMenu());
            }
            this.add(this.makeMenuItem("Add Child"));
            this.add(this.makeMenuItem("Copy Subtree"));
            this.add(this.makeMenuItem("Cut Subtree"));
            if (XMLTreeEditPanel.this.nodeParser.isAttributesList(this.node)) {
                this.add(this.makeMenuItem("Delete Valueless Attributes"));
            } else if (this.node.getChildCount() > 0) {
                this.add(this.makeMenuItem("Delete Closed Subnodes"));
            }
        }

        JMenuItem makeMenuItem(String string) {
            return this.makeMenuItem(string, true);
        }

        JMenuItem makeMenuItem(String string, boolean bl) {
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(CatchingActionListener.listener(this));
            jMenuItem.setEnabled(bl);
            return jMenuItem;
        }

        void addValueMenuItemIfKnown() {
            List list;
            TNode tNode = XMLTreeEditPanel.this.nodeParser.getAttributeContainingObjectNode(this.node);
            String string = (String)tNode.getUserObject();
            Class clazz = XMLTreeEditPanel.this.syntax.classForXmlName(string);
            String string2 = XMLTreeEditPanel.this.nodeParser.getAttributeName(this.node);
            FieldDescr fieldDescr = XMLTreeEditPanel.this.syntax.getClassDescr(clazz).fieldForExternalName(string2);
            if (fieldDescr != null && fieldDescr.getTypeDescr().isEnumeration() && (list = XMLTreeEditPanel.this.syntax.getEnumerationValues(fieldDescr.getType())) != null) {
                JMenu jMenu = this.makeValueMenu(list);
                this.add(jMenu);
            }
        }

        JMenu makeValueMenu(List list) {
            JMenu jMenu = new JMenu("Set Value");
            for (Object e : list) {
                JMenuItem jMenuItem = this.makeMenuItem(e.toString());
                jMenuItem.setActionCommand("setValue");
                jMenu.add(jMenuItem);
            }
            return jMenu;
        }

        JMenu makeNamespaceMenu() {
            JMenu jMenu = new JMenu("Set Namespace");
            List list = XMLTreeEditFrame.namespaces.getNamespaces();
            for (Namespace namespace : list) {
                String string = namespace.getPrefix();
                String string2 = namespace.getURI();
                Color color = XMLTreeEditFrame.namespaces.getNamespaceColor(namespace);
                String string3 = namespace == Namespace.NO_NAMESPACE ? "No Namespace" : (string.equals("") ? string2 : string + "=" + string2);
                JMenuItem jMenuItem = this.makeMenuItem(string3);
                jMenuItem.setForeground(color);
                jMenuItem.setActionCommand("setNamespace");
                jMenu.add(jMenuItem);
            }
            return jMenu;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Debug.noteln("Item popup command", (Object)string);
            if (string.equals("Fully Expand")) {
                this.fullyExpand();
            } else if (string.equals("Fully Collapse")) {
                this.fullyCollapse();
            } else if (string.equals("Add Child")) {
                this.addChild();
            } else if (string.equals("setNamespace")) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                this.setNamespace(jMenuItem.getText());
            } else if (string.equals("Copy Subtree")) {
                this.copySubtree();
            } else if (string.equals("Cut Subtree")) {
                this.cutSubtree();
            } else if (string.equals("setValue")) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                String string2 = jMenuItem.getText();
                this.setValue(string2);
            } else if (string.equals("Delete Valueless Attributes")) {
                this.deleteValuelessAttributes();
            } else if (string.equals("Delete Closed Subnodes")) {
                this.deleteClosedSubnodes();
            } else {
                throw new ConsistencyException("Nothing to do for " + string);
            }
        }

        void fullyExpand() {
            this.node.setSubtreeShouldBeExpanded(true);
            this.tree.fixExpansions(this.node);
        }

        void fullyCollapse() {
            this.node.setSubtreeShouldBeExpanded(false);
            this.tree.fixExpansions(this.node);
        }

        void setNamespace(String string) {
            Namespace namespace = string.equals("No Namespace") ? Namespace.NO_NAMESPACE : XMLTreeEditFrame.namespaces.parseNamespaceSpec(string);
            this.node.setNamespace(namespace);
            this.model.nodeChanged(this.node);
        }

        void addChild() {
            TNode tNode = new TNode("blank");
            this.model.insertNodeInto(tNode, this.node, this.node.getChildCount());
            this.tree.scrollPathToVisible(tNode.getTreePath());
        }

        void copySubtree() {
            new CutFrame(this.node.copySubtree(), "Copy");
        }

        void cutSubtree() {
            if (this.tree.cutNodeSubtree(this.node)) {
                new CutFrame(this.node, "Cut");
            }
        }

        void setValue(String string) {
            String string2 = (String)this.node.getUserObject();
            String string3 = Strings.beforeFirst("=", string2);
            this.node.setUserObject(string3 + "=" + string);
            this.model.nodeChanged(this.node);
        }

        void deleteValuelessAttributes() {
            LList lList = Seq.toLList(this.node.children());
            for (TNode tNode : lList) {
                if (!XMLTreeEditPanel.this.nodeParser.getAttributeValue(tNode).trim().equals("")) continue;
                this.model.removeNodeFromParent(tNode);
            }
        }

        void deleteClosedSubnodes() {
            LList lList = Seq.toLList(this.node.children());
            for (TNode tNode : lList) {
                if (tNode.shouldBeExpanded()) continue;
                this.model.removeNodeFromParent(tNode);
            }
        }
    }

    class TreeMouseListener
    extends MouseAdapter {
        TreeMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            EditorTree editorTree = (EditorTree)mouseEvent.getSource();
            int n = editorTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            TreePath treePath = editorTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n == -1) {
                return;
            }
            if (!SwingUtilities.isRightMouseButton(mouseEvent)) {
                return;
            }
            Debug.noteln("Right click in " + editorTree.getName(), (Object)treePath);
            TNode tNode = (TNode)treePath.getLastPathComponent();
            JPopupMenu jPopupMenu = XMLTreeEditPanel.this.makeNodePopupMenu(editorTree, tNode);
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    class TemplateSyntax
    extends XMLSyntax {
        TemplateSyntax() {
        }

        List makeTemplateNodes(Class[] classArray) {
            List<Class> list = this.classSyntax.relevantClasses(classArray);
            LinkedList<TNode> linkedList = new LinkedList<TNode>();
            for (Class clazz : list) {
                TNode tNode = this.templateFrom(clazz);
                if (tNode == null) continue;
                linkedList.add(tNode);
            }
            return linkedList;
        }

        TNode templateFrom(Class clazz) {
            ClassDescr classDescr = this.getClassDescr(clazz);
            if (classDescr.isStruct() && !classDescr.isAbstract()) {
                return this.structTemplateFrom(clazz);
            }
            return null;
        }

        TNode structTemplateFrom(Class clazz) {
            ClassDescr classDescr = this.getClassDescr(clazz);
            String string = this.getElementName(classDescr);
            List<FieldDescr> list = classDescr.getFieldDescrs();
            List list2 = this.attributeFields(list);
            List list3 = this.elementFields(list);
            Debug.expect(list.size() == list2.size() + list3.size());
            ObjTNode objTNode = new ObjTNode(string);
            if (list2.isEmpty()) {
                if (list3.isEmpty()) {
                    return null;
                }
            } else {
                objTNode.add(this.makeAttributesNode(list2));
            }
            for (FieldDescr fieldDescr : list3) {
                objTNode.add(this.makeFieldNode(fieldDescr));
            }
            return objTNode;
        }

        TNode makeAttributesNode(List list) {
            TNode tNode = new TNode(XMLTreeEditPanel.ATTRIBUTES);
            for (FieldDescr fieldDescr : list) {
                String string = this.getElementName(fieldDescr);
                tNode.add(new TNode(string + "="));
            }
            return tNode;
        }

        TNode makeFieldNode(FieldDescr fieldDescr) {
            ObjTNode objTNode = new ObjTNode(this.getElementName(fieldDescr));
            ClassDescr classDescr = fieldDescr.getTypeDescr();
            if (classDescr.isList()) {
                String string = this.getElementName(List.class);
                ObjTNode objTNode2 = new ObjTNode(string);
                objTNode2.add(new TNode(string + "-element..."));
                objTNode.add(objTNode2);
            } else if (classDescr.isSet()) {
                String string = this.getElementName(Set.class);
                ObjTNode objTNode3 = new ObjTNode(string);
                objTNode3.add(new TNode(string + "-element..."));
                objTNode.add(objTNode3);
            } else if (classDescr.isMap()) {
                String string = this.getElementName(Map.class);
                ObjTNode objTNode4 = new ObjTNode(string);
                objTNode4.add(this.makeMapEntryNode());
                objTNode.add(objTNode4);
            } else {
                String string = this.getElementName(classDescr);
                String string2 = string + "-value";
                ObjTNode objTNode5 = new ObjTNode(string);
                TNode tNode = classDescr.isPrimitive() ? new TNode(string2) : new ObjTNode(string2);
                objTNode5.add(tNode);
                objTNode.add(objTNode5);
            }
            return objTNode;
        }

        TNode makeMapEntryNode() {
            ClassFinder classFinder = this.classSyntax.getClassFinder();
            String string = classFinder.externalName("MapEntry");
            ObjTNode objTNode = new ObjTNode(string);
            objTNode.add(new ObjTNode("key"));
            objTNode.add(new ObjTNode("value"));
            return objTNode;
        }

        XMLTranslator xmlt() {
            return this.xmlt;
        }

        Class classForXmlName(String string) {
            return this.classSyntax.classForExternalName(string);
        }
    }

    class InvalidNode
    extends RuntimeException {
        InvalidNode(String string) {
            super(string);
        }
    }

    class TNodeParser {
        Map elementToNodeMap = new WeakHashMap();

        TNodeParser() {
        }

        Document documentFrom(TNode tNode) {
            this.elementToNodeMap.clear();
            Element element = this.elementFrom(tNode);
            return new Document(element);
        }

        Element elementFrom(TNode tNode) {
            if (this.isAttributesList(tNode)) {
                throw this.syntaxError(tNode, "Misplaced attributes");
            }
            Element element = this.isAtomicValue(tNode) ? this.valueElementFrom(tNode) : (this.isTextWithAttributes(tNode) ? this.textWithAttributesFrom(tNode) : this.structElementFrom(tNode));
            this.elementToNodeMap.put(element, tNode);
            return element;
        }

        TNode getNodeForElement(Element element) {
            return (TNode)this.elementToNodeMap.get(element);
        }

        Element valueElementFrom(TNode tNode) {
            String string = (String)tNode.getUserObject();
            TNode tNode2 = (TNode)tNode.getChildAt(0);
            String string2 = (String)tNode2.getUserObject();
            Element element = new Element(string, tNode.getNamespace());
            element.setText(string2);
            return element;
        }

        Element textWithAttributesFrom(TNode tNode) {
            String string = (String)tNode.getUserObject();
            Element element = new Element(string, tNode.getNamespace());
            Debug.expect(this.hasAttributes(tNode));
            this.addAttributes(element, tNode);
            TNode tNode2 = (TNode)tNode.getChildAt(1);
            String string2 = (String)tNode2.getUserObject();
            element.setText(string2);
            return element;
        }

        Element structElementFrom(TNode tNode) {
            String string = (String)tNode.getUserObject();
            Enumeration<TreeNode> enumeration = tNode.children();
            Element element = new Element(string, tNode.getNamespace());
            if (this.hasAttributes(tNode)) {
                this.addAttributes(element, tNode);
                enumeration.nextElement();
            }
            while (enumeration.hasMoreElements()) {
                TNode tNode2 = (TNode)enumeration.nextElement();
                element.addContent((Content)this.elementFrom(tNode2));
            }
            return element;
        }

        void addAttributes(Element element, TNode tNode) {
            TNode tNode2 = (TNode)tNode.getChildAt(0);
            Enumeration<TreeNode> enumeration = tNode2.children();
            while (enumeration.hasMoreElements()) {
                TNode tNode3 = (TNode)enumeration.nextElement();
                this.addAttribute(element, tNode3);
            }
        }

        void addAttribute(Element element, TNode tNode) {
            String[] stringArray = this.parseAttribute(tNode);
            element.setAttribute(stringArray[0], stringArray[1], tNode.getNamespace());
        }

        String[] parseAttribute(TNode tNode) {
            if (!this.isAttribute(tNode)) {
                throw this.syntaxError(tNode, "Invalid attribute");
            }
            String string = (String)tNode.getUserObject();
            String[] stringArray = Strings.breakAtFirst("=", string);
            if (tNode.getChildCount() != 0 || stringArray[0].equals("")) {
                throw this.syntaxError(tNode, "Invalid attribute");
            }
            return stringArray;
        }

        boolean hasAttributes(TNode tNode) {
            return tNode.getChildCount() >= 1 && this.isAttributesList((TNode)tNode.getChildAt(0));
        }

        boolean isAttributesList(TNode tNode) {
            return tNode.getUserObject().equals(XMLTreeEditPanel.ATTRIBUTES);
        }

        boolean isAttribute(TNode tNode) {
            TNode tNode2 = (TNode)tNode.getParent();
            return tNode2 != null && this.isAttributesList(tNode2) && tNode.getChildCount() == 0;
        }

        String getAttributeName(TNode tNode) {
            String[] stringArray = this.parseAttribute(tNode);
            return stringArray[0];
        }

        String getAttributeValue(TNode tNode) {
            String[] stringArray = this.parseAttribute(tNode);
            return stringArray[1];
        }

        TNode getAttributeContainingObjectNode(TNode tNode) {
            Debug.expect(this.isAttribute(tNode));
            TNode tNode2 = (TNode)tNode.getParent().getParent();
            if (tNode2 == null) {
                throw this.syntaxError(tNode, "Attribute outside object");
            }
            return tNode2;
        }

        boolean isAtomicValue(TNode tNode) {
            return tNode.getChildCount() == 1 && !this.isAttributesList(tNode) && !this.isAttributesList((TNode)tNode.getChildAt(0)) && this.looksLikeDataValue((TNode)tNode.getChildAt(0));
        }

        boolean isTextWithAttributes(TNode tNode) {
            return tNode.getChildCount() == 2 && this.isAttributesList((TNode)tNode.getChildAt(0)) && this.looksLikeDataValue((TNode)tNode.getChildAt(1));
        }

        boolean looksLikeDataValue(TNode tNode) {
            return tNode.getChildCount() == 0 && tNode.getNamespace() == Namespace.NO_NAMESPACE;
        }

        InvalidNode syntaxError(TNode tNode, String string) {
            TreePath treePath = tNode.getTreePath();
            XMLTreeEditPanel.this.docTree.scrollPathToVisible(treePath);
            XMLTreeEditPanel.this.docTree.setSelectionPath(treePath);
            return new InvalidNode(string);
        }
    }

    class TNodeFactory {
        TNodeFactory() {
        }

        TNode nodeFrom(Document document) {
            return this.nodeFrom(document.getRootElement());
        }

        TNode nodeFrom(Element element) {
            TNode tNode = new TNode(element.getName());
            tNode.setNamespace(element.getNamespace());
            if (!element.getAttributes().isEmpty()) {
                tNode.add(this.makeAttributesNode(element));
            }
            if (element.getContent().isEmpty()) {
                return tNode;
            }
            if (element.getChildren().isEmpty()) {
                String string = element.getText();
                if (string != null && !string.equals("")) {
                    tNode.add(new TNode(string));
                }
                return tNode;
            }
            for (Element element2 : element.getChildren()) {
                tNode.add(this.nodeFrom(element2));
            }
            return tNode;
        }

        TNode makeAttributesNode(Element element) {
            TNode tNode = new TNode(XMLTreeEditPanel.ATTRIBUTES);
            for (Attribute attribute : element.getAttributes()) {
                String string = attribute.getName();
                String string2 = attribute.getValue();
                TNode tNode2 = new TNode(string + "=" + string2);
                tNode2.setNamespace(attribute.getNamespace());
                tNode.add(tNode2);
            }
            return tNode;
        }
    }

    class TNode
    extends DefaultMutableTreeNode {
        Namespace namespace;
        boolean shouldBeExpanded;
        String renderingText;

        TNode(Object object) {
            super(object);
            this.namespace = Namespace.NO_NAMESPACE;
            this.shouldBeExpanded = false;
            this.renderingText = null;
        }

        Namespace getNamespace() {
            return this.namespace;
        }

        void setNamespace(Namespace namespace) {
            XMLTreeEditPanel.this.noteNamespace(namespace);
            this.renderingText = null;
            this.namespace = namespace;
        }

        boolean shouldBeExpanded() {
            return this.shouldBeExpanded;
        }

        void setShouldBeExpanded(boolean bl) {
            this.shouldBeExpanded = bl;
        }

        void setSubtreeShouldBeExpanded(boolean bl) {
            Enumeration<TreeNode> enumeration = this.preorderEnumeration();
            while (enumeration.hasMoreElements()) {
                TNode tNode = (TNode)enumeration.nextElement();
                tNode.setShouldBeExpanded(bl);
            }
        }

        void expandSubtree(int n) {
            if (n >= 0) {
                this.setShouldBeExpanded(true);
                Enumeration<TreeNode> enumeration = this.children();
                while (enumeration.hasMoreElements()) {
                    TNode tNode = (TNode)enumeration.nextElement();
                    tNode.expandSubtree(n - 1);
                }
            }
        }

        public TreePath getTreePath() {
            return new TreePath(this.getPath());
        }

        public void setUserObject(Object object) {
            Debug.noteln("Setting user object to", object);
            super.setUserObject(object);
        }

        TNode copySubtree() {
            TNode tNode = new TNode(this.getUserObject());
            tNode.namespace = this.namespace;
            tNode.shouldBeExpanded = this.shouldBeExpanded;
            Enumeration<TreeNode> enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                TNode tNode2 = (TNode)enumeration.nextElement();
                tNode.add(tNode2.copySubtree());
            }
            return tNode;
        }
    }

    class ObjTNode
    extends TNode {
        ObjTNode(String string) {
            super(string);
            this.setNamespace(XMLTreeEditPanel.this.syntax.xmlt().getHomeNamespace());
        }
    }

    class InvalidCommand
    extends RuntimeException {
        InvalidCommand(String string) {
            super(string);
        }
    }
}

