/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.BufferPipe;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.Pattern;
import com.hp.hpl.jena.graph.query.PatternCompiler;
import com.hp.hpl.jena.graph.query.PatternStageCompiler;
import com.hp.hpl.jena.graph.query.Pipe;
import com.hp.hpl.jena.graph.query.Stage;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class PatternStage
extends Stage {
    protected Graph graph;
    protected Pattern[] compiled;
    private static final PatternCompiler compiler = new PatternStageCompiler();

    public PatternStage(Graph graph, Mapping mapping, Triple[] tripleArray) {
        this.graph = graph;
        this.compiled = this.compile(mapping, tripleArray);
    }

    protected Pattern[] compile(Mapping mapping, Triple[] tripleArray) {
        return this.compile(compiler, mapping, tripleArray);
    }

    protected Pattern[] compile(PatternCompiler patternCompiler, Mapping mapping, Triple[] tripleArray) {
        return PatternStageCompiler.compile(patternCompiler, mapping, tripleArray);
    }

    public Pipe deliver(final Pipe pipe) {
        final Pipe pipe2 = this.previous.deliver(new BufferPipe());
        new Thread(){

            public void run() {
                PatternStage.this.run(pipe2, pipe);
            }
        }.start();
        return pipe;
    }

    protected void run(Pipe pipe, Pipe pipe2) {
        while (this.stillOpen && pipe.hasNext()) {
            this.nest(pipe2, pipe.get(), 0);
        }
        pipe2.close();
    }

    protected void nest(Pipe pipe, Domain domain, int n) {
        if (n == this.compiled.length) {
            pipe.put(domain.copy());
        } else {
            Pattern pattern = this.compiled[n];
            ExtendedIterator extendedIterator = this.graph.find(pattern.asTripleMatch(domain));
            while (this.stillOpen && extendedIterator.hasNext()) {
                if (!pattern.match(domain, (Triple)extendedIterator.next())) continue;
                this.nest(pipe, domain, n + 1);
            }
            extendedIterator.close();
        }
    }
}

