/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.TripleSorter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SimpleTripleSorter
implements TripleSorter {
    private Triple[] result;
    private int putIndex;
    private Set bound;
    private List remaining;

    public SimpleTripleSorter() {
    }

    public Triple[] sort(Triple[] tripleArray) {
        return new SimpleTripleSorter(tripleArray).sort();
    }

    protected SimpleTripleSorter(Triple[] tripleArray) {
        this();
        this.bound = new HashSet();
        this.result = new Triple[tripleArray.length];
        this.remaining = new ArrayList<Triple>(Arrays.asList(tripleArray));
    }

    protected Triple[] sort() {
        while (this.remaining.size() > 0) {
            this.accept(this.findMostBinding(this.findLightest(this.remaining)));
        }
        return this.result;
    }

    protected void accept(Triple triple) {
        this.result[this.putIndex++] = triple;
        this.bind(triple);
        this.remaining.remove(triple);
    }

    protected List findLightest(List list) {
        ArrayList<Triple> arrayList = new ArrayList<Triple>();
        int n = 100;
        for (int i = 0; i < list.size(); ++i) {
            Triple triple = (Triple)list.get(i);
            int n2 = this.weight(triple);
            if (n2 < n) {
                arrayList.clear();
                arrayList.add(triple);
                n = n2;
                continue;
            }
            if (n2 != n) continue;
            arrayList.add(triple);
        }
        return arrayList;
    }

    protected Triple findMostBinding(List list) {
        int n = -1;
        Triple triple = null;
        for (int i = 0; i < list.size(); ++i) {
            Triple triple2 = (Triple)list.get(i);
            int n2 = this.bindingCount(triple2);
            if (n2 <= n) continue;
            triple = triple2;
            n = n2;
        }
        return triple;
    }

    protected int bindingCount(Triple triple) {
        int n = 0;
        for (int i = 0; i < this.remaining.size(); ++i) {
            Triple triple2 = (Triple)this.remaining.get(i);
            if (triple2 == triple) continue;
            n += this.bindingCount(triple, triple2);
        }
        return n;
    }

    protected int bindingCount(Triple triple, Triple triple2) {
        return this.bindingCount(triple.getSubject(), triple2) + this.bindingCount(triple.getPredicate(), triple2) + this.bindingCount(triple.getObject(), triple2);
    }

    protected int bindingCount(Node node, Triple triple) {
        return node.isVariable() ? this.bc(node, triple.getSubject()) + this.bc(node, triple.getPredicate()) + this.bc(node, triple.getObject()) : 0;
    }

    protected int bc(Node node, Node node2) {
        return node.equals(node2) ? 1 : 0;
    }

    protected void bind(Triple triple) {
        this.bind(triple.getSubject());
        this.bind(triple.getPredicate());
        this.bind(triple.getObject());
    }

    protected void bind(Node node) {
        if (node.isVariable()) {
            this.bound.add(node);
        }
    }

    protected int weight(Triple triple) {
        return this.weight(triple.getSubject()) + this.weight(triple.getPredicate()) + this.weight(triple.getObject());
    }

    protected int weight(Node node) {
        return node.isConcrete() ? 0 : (node.equals(Node.ANY) ? 5 : (this.bound.contains(node) ? 1 : 4));
    }
}

