/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.builtins;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.BuiltinException;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;

public class Remove
extends BaseBuiltin {
    public String getName() {
        return "remove";
    }

    public void headAction(Node[] nodeArray, int n, RuleContext ruleContext) {
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            ClauseEntry clauseEntry;
            Node node = nodeArray[i];
            if (Util.isNumeric(node)) {
                int n2 = Util.getIntValue(node);
                clauseEntry = ruleContext.getRule().getBodyElement(n2);
                if (!(clauseEntry instanceof TriplePattern)) {
                    throw new BuiltinException(this, ruleContext, "illegal triple to remove non-triple clause");
                }
            } else {
                throw new BuiltinException(this, ruleContext, "illegal arg to remove (" + node + "), must be an integer");
            }
            Triple triple = ruleContext.getEnv().instantiate((TriplePattern)clauseEntry);
            ruleContext.remove(triple);
        }
    }
}

