/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.util.PrintUtil;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.ByteArrayInputStream;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestBugs
extends TestCase {
    public static final String INPUT_SUBCLASS = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><rdf:RDF    xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"    xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\"    xmlns:daml=\"http://www.daml.org/2001/03/daml+oil#\"    xmlns:ex=\"http://localhost:8080/axis/daml/a.daml#\"    xml:base=\"http://localhost:8080/axis/daml/a.daml\">     <daml:Ontology rdf:about=\"\">        <daml:imports rdf:resource=\"http://www.daml.org/2001/03/daml+oil\"/>    </daml:Ontology>     <daml:Class rdf:ID=\"cls1\"/>    <daml:Class rdf:ID=\"cls2\">        <daml:subClassOf rdf:resource=\"#cls1\"/>    </daml:Class>    <ex:cls2 rdf:ID=\"test\"/></rdf:RDF>";
    public static final String INPUT_SUBPROPERTY = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><rdf:RDF    xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"    xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\"    xmlns:daml=\"http://www.daml.org/2001/03/daml+oil#\"    xmlns=\"urn:x-hp-jena:test#\"    xml:base=\"urn:x-hp-jena:test\">     <daml:Ontology rdf:about=\"\">        <daml:imports rdf:resource=\"http://www.daml.org/2001/03/daml+oil\"/>    </daml:Ontology>     <daml:Class rdf:ID=\"A\"/>    <daml:ObjectProperty rdf:ID=\"p\" />    <daml:ObjectProperty rdf:ID=\"q\">        <daml:subPropertyOf rdf:resource=\"#p\"/>    </daml:ObjectProperty>    <A rdf:ID=\"a0\"/>    <A rdf:ID=\"a1\">       <q rdf:resource=\"#a0\" />    </A></rdf:RDF>";
    static /* synthetic */ Class class$com$hp$hpl$jena$reasoner$rulesys$test$TestBugs;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntResource;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntClass;

    public TestBugs(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$reasoner$rulesys$test$TestBugs == null ? (class$com$hp$hpl$jena$reasoner$rulesys$test$TestBugs = TestBugs.class$("com.hp.hpl.jena.reasoner.rulesys.test.TestBugs")) : class$com$hp$hpl$jena$reasoner$rulesys$test$TestBugs);
    }

    public void testIntersectionNPE() {
        Model model = ModelFactory.createDefaultModel();
        model.read("file:testing/reasoners/bugs/bad-intersection.owl");
        boolean bl = false;
        try {
            InfGraph infGraph = ReasonerRegistry.getOWLReasoner().bind(model.getGraph());
            ExtendedIterator extendedIterator = infGraph.find(null, RDF.Nodes.type, OWL.Class.asNode());
            extendedIterator.close();
        }
        catch (ReasonerException reasonerException) {
            bl = true;
        }
        TestBugs.assertTrue((String)"Correctly detected the illegal list", (boolean)bl);
    }

    public void testCardinality1() {
        Model model = ModelFactory.createDefaultModel();
        model.read("file:testing/reasoners/bugs/cardFPTest.owl");
        InfModel infModel = ModelFactory.createInfModel(ReasonerRegistry.getOWLReasoner(), model);
        String string = "urn:foo#";
        Resource resource = infModel.getResource(string + "aDocument");
        Resource resource2 = infModel.getResource(string + "Document");
        TestBugs.assertTrue((String)"Cardinality-based classification", (boolean)infModel.contains(resource, RDF.type, resource2));
    }

    public void testFunctorCCE() {
        Model model = ModelFactory.createDefaultModel();
        model.read("file:testing/reasoners/bugs/cceTest.owl");
        InfModel infModel = ModelFactory.createInfModel(ReasonerRegistry.getOWLReasoner(), model);
        boolean bl = this.anyInstancesOfNothing(infModel);
        ResIterator resIterator = infModel.listSubjects();
        while (resIterator.hasNext()) {
            Resource resource = resIterator.nextResource();
        }
    }

    private boolean anyInstancesOfNothing(Model model) {
        boolean bl = false;
        try {
            StmtIterator stmtIterator = model.listStatements(null, RDF.type, OWL.Nothing);
            bl = stmtIterator.hasNext();
            stmtIterator.close();
        }
        catch (ConversionException conversionException) {
            bl = false;
        }
        return bl;
    }

    public void testDAMLCCE() {
        DAMLModel dAMLModel = ModelFactory.createDAMLModel();
        dAMLModel.read("file:testing/reasoners/bugs/literalLeak.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        ResIterator resIterator = dAMLModel.listSubjects();
        while (resIterator.hasNext()) {
            Resource resource = resIterator.nextResource();
            if (!resource.getNode().isLiteral()) continue;
            TestBugs.assertTrue((String)("Error in resource " + resource), (boolean)false);
        }
    }

    public void testSubClass() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.DAML_MEM_RDFS_INF, null);
        String string = "http://localhost:8080/axis/daml/a.daml#";
        ontModel.read(new ByteArrayInputStream(INPUT_SUBCLASS.getBytes()), string);
        OntResource ontResource = (OntResource)ontModel.getResource(string + "test").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestBugs.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
        OntClass ontClass = (OntClass)ontModel.getResource(string + "cls1").as(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = TestBugs.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass);
        OntClass ontClass2 = (OntClass)ontModel.getResource(string + "cls2").as(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = TestBugs.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass);
        TestBugs.assertTrue((String)"cls2 should be a super-class of cls1", (boolean)ontClass2.hasSuperClass(ontClass));
        TestBugs.assertTrue((String)"res should have rdf:type cls1", (boolean)ontResource.hasRDFType(ontClass));
        TestBugs.assertTrue((String)"res should have rdf:type cls2", (boolean)ontResource.hasRDFType(ontClass2));
    }

    public void testSubProperty() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.DAML_MEM_RDFS_INF, null);
        String string = "urn:x-hp-jena:test#";
        ontModel.read(new ByteArrayInputStream(INPUT_SUBPROPERTY.getBytes()), string);
        OntResource ontResource = (OntResource)ontModel.getResource(string + "a0").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestBugs.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
        OntResource ontResource2 = (OntResource)ontModel.getResource(string + "a1").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestBugs.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
        ObjectProperty objectProperty = ontModel.getObjectProperty(string + "p");
        ObjectProperty objectProperty2 = ontModel.getObjectProperty(string + "q");
        TestBugs.assertTrue((String)"subProp relation present", (boolean)objectProperty2.hasProperty(RDFS.subPropertyOf, objectProperty));
        TestBugs.assertTrue((String)"a1 q a0", (boolean)ontResource2.hasProperty((Property)objectProperty2, ontResource));
        TestBugs.assertTrue((String)"a1 p a0", (boolean)ontResource2.hasProperty((Property)objectProperty, ontResource));
    }

    public void testEquivalentClass1() {
        Model model = ModelFactory.createDefaultModel();
        model.read("file:testing/reasoners/bugs/equivalentClassTest.owl");
        InfModel infModel = ModelFactory.createInfModel(ReasonerRegistry.getOWLReasoner(), model);
        String string = "urn:foo#";
        Resource resource = infModel.getResource(string + "A");
        Resource resource2 = infModel.getResource(string + "B");
        TestBugs.assertTrue((String)"hasValue equiv deduction", (boolean)infModel.contains(resource, OWL.equivalentClass, resource2));
    }

    private void tempList(Model model, Resource resource, Property property, RDFNode rDFNode) {
        System.out.println("Listing of " + PrintUtil.print(resource) + " " + PrintUtil.print(property) + " " + PrintUtil.print(rDFNode));
        StmtIterator stmtIterator = model.listStatements(resource, property, rDFNode);
        while (stmtIterator.hasNext()) {
            System.out.println(" - " + stmtIterator.next());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

