/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.compose.Union;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestRDFS9
extends TestCase {
    static /* synthetic */ Class class$com$hp$hpl$jena$reasoner$rulesys$test$TestRDFS9;

    public TestRDFS9(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$reasoner$rulesys$test$TestRDFS9 == null ? (class$com$hp$hpl$jena$reasoner$rulesys$test$TestRDFS9 = TestRDFS9.class$("com.hp.hpl.jena.reasoner.rulesys.test.TestRDFS9")) : class$com$hp$hpl$jena$reasoner$rulesys$test$TestRDFS9);
    }

    public void testRDFSInheritance() {
        Triple triple;
        Node node = Node.createURI("C1");
        Node node2 = Node.createURI("C2");
        Node node3 = Node.createURI("C3");
        Node node4 = Node.createURI("C4");
        Node node5 = Node.createURI("D");
        Node node6 = Node.createURI("a");
        Node node7 = Node.createURI("b");
        Node node8 = Node.createURI("p");
        Node node9 = Node.createURI("q");
        Node node10 = Node.createURI("r");
        Node node11 = RDFS.subClassOf.asNode();
        Node node12 = RDF.type.asNode();
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(node, node11, node2));
        graphMem.add(new Triple(node2, node11, node3));
        graphMem.add(new Triple(node8, RDFS.subPropertyOf.asNode(), node9));
        graphMem.add(new Triple(node9, RDFS.subPropertyOf.asNode(), node10));
        graphMem.add(new Triple(node10, RDFS.domain.asNode(), node5));
        GraphMem graphMem2 = new GraphMem();
        graphMem2.add(new Triple(node6, node8, node7));
        InfGraph infGraph = ReasonerRegistry.getRDFSReasoner().bind(new Union(graphMem, graphMem2));
        TestUtil.assertIteratorValues(this, infGraph.find(node6, node12, null), new Object[]{new Triple(node6, node12, node5), new Triple(node6, node12, RDFS.Resource.asNode())});
        boolean bl = false;
        Triple triple2 = new Triple(node6, node12, node5);
        ExtendedIterator extendedIterator = infGraph.find(null, node12, null);
        while (extendedIterator.hasNext()) {
            triple = (Triple)extendedIterator.next();
            if (!triple.equals(triple2)) continue;
            bl = true;
            break;
        }
        TestRDFS9.assertTrue((boolean)bl);
        infGraph = ReasonerRegistry.getRDFSReasoner().bindSchema(graphMem).bind(graphMem2);
        TestUtil.assertIteratorValues(this, infGraph.find(node6, node12, null), new Object[]{new Triple(node6, node12, node5), new Triple(node6, node12, RDFS.Resource.asNode())});
        bl = false;
        triple2 = new Triple(node6, node12, node5);
        extendedIterator = infGraph.find(null, node12, null);
        while (extendedIterator.hasNext()) {
            triple = (Triple)extendedIterator.next();
            if (!triple.equals(triple2)) continue;
            bl = true;
            break;
        }
        TestRDFS9.assertTrue((boolean)bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

