/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.test;

import com.hp.hpl.jena.mem.ModelMem;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.RDFSRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.test.WGReasonerTester;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.io.IOException;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;

public class TestCurrentRDFWG
extends TestCase {
    public static final String TEST_DIR = "testing/wg20030725/";
    protected static Logger logger = Logger.getLogger((Class)(class$com$hp$hpl$jena$reasoner$test$TestCurrentRDFWG == null ? (class$com$hp$hpl$jena$reasoner$test$TestCurrentRDFWG = TestCurrentRDFWG.class$("com.hp.hpl.jena.reasoner.test.TestCurrentRDFWG")) : class$com$hp$hpl$jena$reasoner$test$TestCurrentRDFWG));
    static /* synthetic */ Class class$com$hp$hpl$jena$reasoner$test$TestCurrentRDFWG;

    public TestCurrentRDFWG(String string) {
        super(string);
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite();
        try {
            Resource resource = new ModelMem().createResource().addProperty(ReasonerVocabulary.PROPenableCMPScan, true);
            resource.addProperty(ReasonerVocabulary.PROPtraceOn, true);
            TestCurrentRDFWG.constructRDFWGtests(testSuite, RDFSRuleReasonerFactory.theInstance(), null);
        }
        catch (IOException iOException) {
            logger.error((Object)"Failed to construct RDF WG test harness", (Throwable)iOException);
        }
        return testSuite;
    }

    private static void constructRDFWGtests(TestSuite testSuite, ReasonerFactory reasonerFactory, Resource resource) throws IOException {
        WGReasonerTester wGReasonerTester = new WGReasonerTester("Manifest.rdf", TEST_DIR);
        Iterator iterator = wGReasonerTester.listTests().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            testSuite.addTest((Test)new TestReasonerWG(wGReasonerTester, string, reasonerFactory, resource));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class TestReasonerWG
    extends TestCase {
        WGReasonerTester tester;
        String test;
        ReasonerFactory reasonerFactory;
        Resource config;

        TestReasonerWG(WGReasonerTester wGReasonerTester, String string, ReasonerFactory reasonerFactory, Resource resource) {
            super(string);
            this.tester = wGReasonerTester;
            this.test = string;
            this.reasonerFactory = reasonerFactory;
            this.config = resource;
        }

        public void runTest() throws IOException {
            this.tester.runTest(this.test, this.reasonerFactory, this, this.config);
        }
    }
}

