/* Author: Clauirton Siebra <c.siebra@ed.ac.uk>
 * Updated: Sun Nov 07 14:49:02 2004 by Clauirton Siebra
 * Copyright: (c) 2001-2003, AIAI, University of Edinburgh
 */

package ix.ip2.map;

import javax.swing.*;
import java.awt.event.*;
import java.awt.BorderLayout;
import java.util.*;

import ix.util.*;
import ix.util.lisp.*;
import ix.ip2.*;
import ix.icore.domain.PatternAssignment;
import ix.iface.util.CatchingActionListener;

/**
 * This class provides an editable frame on the map components that enables the edition of property values.  
 */
public class EditFrame extends JFrame implements ActionListener {

    JTextField valTF;
    StateViewer sv;
    Object obj,val,prop;

    /**
     * Creates a editable frame that displays the current value of a object property.
     * @param stateViewer reference to state viewer. Via state viewer we are able to pass new property values to the IP2 agent.
     * @param property property whose values will be changed.
     * @param object owner object of the property.
     * @param value current value of the property.
     */

    public EditFrame(StateViewer stateViewer, Object property, Object object, Object value, boolean enabled) {
        super(object.toString());
        sv    = stateViewer;
        prop  = property;
        obj   = object;
        val   = value;

        JPanel editP = new JPanel();
        JPanel buttonP = new JPanel();

        getContentPane().setLayout(new BorderLayout());
        getContentPane().add(editP,BorderLayout.CENTER);
        getContentPane().add(buttonP,BorderLayout.SOUTH);
    
        //JLabel label = new JLabel(Lisp.elementsToString((LList)prop)+ " = ");
        JLabel label = new JLabel(WorldStateLayer.addTilde(prop)+ " = ");
        editP.add(label);
        valTF= new JTextField(val.toString(),12);
	valTF.setEnabled(enabled);
        editP.add(valTF);

        JButton sendB = new JButton("Send");
        sendB.addActionListener(CatchingActionListener.listener(this));
        buttonP.add(sendB);

        JButton clearB = new JButton("Clear");
	clearB.setEnabled(enabled);
        clearB.addActionListener(CatchingActionListener.listener(this));
        buttonP.add(clearB);
    
        JButton cancelB = new JButton("Cancel");
        cancelB.addActionListener(CatchingActionListener.listener(this));
        buttonP.add(cancelB);

        setSize(350,110);
        setVisible(true);

        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                dispose();
            }
        });
    }

    /**
     * Controls the buttons' actions. Current buttons: Send, Clear and Cancel.
     * @param e action event generated by a button. 
     */
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        Debug.noteln("Map Tool action:", command);
        if (command.equals("Cancel")) {
            dispose();
        }
        else if (command.equals("Send")) {
            if (valTF.getText().equals("")) {
            sendConstraint(new PatternAssignment(WorldStateLayer.returnPattern(prop,obj),"true"));
        }
        else {
            try {
                sendConstraint(new PatternAssignment(WorldStateLayer.returnPattern(prop,obj),new Float(valTF.getText())));
            } catch (NumberFormatException nfe){    
                sendConstraint(new PatternAssignment(WorldStateLayer.returnPattern(prop,obj),Symbol.intern(valTF.getText())));
            }
        }
        dispose();
    }
    else if (command.equals("Clear")) {
        valTF.setText("");
        valTF.requestFocusInWindow();
    }
    else
        Debug.noteln("Nothing to do", command);
    }

    protected void sendConstraint(PatternAssignment pa) {
	if(sv instanceof ix.ip2.map.MapWhiteboard)
	    ((MapWhiteboard)sv).sendConstraint(pa);
	else
	   ((StateViewMap)sv).sendConstraint(pa);
    }

}
