/* Author: Clauirton Siebra
 * Updated: Thu May 15 12:05:11 2003 by Clauirton Siebra
 * Copyright: (c) 2001 - 2003, AIAI, University of Edinburgh
 */

package ix.ip2.map;

import com.bbn.openmap.omGraphics.OMRaster;

/**
 * Simple class that extends the OMRaster class, adding a attribute to represent the object.  
 */
public class ObjectImage extends OMRaster {

    private Object id;

    /**
     * Creates an image that represents an object and can be manipulated by the map tool.
     * @param lat object latitude.
     * @param lon object longitude.
     * @param icon icon that represents the object.
     * @param id object reference.
     */
     
    public ObjectImage(float lat, float lon, javax.swing.ImageIcon icon, Object id) {
        super(lat,lon,-icon.getIconWidth()/2,-icon.getIconHeight()/2,icon);
        this.id = id;
    }

    /**
     * Sets a object indentification to the image.
     * @param id object reference.
     */
    public void setName(Object id) {
        this.id = id;
    }

    /**
     * Returns the image object indentification.
     * @return the object reference.
     */
    public Object getName() {
        return id;
    }

    /**
     * Sets a object indentification to the image.
     * @return a latitude to place the object name. This method enables the use of images of any size.
     */
    public int getTextLat() {
        return (-getHeight()/2)-3;
    }


}
