/*
 * Thomas French, 05/03/07
 */

package ix.secondlife;
	
public class MessageCoordinator extends Thread {
    
    private GreeterAgent m_agent;

    private final int m_sleepTime = 1000; //in ms

    // Constructor
    public MessageCoordinator (GreeterAgent agent) {
	m_agent = agent;
    }
    
    public void run() {
	String nextMsg;
        
        try {
            
            // Main loop
            while(true)
            {
                // Get next msg if available and not waiting for reply.
		nextMsg = m_agent.getNextMessage();

                //System.out.println("Message1: " + nextMsg);

                if ( nextMsg == null )
                {
		    Thread.sleep(m_sleepTime); // So thread can be interrupted.
                    continue;
                }

                //System.out.println("Message2: " + nextMsg);

		m_agent.setWaitingResponse(true);

		// Start new thread to send message over xml-rpc. 
		(new MessageHandler(m_agent, nextMsg)).start();

	    } // Main loop
            
        } catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }
}
