package ix.secondlife;

import java.io.*;
import java.net.*;

public class MessageHandler extends Thread
{ 
  private GreeterAgent m_agent;
  
  private String m_msg;

  private boolean m_sentPoll = false;

  private HttpURLConnection m_connection;
  private OutputStream m_out;
  private InputStream m_in;
  
  public MessageHandler(GreeterAgent agent, String msg)
  {
    m_agent = agent;
    m_msg = msg;

    if ( msg.equals("poll") ) m_sentPoll = true;
  }
  
  public void run()
  {
    try{
      // Open URL connection to xml-rpc server.
      URL u = new URL(m_agent.getXMLRPCServer());
      URLConnection uc = u.openConnection();
      m_connection = (HttpURLConnection) uc;
      m_connection.setDoOutput(true);
      m_connection.setDoInput(true); 
      m_connection.setRequestMethod("POST");
      m_connection.setUseCaches(false);
      m_connection.setRequestProperty("Content-Type", 
				    "application/x-www-form-urlencoded");
      
      // Handle output stream.
      m_out = m_connection.getOutputStream();
      OutputStreamWriter wout = new OutputStreamWriter(m_out, "UTF-8");
      
      String msg = XMLRPCEnvelopeBuilder.getInstance().buildMessage
	(m_agent.getObjectUID(), m_msg);
      
      wout.write(msg);
      wout.flush();
      
      if ( !m_sentPoll ) m_agent.outputText("SENT: " + m_msg);

      // Handle input stream
      m_in = m_connection.getInputStream();
      int c;
      StringBuffer returnMsg = new StringBuffer();
      while ((c = m_in.read()) != -1) returnMsg.append((char) c);
      
      // Set no longer waiting for response.
      m_agent.setWaitingResponse(false);
      
      // Process reply.
      String returnReport = XMLRPCEnvelopeBuilder.getInstance().
	extractString(returnMsg.toString());
      
      // If poll message reply is null, send another one.
      if ( returnReport == null )
      {
	  m_agent.sendPollMessage();
      }
      // check if it is a world-state constraint
      else if (XMLRPCEnvelopeBuilder.isConstraint(returnReport)) {
	String strConstraint = 
	  returnReport.replaceFirst(XMLRPCEnvelopeBuilder.STATE_CONSTRAINT,"");
	m_agent.outputText("RECEIVED CONSTRAINT: " + strConstraint);
	//System.out.println("Constraint: " + strConstraint);
	m_agent.sendConstraint(strConstraint);    
      }
      else // Send progress report.
      {
          if ( m_sentPoll ) // reply is progress report
          {
              m_agent.sendProgressReport(returnReport);    
          }
          else
          {
              m_agent.sendCompletionReport(returnReport);
          }
      }
    }
    catch (Exception e)
      {
	System.err.println(e.getMessage());
	e.printStackTrace();
      }
    finally
    {
        try{
            if ( m_in != null ) m_in.close();
            if ( m_out != null ) m_out.close();
        }catch(IOException ioe){}
        if ( m_connection != null ) m_connection.disconnect();
    }
  }  
}