package ix.secondlife;

public class XMLRPCEnvelopeBuilder
{
    private static XMLRPCEnvelopeBuilder m_instance = null;

    private static String PROGRESS_REPORT = "detected visitor ";
    private static String COMPLETION_REPORT = "greeted visitor ";
    private static String STARTED_ACTIVITY = "started ";
    private static String STOPPED_ACTIVITY = "stopped ";
    //private static String STARTED_ACTIVITY = "started greeting";
    //private static String STOPPED_ACTIVITY = "stopped greeting";
    //private static String STARTED_FIRE = "started fire";
    //private static String STOPPED_FIRE = "stopped fire";
    protected static String STATE_CONSTRAINT = "state-constraint "; 
    private static String NULL_MESSAGE = "null";
    private static String TIMEOUT_MESSAGE = "Script timeout";

    // Private constructor - use singleton pattern
    private XMLRPCEnvelopeBuilder(){}

    public static XMLRPCEnvelopeBuilder getInstance()
    {
	if ( m_instance == null ) m_instance = new XMLRPCEnvelopeBuilder();

	return m_instance;
    }

    // Build XML-RPC message.
    public String buildMessage(String object_id, String msg)
    {
	StringBuffer msgbf = new StringBuffer();
	int intValue = 32; // not sure what this is for?

	msgbf.append("<?xml version=\"1.0\"?>\r\n");  
	msgbf.append("<methodCall>\r\n"); 
	msgbf.append("<methodName>llRemoteData</methodName>\r\n");
	msgbf.append("<params>\r\n"); 
	msgbf.append("<param>\r\n"); 
	msgbf.append("<value><struct>");
	
	msgbf.append("<member>");
	msgbf.append("<name>Channel</name>");
	msgbf.append("<value><string>" + object_id  + "</string></value>");
	msgbf.append("</member>");
	
	msgbf.append("<member>");
	msgbf.append("<name>IntValue</name>");
	msgbf.append("<value><int>"+ intValue +"</int></value>");
	msgbf.append("</member>");
	
	msgbf.append("<member>");
	msgbf.append("<name>StringValue</name>");
	msgbf.append("<value><string>"+ msg +"</string></value>");
	msgbf.append("</member>");
	
	msgbf.append("</struct></value>\r\n");
	msgbf.append("</param>\r\n"); 
	msgbf.append("</params>\r\n"); 
	msgbf.append("</methodCall>\r\n"); 
	
	return msgbf.toString();
    }
    
    // Process reply from SL.
    // Hack. Should probably process as XML. But too time consuming.
    public String extractString(String result)
    {
	// Null message, no progress reports to send back
	if ( result.indexOf(NULL_MESSAGE) != -1 )
        {
            //System.out.println("Received message: null");
            return null;
        }
        else if ( result.indexOf(TIMEOUT_MESSAGE) != -1 )
        {
            //System.out.println("Received message: timeout");
            return null;
        }
	/*
	else if ( result.indexOf(STARTED_ACTIVITY) != -1 )
        {
            return STARTED_ACTIVITY;
        }
	else if ( result.indexOf(STOPPED_ACTIVITY) != -1 )
        {
            return STOPPED_ACTIVITY;
        }
	*/
	else if ( result.indexOf(STARTED_ACTIVITY) != -1 )
        {
            int i = result.indexOf(STARTED_ACTIVITY);
            String r = result.substring(i, result.indexOf("<", i)); 
            return r;
        }
	else if ( result.indexOf(STOPPED_ACTIVITY) != -1 )
        {
            int i = result.indexOf(STOPPED_ACTIVITY);
            String r = result.substring(i, result.indexOf("<", i)); 
            return r;
        }
	else if ( result.indexOf(PROGRESS_REPORT) != -1 )
        {
            int i = result.indexOf(PROGRESS_REPORT);
            String r = result.substring(i, result.indexOf("<", i)); 
            return r;
        }
	else if ( result.indexOf(STATE_CONSTRAINT) != -1 )
        {
            int i = result.indexOf(STATE_CONSTRAINT);
            String r = result.substring(i, result.indexOf("<", i)); 
            return r;
        }
	else if ( result.indexOf(COMPLETION_REPORT) != -1 )
        {
            int i = result.indexOf(COMPLETION_REPORT);
            String r = result.substring(i, result.indexOf("<", i)); 
            return r;
        }
        
	//System.out.println("Not recognised message: " + result);

	return null;
    }
    protected static boolean isConstraint(String report) {
	return report.indexOf(STATE_CONSTRAINT) != -1;
    }
}