// Greeting - script handles main behaviour for robot
// This includes: sensing avatars and issuing greetings 
//
// Jussi Aya and Ai Austin 18-Jan-2008

// Based on script by AITommy Jannings 29-May-2007

// If XML-RPC Channel Id is needed to be used in this script then
// this script must be started before GreetingComms script is started.

// Jussi, 17-Jan-208: changed the default state to still process action
// requests from I-X to make sure I-X does not get stuck waiting for an
// answer that will not come.

// Ai, 18-Jan-2008: touches by owner (with any group set) or a member of
// same group as object will start/stop the Greeter

//--- Global variables ----------

// Labels for on and off state
string OFF_LABEL = "I-X Greeter (off)";
string ON_LABEL = "I-X Greeter";

// I-X activities
string START_ACTIVITY = "start greeting";
string STOP_ACTIVITY = "stop greeting";
string PROGRESS_REPORT = "detected visitor ";
string COMPLETION_REPORT = "greeted visitor ";
string STARTED_ACTIVITY = "started greeting";
string STOPPED_ACTIVITY = "stopped greeting";
string STARTED_ALREADY = "started greeting";  // same message as already handled by java end
string STOPPED_ALREADY = "stopped greeting";  // same message as already handled by java end
string STATE_CONSTRAINT = "state-constraint ";

// Demonstration using an object listening on a given channel for commands

integer EFFECTS_CHANNEL = 99;
string START_FIRE = "start fire";
string STARTED_FIRE = "started fire";
string STOP_FIRE = "stop fire";
string STOPPED_FIRE = "stopped fire";
string EFFECTS_ON = "Fire On";
string EFFECTS_OFF = "Fire Off";

// Currently detected avatar
string avatarname;

// List of all visitors greeted
list visitors;

// Scan frequency (seconds)
float SCAN_FREQ = 10.0;
integer RANGE = 10;

// Communication channel ID
key RPCChannelID;
string CHANNEL_ID_MESSAGE = "cid";

//---------- Functions ---------------------

// Turn on behaviour - reply to activity?
turn_on(integer reply)
{
    // Start spinning
    llTargetOmega(<0.0,0.0,1.0>, -1.5, 1.0);
        
    // Set on label
    llSetText(ON_LABEL, <1.0,1.0,1.0>, 1);
    
    if ( reply == TRUE )
    {
        // Reply with STARTED_ACTIVITY message.
        llMessageLinked(LINK_THIS, 1, STARTED_ACTIVITY, NULL_KEY);
    }
}

// Turn off behaviour
turn_off()
{
    // Rotation and off text are actually set in state entry handler for default (off) state anyway
    // No rotation
    // llTargetOmega(<0.0,0.0,0.0>, 0, 0.0);
    // Set off label
    // llSetText(OFF_LABEL, <1.0,1.0,1.0>, 1);
        
    // Report back that activity is stopped
    llMessageLinked(LINK_THIS, 1, STOPPED_ACTIVITY, NULL_KEY);   
}

start_fire(integer reply) {
    llSay(EFFECTS_CHANNEL, EFFECTS_ON);
    
    if ( reply )
    {
        // Reply with STARTED_FIRE message.
        llMessageLinked(LINK_THIS, 1, STARTED_FIRE, NULL_KEY);
    }
}

stop_fire(integer reply) {
    llSay(EFFECTS_CHANNEL, EFFECTS_OFF);
    
    if ( reply )
    {
        // Reply with STARTED_FIRE message.
        llMessageLinked(LINK_THIS, 1, STOPPED_FIRE, NULL_KEY);
    }
}

//-------------- States -----------------

// Entry state for script. Wait to be switched on.  Acts also as off state
default
{
    state_entry()
    {
        // Set off label
        llSetText(OFF_LABEL, <1.0,1.0,1.0>, 1);
        
        // No rotation
        llTargetOmega(<0.0,0.0,0.0>, 0, 0.0);
        
        // Always start with empty list of visitors.
        visitors = [];
    }
    
    on_rez(integer start_param) {
        // every time we're rezzed, reset the script
        // this ensures that all local variables are set afresh
        llResetScript();
    }
    
    link_message(integer sender_num, integer num, string strValue, key id)
    {
        if ( strValue == START_ACTIVITY )
        {
            turn_on(TRUE);

            // Transition to sensing state
            state sensing;   
        }
        else if ( strValue == STOP_ACTIVITY )
        {
            // already off - just report this back
            llMessageLinked(LINK_THIS, 1, STOPPED_ALREADY, NULL_KEY);  
               
        }
        else if ( llSubStringIndex( strValue, CHANNEL_ID_MESSAGE ) == 0 )
        {
            integer cid_len = llStringLength(CHANNEL_ID_MESSAGE);
            integer str_len = llStringLength(strValue);
            RPCChannelID = llGetSubString(strValue, cid_len, str_len - 1);
        }
        //JS: 17/1/08
        //these next two bits help I-X not to get stuck
        else if ( strValue == START_FIRE ) 
        {
            start_fire(1);
        }
        else if ( strValue == STOP_FIRE ) 
        {
            stop_fire(1);
        }
    }
    
    // Start robot behaviour by touching it, 
    // if one of the touches is in same group as object or is owner of object
    touch_start(integer num)

    {
        integer x = 0;
        for(; x < num; x++)
        {
            key agent = llDetectedKey(x);
            if ( llSameGroup(agent) || (agent == llGetOwner()) )
            {
                turn_on(FALSE);
                  
                if (RPCChannelID) {
                    llInstantMessage(agent, "Communication channel key is: " 
                        + (string) RPCChannelID);
                }
                else { //no valid channel ID, get comms to say it!
                    llMessageLinked(LINK_THIS, 2, CHANNEL_ID_MESSAGE, NULL_KEY);
                
                }              
                
                state sensing;    
            }
        }
    }
}

// Sense surrounding area and greet new visitors.
state sensing
{
    state_entry()
    {
        // Repeatedly sense every 20secs for 10mts for avatars.
        llSensorRepeat( "", "", AGENT, RANGE, PI, SCAN_FREQ );
    }
    
    sensor(integer total_number)
    {  
        integer i = 0;    
        for(; i < total_number; i++)
        {
            // Find a new victim.
            avatarname = llDetectedName(i);
            
            integer index = llListFindList( visitors, [avatarname] );

            // Only greet new visitors.
            if ( index == -1 )
            {
                // Stop sensing for avatars
                llSensorRemove();
                
                // Greet visitor!
                llSay(0, "Hello, " + avatarname + ", welcome!");
                
                // Send activity progress report
                //llMessageLinked(LINK_THIS, 0, PROGRESS_REPORT+avatarname, NULL_KEY);
                
                // Add victim to list of visitors
                visitors += [avatarname]; 
                
                //tell I-X about the arrival by updating state
                llMessageLinked(LINK_THIS, 0, 
                    STATE_CONSTRAINT+"has-visited \""+avatarname+"\" = true", NULL_KEY);

            }
        }
    }
    
    link_message(integer sender_num, integer num, string strValue, key id)
    {
        if ( strValue == STOP_ACTIVITY ) 
        {
            turn_off();
            
            // Transition back to initial (off) state
            state default;
        }
        else if ( strValue == START_ACTIVITY )
        {
            // already on - just report this back
            llMessageLinked(LINK_THIS, 1, STARTED_ALREADY, NULL_KEY);  
               
        }
        else if ( strValue == START_FIRE ) 
        {
            start_fire(1);
        }
        else if ( strValue == STOP_FIRE ) 
        {
            stop_fire(1);
        }
    }
    
    // Stop robot behaviour by touching it, 
    // if one of the touches is in same group as object.
    touch_start(integer num)
    {
        integer x = 0;
        for(; x < num; x++)
        {
            key agent = llDetectedKey(x);
            if ( llSameGroup(agent) || (agent == llGetOwner()) )         
            {
                //turn_off(); // not necessary, not replying to activity.
                  
                state default;    
            }
        }
    }
}

