// Greeting - Comms script handles all communications for Greeter Robot.
// This includes XML-RPC comms from IX-Agent.
//
// Jussi Aya and Ai Austin 15-Jan-2008
// Based on script by AITommy Jannings 29-May-2007

// If XML-RPC Channel Id is needed to be used in the Greeting script then
// this script must be started bafter Greeting script is started.

//--- Global variables ----------

// Communication channel id 
key channelID;
string CHANNEL_ID_MESSAGE = "cid";

string NULL_MESSAGE = "null";
string POLL_MESSAGE = "poll";

list reports = [];

//-------------------------------

// Entry state for script.
// Handles all communication for greeter robot.

default
{
    state_entry()
    {
        // Open remote data channel   
        llOpenRemoteDataChannel(); 
    }

    on_rez(integer start_param) {
        // every time we're rezzed, reset the script
        // this ensures that all local variables are set afresh
        llResetScript();
    }
    
    remote_data(integer type, key channel, key uid, string from, integer
        intValue, string strValue) { 
        
        if (type == REMOTE_DATA_CHANNEL) 
        {
            channelID = channel;
            //llOwnerSay("Communication channel open, with key: "+(string)channelID);
            
            // Send channel id to Greeting script
            llMessageLinked(LINK_THIS, -1, CHANNEL_ID_MESSAGE+(string)channelID, NULL_KEY);
        }
        else if ( type == REMOTE_DATA_REQUEST ) 
        {
            if ( strValue == POLL_MESSAGE )
            {
                // Have report to send back? 
                if ( llGetListLength(reports) > 0)
                {
                    // More efficient to send multiple msgs if available.
                    llRemoteDataReply(channelID, NULL_KEY, llList2String(reports,0), 1);
                    reports = llDeleteSubList(reports, 0,0);
                }
                else
                {
                    // No report to send back. Reply with null message.
                    llRemoteDataReply(channelID, NULL_KEY, NULL_MESSAGE, 1);     
                }
            }
            else
            {
                // Not poll message, re-route to greeter robot. 
                // -1 identifies that this script sent message.
                llMessageLinked(LINK_THIS, -1, strValue, NULL_KEY);
            }
        }
    }

    // Handle messages sent from Greeting script.
    link_message(integer sender_num, integer num, string str, key id)
    {
        // Messages sent by this scripts are tagged with -1.
        if ( num != -1 )
        {
            // Message is a reply to a request.
            if ( num == 1 )
            {
                llRemoteDataReply(channelID, NULL_KEY, str, 1);
            }
            else if ( num == 2 ) //CID has not made it to Greeting script! 
            {
                llWhisper(0, "Comms: channel id is: "+(string)channelID);
            }
            else

            {
                //llSay(DEBUG_CHANNEL, "sending "+str);
                // Add to list of reports to send back.
                reports += [str];
            }
        }  
    }
}
