/* Author: Stuart Aitken & Stephen Potter
 * Last Updated: Wed Sep 24 16:36:22 2003
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.jabber;

import java.awt.*;
import java.util.*;
import java.awt.event.*;
import javax.swing.*;


public class UserPassword extends JDialog {

    JLabel l, l1, l2, l3, l4, l5, s, pl;
    JButton e,c;
    JPanel p, q, pp;
    JTextField s1, f1, r1, p1;
    JPasswordField f2;
    JCheckBox na, as;
    JSlider pr;

    
    public UserPassword(Frame parent, String title){
	super(parent,title,false);
	init(parent, title, "", "", "", "", "", "",1,true);
    }
    

    public UserPassword(Frame parent, String title, String username, String password, String server, String resource, String port){
	super(parent,title,false);
	init(parent,title,username,password,server,resource,port, "Please enter your Jabber login details:",1,true);
    }
    
    public UserPassword(Frame parent, String title, String username, String password, String server, String resource, String port, String status, int priority, boolean autosub){
	super(parent,title,false);
	init(parent,title,username,password,server,resource,port,status,priority,autosub);
    }
    

    public void init(Frame parent, String title, String username, String password, String server, String resource, String port, String status, int priority, boolean autosub){
      
      this.getContentPane().setLayout(new BorderLayout(15,15));
      //this.setModal(true);

      GridBagLayout gridbag = new GridBagLayout();
      //s = new JPanel();
      p = new JPanel();
      q = new JPanel();
      pp = new JPanel();
      //s.setLayout(gridbag);
      p.setLayout(gridbag);
      q.setLayout(gridbag);
      pp.setLayout(gridbag);

      s = new JLabel(status);
     

      l1 = new JLabel("Username:", SwingConstants.LEFT);
      l2 = new JLabel("Password:", SwingConstants.LEFT);
      l3 = new JLabel("Host:", SwingConstants.LEFT);
      l4 = new JLabel("Resource:", SwingConstants.LEFT);
      l5 = new JLabel("Port:", SwingConstants.LEFT);
      f1 = new JTextField(username, 20);
      f2 = new JPasswordField(password, 20);
      s1 = new JTextField(server, 20);
      r1 = new JTextField(resource, 20);
      p1 = new JTextField(port, 20);

      na = new JCheckBox("New account");
      as = new JCheckBox("Auto-subscribe",autosub);
      // JSpinner removed, as it is not compatible with pre-1.4 Javas:
      //pr = new JSpinner(new SpinnerNumberModel(priority, 0, 100, 1)); // initial,min,max,step
      pr = new JSlider(JSlider.HORIZONTAL, 0, 20, priority); // min,max,intital


      pr.setMajorTickSpacing(5);
      pr.setMinorTickSpacing(1);
      pr.setPaintTicks(true);
      pr.setPaintLabels(true);
      pr.setSnapToTicks(true);
      pr.setMinimumSize(new Dimension(200,50));
      //pr.setBorder(BorderFactory.createEmptyBorder(0,0,10,0));
      pl = new JLabel("Priority",SwingConstants.LEFT);

      //System.out.println((pr.getEditor()).toString());
      e = new JButton(" Login ");
      c = new JButton("Cancel");

      //      e.setSize(50,10);
      //      c.setSize(50,10);

      constrain(p,l1,0,0,1,1,GridBagConstraints.BOTH,
          GridBagConstraints.NORTH, 0.0, 0.0, 1,1,1,1);
      //      constrain(p,f1,0,1,GridBagConstraints.REMAINDER,1,GridBagConstraints.BOTH,
      //    GridBagConstraints.NORTH, 0.0, 0.0, 1,1,1,1);
      constrain(p,f1,0,1,1,1,GridBagConstraints.BOTH,
          GridBagConstraints.NORTH, 0.0, 0.0, 1,1,1,1);

      constrain(p,l2,0,2,1,1,GridBagConstraints.BOTH,
          GridBagConstraints.NORTH, 0.0, 0.0, 1,1,1,1);
      constrain(p,f2,0,3,1,1,GridBagConstraints.BOTH,
          GridBagConstraints.NORTH, 0.0, 0.0, 1,1,1,1);

      constrain(p,l3,0,4,1,1,GridBagConstraints.BOTH,
          GridBagConstraints.NORTH, 0.0, 0.0, 1,1,1,1);
      constrain(p,s1,0,5,1,1,GridBagConstraints.BOTH,
          GridBagConstraints.NORTH, 0.0, 0.0, 1,1,1,1);

      constrain(p,l5,0,6,1,1,GridBagConstraints.BOTH,
          GridBagConstraints.NORTH, 0.0, 0.0, 1,1,1,1);
      constrain(p,p1,0,7,1,1,GridBagConstraints.BOTH,
          GridBagConstraints.NORTH, 0.0, 0.0, 1,1,1,1);

      constrain(p,l4,0,8,1,1,GridBagConstraints.BOTH,
          GridBagConstraints.NORTH, 0.0, 0.0, 1,1,1,1);
      constrain(p,r1,0,9,1,1,GridBagConstraints.BOTH,
          GridBagConstraints.NORTH, 0.0, 0.0, 1,1,1,1);

      constrain(p,na,0,10,1,1,GridBagConstraints.BOTH,
          GridBagConstraints.NORTH, 0.0, 0.0, 1,1,1,1);
      constrain(p,as,0,11,1,1,GridBagConstraints.BOTH,
          GridBagConstraints.NORTH, 0.0, 0.0, 1,1,1,1);

      // constrain(p,pl,0,12,GridBagConstraints.RELATIVE,1,GridBagConstraints.NONE,
      //   GridBagConstraints.NORTHEAST, 1.0, 0.0, 1,1,1,1);
      constrain(pp,pl,0,0,1,1,GridBagConstraints.NONE,
          GridBagConstraints.NORTHEAST, 1.0, 0.0, 1,1,1,1);
      constrain(pp,pr,1,0,1,1,GridBagConstraints.NONE,
          GridBagConstraints.NORTHWEST, 0.0, 0.0, 1,1,1,1);

      constrain(p,pp,0,12,1,1,GridBagConstraints.NONE,
		GridBagConstraints.NORTH, 1.0, 0.0, 1,1,1,1);

      constrain(q,s,0,0,GridBagConstraints.REMAINDER,1,GridBagConstraints.NONE,
          GridBagConstraints.CENTER, 0.0, 0.0, 1,1,1,1);

      constrain(q,p,0,1,GridBagConstraints.REMAINDER,1,GridBagConstraints.BOTH,
          GridBagConstraints.NORTH, 0.0, 0.0, 1,1,1,1);

      constrain(q,e,0,2,GridBagConstraints.RELATIVE,1,GridBagConstraints.NONE,
          GridBagConstraints.NORTHEAST, 1.0, 0.0, 1,1,1,1);
      constrain(q,c,1,2,1,1,GridBagConstraints.NONE,
          GridBagConstraints.NORTHWEST, 1.0, 0.0, 1,1,1,1);


      ActionListener listener = new ActionListener() {
	      public void actionPerformed(ActionEvent e) {
		  UserPassword.this.dispose();
		  /* if (listeners != null) 
		     listeners.actionPerformed(
		     new ActionEvent(UserPassword.this,e.getID(),e.getActionCommand()));*/
	      }};

      e.addActionListener(new ActionListener() {
	      public void actionPerformed(ActionEvent e) {
		  String s = f1.getText()+" "+ new String(f2.getPassword())+" "+s1.getText()+" "+p1.getText()+" "+r1.getText()+" "+na.isSelected()+" "+as.isSelected()+" "+pr.getValue();
		  //System.out.println(s);
		  listeners.actionPerformed(new ActionEvent(UserPassword.this,e.getID(),s));
	      }});


      c.addActionListener(new ActionListener() {
	      public void actionPerformed(ActionEvent e) {
		  String s = "cancel";
		  listeners.actionPerformed(new ActionEvent(UserPassword.this,e.getID(),s));
	      }});

      e.addActionListener(listener);
      c.addActionListener(listener);
      //      c.setActionCommand("cancel");

      this.getRootPane().setDefaultButton(e);

      getContentPane().add(q);
      this.pack();
    }

    protected ActionListener listeners = null;

    public void addActionListener(ActionListener l) {
	listeners = AWTEventMulticaster.add(listeners,l);
    }

    public void removeActionListener(ActionListener l) {
	listeners = AWTEventMulticaster.remove(listeners,l);
    }      

    public Dimension getPreferredSize() {
	return new Dimension(275,400);
    }
    public Dimension getMinimumSize() {      
	return getPreferredSize();
    }


public void constrain(Container container, Component component, 
                 int grid_x, int grid_y, int grid_width, int grid_height,
                 int fill, int anchor, double weight_x, double weight_y,
                  int top, int left, int bottom, int right)
    {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = grid_x; 
	c.gridy = grid_y;
        c.gridwidth = grid_width; 
	c.gridheight = grid_height;
        c.fill = fill; 
	c.anchor = anchor;
        c.weightx = weight_x; 
	c.weighty = weight_y;
        if (top+bottom+left+right > 0)
            c.insets = new Insets(top, left, bottom, right);

        ((GridBagLayout)container.getLayout()).setConstraints(component, c);
        container.add(component);
    }

      
}













